/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli;

import org.apache.commons.cli.CommandLine;
import org.apache.gravitino.cli.GravitinoConfig;
import org.apache.gravitino.cli.Main;

public class FullName {
    private final CommandLine line;
    private String metalakeEnv;
    private boolean matalakeSet = false;
    private boolean hasDisplayedMissingNameInfo = true;
    private boolean hasDisplayedMalformedInfo = true;

    public FullName(CommandLine line) {
        this.line = line;
    }

    public int getLevel() {
        if (this.line.hasOption("name")) {
            String[] names = this.line.getOptionValue("name").split("\\.");
            return names.length;
        }
        return -1;
    }

    public String getMetalakeName() {
        GravitinoConfig config = new GravitinoConfig(null);
        if (this.line.hasOption("metalake")) {
            return this.line.getOptionValue("metalake");
        }
        if (this.metalakeEnv == null && !this.matalakeSet) {
            this.metalakeEnv = System.getenv("GRAVITINO_METALAKE");
            this.matalakeSet = true;
        }
        if (this.metalakeEnv != null) {
            return this.metalakeEnv;
        }
        if (config.fileExists()) {
            config.read();
            String configName = config.getMetalakeName();
            if (configName != null) {
                return configName;
            }
        }
        System.err.println("Missing --metalake option.");
        Main.exit(-1);
        return null;
    }

    public String getCatalogName() {
        return this.getNamePart(0);
    }

    public String getSchemaName() {
        return this.getNamePart(1);
    }

    public String getModelName() {
        return this.getNamePart(2);
    }

    public String getTableName() {
        return this.getNamePart(2);
    }

    public String getTopicName() {
        return this.getNamePart(2);
    }

    public String getFilesetName() {
        return this.getNamePart(2);
    }

    public String getColumnName() {
        return this.getNamePart(3);
    }

    public String getName() {
        if (this.line.hasOption("name")) {
            return this.line.getOptionValue("name");
        }
        return null;
    }

    public Boolean hasName() {
        return this.line.hasOption("name");
    }

    public String getNamePart(int position) {
        if (this.line.hasOption("name")) {
            String[] names = this.line.getOptionValue("name").split("\\.");
            if (names.length <= position) {
                this.showMalformedInfo();
                return null;
            }
            return names[position];
        }
        this.showMissingNameInfo();
        return null;
    }

    public boolean hasNamePart(int partNo) {
        if (this.line.hasOption("name")) {
            int position = partNo;
            String[] names = this.line.getOptionValue("name").split("\\.");
            int length = names.length;
            return position <= length;
        }
        return false;
    }

    public boolean hasCatalogName() {
        return this.hasNamePart(1);
    }

    public boolean hasSchemaName() {
        return this.hasNamePart(2);
    }

    public boolean hasTableName() {
        return this.hasNamePart(3);
    }

    public boolean hasColumnName() {
        return this.hasNamePart(4);
    }

    private void showMissingNameInfo() {
        if (this.hasDisplayedMissingNameInfo) {
            System.err.println("Missing --name option.");
            this.hasDisplayedMissingNameInfo = false;
        }
    }

    private void showMalformedInfo() {
        if (this.hasDisplayedMalformedInfo) {
            System.err.println("Malformed entity name.");
            this.hasDisplayedMalformedInfo = false;
        }
    }
}

