/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.commands;

import java.util.Map;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.commands.ListProperties;
import org.apache.gravitino.client.GravitinoClient;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;
import org.apache.gravitino.exceptions.NoSuchTagException;
import org.apache.gravitino.tag.Tag;

public class ListTagProperties
extends ListProperties {
    protected final String metalake;
    protected final String tag;

    public ListTagProperties(CommandContext context, String metalake, String tag) {
        super(context);
        this.metalake = metalake;
        this.tag = tag;
    }

    @Override
    public void handle() {
        Tag gTag = null;
        try {
            GravitinoClient client = this.buildClient(this.metalake);
            gTag = client.getTag(this.tag);
        }
        catch (NoSuchMetalakeException err) {
            this.exitWithError("Unknown metalake name.");
        }
        catch (NoSuchTagException err) {
            this.exitWithError("Unknown tag.");
        }
        catch (Exception exp) {
            this.exitWithError(exp.getMessage());
        }
        Map<String, String> properties = gTag.properties();
        this.printProperties(properties);
    }
}

