/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.requests;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.dto.rel.ColumnDTO;
import org.apache.gravitino.dto.rel.DistributionDTO;
import org.apache.gravitino.dto.rel.SortOrderDTO;
import org.apache.gravitino.dto.rel.expressions.FunctionArg;
import org.apache.gravitino.dto.rel.indexes.IndexDTO;
import org.apache.gravitino.dto.rel.partitioning.Partitioning;
import org.apache.gravitino.rest.RESTRequest;

@JsonDeserialize(builder=TableCreateRequestBuilder.class)
public class TableCreateRequest
implements RESTRequest {
    @JsonProperty(value="name")
    private final String name;
    @Nullable
    @JsonProperty(value="comment")
    private final String comment;
    @JsonProperty(value="columns")
    private final ColumnDTO[] columns;
    @Nullable
    @JsonProperty(value="properties")
    private final Map<String, String> properties;
    @JsonProperty(value="sortOrders")
    @Nullable
    private final SortOrderDTO[] sortOrders;
    @JsonProperty(value="distribution")
    @Nullable
    private final DistributionDTO distribution;
    @Nullable
    @JsonProperty(value="partitioning")
    private final Partitioning[] partitioning;
    @Nullable
    @JsonProperty(value="indexes")
    private final IndexDTO[] indexes;

    public TableCreateRequest() {
        this(null, null, null, null, null, null, null, null);
    }

    public TableCreateRequest(String name, @Nullable String comment, ColumnDTO[] columns, @Nullable Map<String, String> properties, @Nullable SortOrderDTO[] sortOrders, @Nullable DistributionDTO distribution, @Nullable Partitioning[] partitioning, @Nullable IndexDTO[] indexes) {
        this.name = name;
        this.columns = columns;
        this.comment = comment;
        this.properties = properties;
        this.sortOrders = sortOrders;
        this.distribution = distribution;
        this.partitioning = partitioning;
        this.indexes = indexes;
    }

    @Override
    public void validate() throws IllegalArgumentException {
        Preconditions.checkArgument(StringUtils.isNotBlank(this.name), "\"name\" field is required and cannot be empty");
        Preconditions.checkArgument(this.columns != null && this.columns.length != 0, "\"columns\" field is required and cannot be empty");
        if (this.sortOrders != null) {
            Arrays.stream(this.sortOrders).forEach(sortOrder -> sortOrder.validate(this.columns));
        }
        if (this.distribution != null) {
            Arrays.stream((FunctionArg[])this.distribution.expressions()).forEach(expression -> expression.validate(this.columns));
        }
        if (this.partitioning != null) {
            Arrays.stream(this.partitioning).forEach(p -> p.validate(this.columns));
        }
        List autoIncrementCols = Arrays.stream(this.columns).map(column -> {
            column.validate();
            return column;
        }).filter(ColumnDTO::autoIncrement).collect(Collectors.toList());
        String autoIncrementColsStr = autoIncrementCols.stream().map(ColumnDTO::name).collect(Collectors.joining(",", "[", "]"));
        Preconditions.checkArgument(autoIncrementCols.size() <= 1, "Only one column can be auto-incremented. There are multiple auto-increment columns in your table: " + autoIncrementColsStr);
        if (this.indexes != null && this.indexes.length > 0) {
            Arrays.stream(this.indexes).forEach(index -> {
                Preconditions.checkArgument(index.type() != null, "Index type cannot be null");
                Preconditions.checkArgument(index.fieldNames().length > 0, "Index field names cannot be null");
            });
        }
    }

    public static TableCreateRequestBuilder builder() {
        return new TableCreateRequestBuilder();
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public String getComment() {
        return this.comment;
    }

    public ColumnDTO[] getColumns() {
        return this.columns;
    }

    @Nullable
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Nullable
    public SortOrderDTO[] getSortOrders() {
        return this.sortOrders;
    }

    @Nullable
    public DistributionDTO getDistribution() {
        return this.distribution;
    }

    @Nullable
    public Partitioning[] getPartitioning() {
        return this.partitioning;
    }

    @Nullable
    public IndexDTO[] getIndexes() {
        return this.indexes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableCreateRequest)) {
            return false;
        }
        TableCreateRequest other = (TableCreateRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getColumns(), other.getColumns())) {
            return false;
        }
        Map<String, String> this$properties = this.getProperties();
        Map<String, String> other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getSortOrders(), other.getSortOrders())) {
            return false;
        }
        DistributionDTO this$distribution = this.getDistribution();
        DistributionDTO other$distribution = other.getDistribution();
        if (this$distribution == null ? other$distribution != null : !((Object)this$distribution).equals(other$distribution)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getPartitioning(), other.getPartitioning())) {
            return false;
        }
        return Arrays.deepEquals(this.getIndexes(), other.getIndexes());
    }

    protected boolean canEqual(Object other) {
        return other instanceof TableCreateRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getColumns());
        Map<String, String> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getSortOrders());
        DistributionDTO $distribution = this.getDistribution();
        result = result * 59 + ($distribution == null ? 43 : ((Object)$distribution).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getPartitioning());
        result = result * 59 + Arrays.deepHashCode(this.getIndexes());
        return result;
    }

    public String toString() {
        return "TableCreateRequest(name=" + this.getName() + ", comment=" + this.getComment() + ", columns=" + Arrays.deepToString(this.getColumns()) + ", properties=" + this.getProperties() + ", sortOrders=" + Arrays.deepToString(this.getSortOrders()) + ", distribution=" + this.getDistribution() + ", partitioning=" + Arrays.deepToString(this.getPartitioning()) + ", indexes=" + Arrays.deepToString(this.getIndexes()) + ")";
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class TableCreateRequestBuilder {
        private String name;
        private String comment;
        private ColumnDTO[] columns;
        private Map<String, String> properties;
        private SortOrderDTO[] sortOrders;
        private DistributionDTO distribution;
        private Partitioning[] partitioning;
        private IndexDTO[] indexes;

        TableCreateRequestBuilder() {
        }

        @JsonProperty(value="name")
        public TableCreateRequestBuilder name(String name) {
            this.name = name;
            return this;
        }

        @JsonProperty(value="comment")
        public TableCreateRequestBuilder comment(@Nullable String comment) {
            this.comment = comment;
            return this;
        }

        @JsonProperty(value="columns")
        public TableCreateRequestBuilder columns(ColumnDTO[] columns) {
            this.columns = columns;
            return this;
        }

        @JsonProperty(value="properties")
        public TableCreateRequestBuilder properties(@Nullable Map<String, String> properties) {
            this.properties = properties;
            return this;
        }

        @JsonProperty(value="sortOrders")
        public TableCreateRequestBuilder sortOrders(@Nullable SortOrderDTO[] sortOrders) {
            this.sortOrders = sortOrders;
            return this;
        }

        @JsonProperty(value="distribution")
        public TableCreateRequestBuilder distribution(@Nullable DistributionDTO distribution) {
            this.distribution = distribution;
            return this;
        }

        @JsonProperty(value="partitioning")
        public TableCreateRequestBuilder partitioning(@Nullable Partitioning[] partitioning) {
            this.partitioning = partitioning;
            return this;
        }

        @JsonProperty(value="indexes")
        public TableCreateRequestBuilder indexes(@Nullable IndexDTO[] indexes) {
            this.indexes = indexes;
            return this;
        }

        public TableCreateRequest build() {
            return new TableCreateRequest(this.name, this.comment, this.columns, this.properties, this.sortOrders, this.distribution, this.partitioning, this.indexes);
        }

        public String toString() {
            return "TableCreateRequest.TableCreateRequestBuilder(name=" + this.name + ", comment=" + this.comment + ", columns=" + Arrays.deepToString(this.columns) + ", properties=" + this.properties + ", sortOrders=" + Arrays.deepToString(this.sortOrders) + ", distribution=" + this.distribution + ", partitioning=" + Arrays.deepToString(this.partitioning) + ", indexes=" + Arrays.deepToString(this.indexes) + ")";
        }
    }
}

