/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.client;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.CookieHandler;
import java.net.HttpCookie;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.client.Authenticator;
import org.apache.hadoop.security.authentication.client.ConnectionConfigurator;
import org.apache.hadoop.security.authentication.client.KerberosAuthenticator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticatedURL {
    private static final Logger LOG = LoggerFactory.getLogger(AuthenticatedURL.class);
    public static final String AUTH_COOKIE = "hadoop.auth";
    private static Class<? extends Authenticator> DEFAULT_AUTHENTICATOR = KerberosAuthenticator.class;
    private Authenticator authenticator;
    private ConnectionConfigurator connConfigurator;

    public static void setDefaultAuthenticator(Class<? extends Authenticator> authenticator) {
        DEFAULT_AUTHENTICATOR = authenticator;
    }

    public static Class<? extends Authenticator> getDefaultAuthenticator() {
        return DEFAULT_AUTHENTICATOR;
    }

    public AuthenticatedURL() {
        this(null);
    }

    public AuthenticatedURL(Authenticator authenticator) {
        this(authenticator, null);
    }

    public AuthenticatedURL(Authenticator authenticator, ConnectionConfigurator connConfigurator) {
        try {
            this.authenticator = authenticator != null ? authenticator : DEFAULT_AUTHENTICATOR.newInstance();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        this.connConfigurator = connConfigurator;
        this.authenticator.setConnectionConfigurator(connConfigurator);
    }

    protected Authenticator getAuthenticator() {
        return this.authenticator;
    }

    public HttpURLConnection openConnection(URL url, Token token) throws IOException, AuthenticationException {
        if (url == null) {
            throw new IllegalArgumentException("url cannot be NULL");
        }
        if (!url.getProtocol().equalsIgnoreCase("http") && !url.getProtocol().equalsIgnoreCase("https")) {
            throw new IllegalArgumentException("url must be for a HTTP or HTTPS resource");
        }
        if (token == null) {
            throw new IllegalArgumentException("token cannot be NULL");
        }
        this.authenticator.authenticate(url, token);
        return token.openConnection(url, this.connConfigurator);
    }

    public static void injectToken(HttpURLConnection conn, Token token) {
        HttpCookie authCookie = token.cookieHandler.getAuthCookie();
        if (authCookie != null) {
            conn.addRequestProperty("Cookie", authCookie.toString());
        }
    }

    public static void extractToken(HttpURLConnection conn, Token token) throws IOException, AuthenticationException {
        int respCode = conn.getResponseCode();
        if (respCode != 200 && respCode != 201 && respCode != 202) {
            if (respCode == 404) {
                LOG.trace("Setting token value to null ({}), resp={}", (Object)token, (Object)respCode);
                token.set(null);
                throw new FileNotFoundException(conn.getURL().toString());
            }
            LOG.trace("Setting token value to null ({}), resp={}", (Object)token, (Object)respCode);
            token.set(null);
            throw new AuthenticationException("Authentication failed, URL: " + conn.getURL() + ", status: " + conn.getResponseCode() + ", message: " + conn.getResponseMessage());
        }
        token.cookieHandler.put(null, conn.getHeaderFields());
    }

    public static class Token {
        private final AuthCookieHandler cookieHandler = new AuthCookieHandler();

        public Token() {
        }

        public Token(String tokenStr) {
            if (tokenStr == null) {
                throw new IllegalArgumentException("tokenStr cannot be null");
            }
            this.set(tokenStr);
        }

        public boolean isSet() {
            return this.cookieHandler.getAuthCookie() != null;
        }

        void set(String tokenStr) {
            this.cookieHandler.setAuthCookieValue(tokenStr);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        HttpURLConnection openConnection(URL url, ConnectionConfigurator connConfigurator) throws IOException {
            Class<CookieHandler> clazz = CookieHandler.class;
            synchronized (CookieHandler.class) {
                HttpURLConnection conn;
                CookieHandler current = CookieHandler.getDefault();
                CookieHandler.setDefault(this.cookieHandler);
                try {
                    conn = (HttpURLConnection)url.openConnection();
                }
                finally {
                    CookieHandler.setDefault(current);
                }
                // ** MonitorExit[var4_3] (shouldn't be in output)
                if (connConfigurator != null) {
                    connConfigurator.configure(conn);
                }
                return conn;
            }
        }

        public String toString() {
            String value = "";
            HttpCookie authCookie = this.cookieHandler.getAuthCookie();
            if (authCookie != null && (value = authCookie.getValue()).startsWith("\"")) {
                value = value.substring(1, value.length() - 1);
            }
            return value;
        }
    }

    private static class AuthCookieHandler
    extends CookieHandler {
        private HttpCookie authCookie;
        private Map<String, List<String>> cookieHeaders = Collections.emptyMap();

        private AuthCookieHandler() {
        }

        @Override
        public synchronized Map<String, List<String>> get(URI uri, Map<String, List<String>> requestHeaders) throws IOException {
            this.getAuthCookie();
            return this.cookieHeaders;
        }

        @Override
        public void put(URI uri, Map<String, List<String>> responseHeaders) {
            List<String> headers = responseHeaders.get("Set-Cookie");
            if (headers != null) {
                for (String header : headers) {
                    List<HttpCookie> cookies;
                    try {
                        cookies = HttpCookie.parse(header);
                    }
                    catch (IllegalArgumentException iae) {
                        LOG.debug("Cannot parse cookie header: " + header, (Throwable)iae);
                        continue;
                    }
                    for (HttpCookie cookie : cookies) {
                        if (!AuthenticatedURL.AUTH_COOKIE.equals(cookie.getName())) continue;
                        this.setAuthCookie(cookie);
                    }
                }
            }
        }

        private synchronized HttpCookie getAuthCookie() {
            if (this.authCookie != null && this.authCookie.hasExpired()) {
                this.setAuthCookie(null);
            }
            return this.authCookie;
        }

        private synchronized void setAuthCookie(HttpCookie cookie) {
            long maxAge;
            boolean valid;
            HttpCookie oldCookie = this.authCookie;
            this.authCookie = null;
            this.cookieHeaders = Collections.emptyMap();
            boolean bl = valid = cookie != null && !cookie.getValue().isEmpty() && !cookie.hasExpired();
            if (valid && (maxAge = cookie.getMaxAge()) != -1L) {
                cookie.setMaxAge(maxAge * 9L / 10L);
                boolean bl2 = valid = !cookie.hasExpired();
            }
            if (valid) {
                String value;
                if (cookie.getVersion() == 0 && !(value = cookie.getValue()).startsWith("\"")) {
                    value = "\"" + value + "\"";
                    cookie.setValue(value);
                }
                this.authCookie = cookie;
                this.cookieHeaders = new HashMap<String, List<String>>();
                this.cookieHeaders.put("Cookie", Arrays.asList(cookie.toString()));
            }
        }

        private void setAuthCookieValue(String value) {
            HttpCookie c = null;
            if (value != null) {
                c = new HttpCookie(AuthenticatedURL.AUTH_COOKIE, value);
            }
            this.setAuthCookie(c);
        }
    }
}

