/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.jdbc;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.gravitino.catalog.jdbc.operation.TableOperation;
import org.apache.gravitino.connector.BaseTable;
import org.apache.gravitino.connector.TableOperations;
import org.apache.gravitino.rel.Column;
import org.apache.gravitino.rel.SupportsPartitions;
import org.apache.gravitino.rel.expressions.sorts.SortOrder;
import org.apache.gravitino.rel.expressions.transforms.Transform;
import org.apache.gravitino.rel.indexes.Index;

public class JdbcTable
extends BaseTable {
    private String databaseName;
    private TableOperation tableOperation;

    private JdbcTable() {
    }

    protected TableOperations newOps() {
        if (ArrayUtils.isEmpty((Object[])this.partitioning)) {
            throw new UnsupportedOperationException("Table partition operation is not supported for non-partitioned table: " + this.name);
        }
        return this.tableOperation.createJdbcTablePartitionOperations(this);
    }

    public SupportsPartitions supportPartitions() throws UnsupportedOperationException {
        return (SupportsPartitions)this.ops();
    }

    public String databaseName() {
        return this.databaseName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "JdbcTable(databaseName=" + this.databaseName + ", tableOperation=" + this.tableOperation + ")";
    }

    static /* synthetic */ Column[] access$502(JdbcTable x0, Column[] x1) {
        x0.columns = x1;
        return x1;
    }

    static /* synthetic */ Transform[] access$602(JdbcTable x0, Transform[] x1) {
        x0.partitioning = x1;
        return x1;
    }

    static /* synthetic */ SortOrder[] access$802(JdbcTable x0, SortOrder[] x1) {
        x0.sortOrders = x1;
        return x1;
    }

    static /* synthetic */ Index[] access$902(JdbcTable x0, Index[] x1) {
        x0.indexes = x1;
        return x1;
    }

    public static class Builder
    extends BaseTable.BaseTableBuilder<Builder, JdbcTable> {
        private String databaseName;
        private TableOperation tableOperation;

        public Builder withDatabaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public Builder withTableOperation(TableOperation tableOperation) {
            this.tableOperation = tableOperation;
            return this;
        }

        private Builder() {
        }

        protected JdbcTable internalBuild() {
            JdbcTable jdbcTable = new JdbcTable();
            jdbcTable.name = this.name;
            jdbcTable.comment = this.comment;
            jdbcTable.properties = this.properties != null ? Maps.newHashMap((Map)this.properties) : Maps.newHashMap();
            jdbcTable.auditInfo = this.auditInfo;
            JdbcTable.access$502(jdbcTable, this.columns);
            JdbcTable.access$602(jdbcTable, this.partitioning);
            jdbcTable.distribution = this.distribution;
            JdbcTable.access$802(jdbcTable, this.sortOrders);
            JdbcTable.access$902(jdbcTable, this.indexes);
            jdbcTable.proxyPlugin = this.proxyPlugin;
            jdbcTable.databaseName = this.databaseName;
            jdbcTable.tableOperation = this.tableOperation;
            return jdbcTable;
        }

        public String comment() {
            return this.comment;
        }

        public Map<String, String> properties() {
            return this.properties;
        }
    }
}

