/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.service;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.apache.gravitino.Entity;
import org.apache.gravitino.HasIdentifier;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.exceptions.NoSuchEntityException;
import org.apache.gravitino.meta.FilesetEntity;
import org.apache.gravitino.storage.relational.mapper.FilesetMetaMapper;
import org.apache.gravitino.storage.relational.mapper.FilesetVersionMapper;
import org.apache.gravitino.storage.relational.mapper.OwnerMetaMapper;
import org.apache.gravitino.storage.relational.mapper.SecurableObjectMapper;
import org.apache.gravitino.storage.relational.mapper.TagMetadataObjectRelMapper;
import org.apache.gravitino.storage.relational.po.FilesetMaxVersionPO;
import org.apache.gravitino.storage.relational.po.FilesetPO;
import org.apache.gravitino.storage.relational.service.CommonMetaService;
import org.apache.gravitino.storage.relational.utils.ExceptionUtils;
import org.apache.gravitino.storage.relational.utils.POConverters;
import org.apache.gravitino.storage.relational.utils.SessionUtils;
import org.apache.gravitino.utils.NameIdentifierUtil;
import org.apache.gravitino.utils.NamespaceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilesetMetaService {
    private static final FilesetMetaService INSTANCE = new FilesetMetaService();
    private static final Logger LOG = LoggerFactory.getLogger(FilesetMetaService.class);

    public static FilesetMetaService getInstance() {
        return INSTANCE;
    }

    private FilesetMetaService() {
    }

    public FilesetPO getFilesetPOBySchemaIdAndName(Long schemaId, String filesetName) {
        FilesetPO filesetPO = SessionUtils.getWithoutCommit(FilesetMetaMapper.class, mapper -> mapper.selectFilesetMetaBySchemaIdAndName(schemaId, filesetName));
        if (filesetPO == null) {
            throw new NoSuchEntityException("No such %s entity: %s", new Object[]{Entity.EntityType.FILESET.name().toLowerCase(), filesetName});
        }
        return filesetPO;
    }

    public FilesetPO getFilesetPOById(Long filesetId) {
        FilesetPO filesetPO = SessionUtils.getWithoutCommit(FilesetMetaMapper.class, mapper -> mapper.selectFilesetMetaById(filesetId));
        return filesetPO;
    }

    public Long getFilesetIdBySchemaIdAndName(Long schemaId, String filesetName) {
        Long filesetId = SessionUtils.getWithoutCommit(FilesetMetaMapper.class, mapper -> mapper.selectFilesetIdBySchemaIdAndName(schemaId, filesetName));
        if (filesetId == null) {
            throw new NoSuchEntityException("No such %s entity: %s", new Object[]{Entity.EntityType.FILESET.name().toLowerCase(), filesetName});
        }
        return filesetId;
    }

    public FilesetEntity getFilesetByIdentifier(NameIdentifier identifier) {
        NameIdentifierUtil.checkFileset(identifier);
        String filesetName = identifier.name();
        Long schemaId = CommonMetaService.getInstance().getParentEntityIdByNamespace(identifier.namespace());
        FilesetPO filesetPO = this.getFilesetPOBySchemaIdAndName(schemaId, filesetName);
        return POConverters.fromFilesetPO(filesetPO, identifier.namespace());
    }

    public List<FilesetEntity> listFilesetsByNamespace(Namespace namespace) {
        NamespaceUtil.checkFileset(namespace);
        Long schemaId = CommonMetaService.getInstance().getParentEntityIdByNamespace(namespace);
        List filesetPOs = SessionUtils.getWithoutCommit(FilesetMetaMapper.class, mapper -> mapper.listFilesetPOsBySchemaId(schemaId));
        return POConverters.fromFilesetPOs(filesetPOs, namespace);
    }

    public void insertFileset(FilesetEntity filesetEntity, boolean overwrite) throws IOException {
        try {
            NameIdentifierUtil.checkFileset(filesetEntity.nameIdentifier());
            FilesetPO.Builder builder = FilesetPO.builder();
            this.fillFilesetPOBuilderParentEntityId(builder, filesetEntity.namespace());
            FilesetPO po = POConverters.initializeFilesetPOWithVersion(filesetEntity, builder);
            SessionUtils.doMultipleWithCommit(() -> SessionUtils.doWithoutCommit(FilesetMetaMapper.class, mapper -> {
                if (overwrite) {
                    mapper.insertFilesetMetaOnDuplicateKeyUpdate(po);
                } else {
                    mapper.insertFilesetMeta(po);
                }
            }), () -> SessionUtils.doWithoutCommit(FilesetVersionMapper.class, mapper -> {
                if (overwrite) {
                    mapper.insertFilesetVersionsOnDuplicateKeyUpdate(po.getFilesetVersionPOs());
                } else {
                    mapper.insertFilesetVersions(po.getFilesetVersionPOs());
                }
            }));
        }
        catch (RuntimeException re) {
            ExceptionUtils.checkSQLException(re, Entity.EntityType.FILESET, filesetEntity.nameIdentifier().toString());
            throw re;
        }
    }

    public <E extends Entity & HasIdentifier> FilesetEntity updateFileset(NameIdentifier identifier, Function<E, E> updater) throws IOException {
        Integer updateResult;
        NameIdentifierUtil.checkFileset(identifier);
        String filesetName = identifier.name();
        Long schemaId = CommonMetaService.getInstance().getParentEntityIdByNamespace(identifier.namespace());
        FilesetPO oldFilesetPO = this.getFilesetPOBySchemaIdAndName(schemaId, filesetName);
        FilesetEntity oldFilesetEntity = POConverters.fromFilesetPO(oldFilesetPO, identifier.namespace());
        FilesetEntity newEntity = (FilesetEntity)updater.apply(oldFilesetEntity);
        Preconditions.checkArgument((boolean)Objects.equals(oldFilesetEntity.id(), newEntity.id()), (String)"The updated fileset entity id: %s should be same with the table entity id before: %s", (Object)newEntity.id(), (Object)oldFilesetEntity.id());
        try {
            boolean checkNeedUpdateVersion = POConverters.checkFilesetVersionNeedUpdate(oldFilesetPO.getFilesetVersionPOs(), newEntity);
            FilesetPO newFilesetPO = POConverters.updateFilesetPOWithVersion(oldFilesetPO, newEntity, checkNeedUpdateVersion);
            if (checkNeedUpdateVersion) {
                SessionUtils.doMultipleWithCommit(() -> SessionUtils.doWithoutCommit(FilesetVersionMapper.class, mapper -> mapper.insertFilesetVersions(newFilesetPO.getFilesetVersionPOs())), () -> SessionUtils.doWithoutCommit(FilesetMetaMapper.class, mapper -> mapper.updateFilesetMeta(newFilesetPO, oldFilesetPO)));
                updateResult = 1;
            } else {
                updateResult = SessionUtils.doWithCommitAndFetchResult(FilesetMetaMapper.class, mapper -> mapper.updateFilesetMeta(newFilesetPO, oldFilesetPO));
            }
        }
        catch (RuntimeException re) {
            ExceptionUtils.checkSQLException(re, Entity.EntityType.FILESET, newEntity.nameIdentifier().toString());
            throw re;
        }
        if (updateResult > 0) {
            return newEntity;
        }
        throw new IOException("Failed to update the entity: " + identifier);
    }

    public boolean deleteFileset(NameIdentifier identifier) {
        NameIdentifierUtil.checkFileset(identifier);
        String filesetName = identifier.name();
        Long schemaId = CommonMetaService.getInstance().getParentEntityIdByNamespace(identifier.namespace());
        Long filesetId = this.getFilesetIdBySchemaIdAndName(schemaId, filesetName);
        SessionUtils.doMultipleWithCommit(() -> SessionUtils.doWithoutCommit(FilesetMetaMapper.class, mapper -> mapper.softDeleteFilesetMetasByFilesetId(filesetId)), () -> SessionUtils.doWithoutCommit(FilesetVersionMapper.class, mapper -> mapper.softDeleteFilesetVersionsByFilesetId(filesetId)), () -> SessionUtils.doWithoutCommit(OwnerMetaMapper.class, mapper -> mapper.softDeleteOwnerRelByMetadataObjectIdAndType(filesetId, MetadataObject.Type.FILESET.name())), () -> SessionUtils.doWithoutCommit(SecurableObjectMapper.class, mapper -> mapper.softDeleteObjectRelsByMetadataObject(filesetId, MetadataObject.Type.FILESET.name())), () -> SessionUtils.doWithoutCommit(TagMetadataObjectRelMapper.class, mapper -> mapper.softDeleteTagMetadataObjectRelsByMetadataObject(filesetId, MetadataObject.Type.FILESET.name())));
        return true;
    }

    public int deleteFilesetAndVersionMetasByLegacyTimeline(Long legacyTimeline, int limit) {
        int filesetDeletedCount = SessionUtils.doWithCommitAndFetchResult(FilesetMetaMapper.class, mapper -> mapper.deleteFilesetMetasByLegacyTimeline(legacyTimeline, limit));
        int filesetVersionDeletedCount = SessionUtils.doWithCommitAndFetchResult(FilesetVersionMapper.class, mapper -> mapper.deleteFilesetVersionsByLegacyTimeline(legacyTimeline, limit));
        return filesetDeletedCount + filesetVersionDeletedCount;
    }

    public int deleteFilesetVersionsByRetentionCount(Long versionRetentionCount, int limit) {
        List filesetCurVersions = SessionUtils.getWithoutCommit(FilesetVersionMapper.class, mapper -> mapper.selectFilesetVersionsByRetentionCount(versionRetentionCount));
        int totalDeletedCount = 0;
        for (FilesetMaxVersionPO filesetCurVersion : filesetCurVersions) {
            long versionRetentionLine = filesetCurVersion.getVersion() - versionRetentionCount;
            int deletedCount = SessionUtils.doWithCommitAndFetchResult(FilesetVersionMapper.class, mapper -> mapper.softDeleteFilesetVersionsByRetentionLine(filesetCurVersion.getFilesetId(), versionRetentionLine, limit));
            totalDeletedCount += deletedCount;
            LOG.info("Soft delete filesetVersions count: {} which versions are older than or equal to versionRetentionLine: {}, the current filesetId and version is: <{}, {}>.", new Object[]{deletedCount, versionRetentionLine, filesetCurVersion.getFilesetId(), filesetCurVersion.getVersion()});
        }
        return totalDeletedCount;
    }

    private void fillFilesetPOBuilderParentEntityId(FilesetPO.Builder builder, Namespace namespace) {
        NamespaceUtil.checkFileset(namespace);
        Long[] parentEntityIds = CommonMetaService.getInstance().getParentEntityIdsByNamespace(namespace);
        builder.withMetalakeId(parentEntityIds[0]);
        builder.withCatalogId(parentEntityIds[1]);
        builder.withSchemaId(parentEntityIds[2]);
    }
}

