/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.core;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.huaweicloud.sdk.core.CustomizationConfigure;
import com.huaweicloud.sdk.core.SdkResponse;
import com.huaweicloud.sdk.core.SdkSerializable;
import com.huaweicloud.sdk.core.SdkStreamRequest;
import com.huaweicloud.sdk.core.SdkStreamResponse;
import com.huaweicloud.sdk.core.auth.ICredential;
import com.huaweicloud.sdk.core.exception.HostUnreachableException;
import com.huaweicloud.sdk.core.exception.SdkException;
import com.huaweicloud.sdk.core.exception.ServerResponseException;
import com.huaweicloud.sdk.core.exception.ServiceResponseException;
import com.huaweicloud.sdk.core.exchange.ApiReference;
import com.huaweicloud.sdk.core.exchange.SdkExchange;
import com.huaweicloud.sdk.core.exchange.SdkExchangeCache;
import com.huaweicloud.sdk.core.http.Field;
import com.huaweicloud.sdk.core.http.HttpClient;
import com.huaweicloud.sdk.core.http.HttpConfig;
import com.huaweicloud.sdk.core.http.HttpRequest;
import com.huaweicloud.sdk.core.http.HttpRequestDef;
import com.huaweicloud.sdk.core.http.HttpResponse;
import com.huaweicloud.sdk.core.http.LocationType;
import com.huaweicloud.sdk.core.http.SdkFormDataBody;
import com.huaweicloud.sdk.core.impl.DefaultHttpClient;
import com.huaweicloud.sdk.core.utils.CastUtils;
import com.huaweicloud.sdk.core.utils.ExceptionUtils;
import com.huaweicloud.sdk.core.utils.JsonUtils;
import com.huaweicloud.sdk.core.utils.StringUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Stack;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HcClient
implements CustomizationConfigure {
    private static final Logger logger = LoggerFactory.getLogger(HcClient.class);
    private final HttpClient httpClient;
    private final AtomicInteger endpointIndex = new AtomicInteger(0);
    private List<String> endpoints;
    private ICredential credential;
    private final HttpConfig httpConfig;
    private Map<String, String> extraHeader;

    private HcClient(HttpConfig httpConfig, HttpClient httpClient, ICredential credential, List<String> endpoints) {
        this.httpConfig = httpConfig;
        this.httpClient = httpClient;
        this.credential = credential;
        this.endpoints = endpoints;
    }

    HcClient(HttpConfig httpConfig, HttpClient httpClient) {
        this.httpConfig = httpConfig;
        this.httpClient = httpClient;
    }

    public HcClient(HttpConfig httpConfig) {
        this.httpConfig = httpConfig;
        this.httpClient = new DefaultHttpClient(this.httpConfig);
    }

    public HcClient withEndpoints(List<String> endpoints) {
        this.endpoints = endpoints;
        return this;
    }

    public HcClient withCredential(ICredential credential) {
        this.credential = credential;
        return this;
    }

    public ICredential getCredential() {
        return this.credential;
    }

    public HttpConfig getHttpConfig() {
        return this.httpConfig;
    }

    public HcClient overrideEndpoints(List<String> endpoints) {
        return new HcClient(this.httpConfig, this.httpClient, this.credential, endpoints);
    }

    public HcClient overrideCredential(ICredential credential) {
        return new HcClient(this.httpConfig, this.httpClient, credential, this.endpoints);
    }

    public HcClient preInvoke(Map<String, String> extraHeader) {
        HcClient client = new HcClient(this.httpConfig, this.httpClient, this.credential, this.endpoints);
        client.extraHeader = extraHeader;
        return client;
    }

    public <ReqT, ResT> ResT syncInvokeHttp(ReqT request, HttpRequestDef<ReqT, ResT> reqDef) throws ServiceResponseException {
        return this.syncInvokeHttp(request, reqDef, new SdkExchange());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <ReqT, ResT> ResT syncInvokeHttp(ReqT request, HttpRequestDef<ReqT, ResT> reqDef, SdkExchange exchange) throws ServiceResponseException {
        if (Objects.isNull(exchange)) {
            throw new IllegalArgumentException("SdkExchange is null");
        }
        exchange.setApiReference(new ApiReference().withName(reqDef.getName()).withMethod(reqDef.getMethod().toString()).withUri(reqDef.getUri()));
        String exchangeId = SdkExchangeCache.putExchange(exchange);
        try {
            HttpResponse httpResponse;
            HttpRequest httpRequest;
            while (true) {
                try {
                    httpRequest = this.buildRequest(request, reqDef);
                    if (StringUtils.isEmpty(httpRequest.getHeader("Authorization")) && Objects.nonNull(this.credential)) {
                        httpRequest = this.credential.syncProcessAuthRequest(httpRequest, this.httpClient);
                    }
                    httpRequest = httpRequest.builder().addHeader("SDK_EXCHANGE", exchangeId).build();
                    httpResponse = this.httpClient.syncInvokeHttp(httpRequest);
                }
                catch (HostUnreachableException unreachableException) {
                    if (this.endpointIndex.intValue() < this.endpoints.size() - 1) {
                        this.endpointIndex.incrementAndGet();
                        continue;
                    }
                    this.endpointIndex.set(0);
                    throw unreachableException;
                }
                break;
            }
            this.printAccessLog(httpRequest, httpResponse, exchange);
            this.handleException(httpRequest, httpResponse);
            ResT ResT = this.extractResponse(httpResponse, reqDef);
            return ResT;
        }
        finally {
            SdkExchangeCache.removeExchange(exchangeId);
        }
    }

    public <ReqT, ResT> CompletableFuture<ResT> asyncInvokeHttp(ReqT request, HttpRequestDef<ReqT, ResT> reqDef) {
        return this.asyncInvokeHttp(request, reqDef, new SdkExchange());
    }

    public <ReqT, ResT> CompletableFuture<ResT> asyncInvokeHttp(ReqT request, HttpRequestDef<ReqT, ResT> reqDef, SdkExchange exchange) {
        HttpRequest httpRequest;
        if (Objects.isNull(exchange)) {
            return CompletableFuture.supplyAsync(() -> {
                throw new IllegalArgumentException("SdkExchange is null");
            }, this.httpConfig.getExecutorService());
        }
        exchange.setApiReference(new ApiReference().withName(reqDef.getName()).withMethod(reqDef.getMethod().toString()).withUri(reqDef.getUri()));
        AtomicReference exchangeIdRef = new AtomicReference();
        try {
            httpRequest = this.buildRequest(request, reqDef);
        }
        catch (SdkException e) {
            CompletableFuture future = new CompletableFuture();
            future.completeExceptionally(e);
            return future;
        }
        HttpRequest finalHttpRequest = httpRequest;
        CompletableFuture<HttpRequest> validHttpRequestStage = CompletableFuture.supplyAsync(() -> finalHttpRequest, this.httpConfig.getExecutorService());
        if (StringUtils.isEmpty(httpRequest.getHeader("Authorization")) && Objects.nonNull(this.credential)) {
            validHttpRequestStage = this.credential.processAuthRequest(httpRequest, this.httpClient);
        }
        return validHttpRequestStage.thenComposeAsync(validHttpRequest -> {
            String id = SdkExchangeCache.putExchange(exchange);
            exchangeIdRef.set(id);
            HttpRequest finalValidHttpRequest = validHttpRequest = validHttpRequest.builder().addHeader("SDK_EXCHANGE", id).build();
            return ((CompletableFuture)this.httpClient.asyncInvokeHttp((HttpRequest)validHttpRequest).thenApplyAsync(httpResponse -> {
                this.printAccessLog(finalValidHttpRequest, (HttpResponse)httpResponse, exchange);
                this.handleException(finalValidHttpRequest, (HttpResponse)httpResponse);
                return this.extractResponse((HttpResponse)httpResponse, reqDef);
            }, (Executor)this.httpConfig.getExecutorService())).whenCompleteAsync((r, e) -> SdkExchangeCache.removeExchange((String)exchangeIdRef.get()), (Executor)this.httpConfig.getExecutorService());
        }, (Executor)this.httpConfig.getExecutorService());
    }

    protected <ReqT, ResT> HttpRequest buildRequest(ReqT request, HttpRequestDef<ReqT, ResT> reqDef) {
        String endpoint = this.endpoints.get(this.endpointIndex.intValue());
        HttpRequest.HttpRequestBuilder httpRequestBuilder = HttpRequest.newBuilder();
        httpRequestBuilder.withMethod(reqDef.getMethod()).withContentType(reqDef.getContentType()).withEndpoint(endpoint).withPath(reqDef.getUri());
        for (Field<ReqT, ?> field : reqDef.getRequestFields()) {
            Optional<?> reqValueOption = this.httpConfig.isIgnoreRequiredValidation() ? field.readValueNoValidation(request) : field.readValue(request);
            if (!reqValueOption.isPresent()) continue;
            Object reqValue = reqValueOption.get();
            if (field.getLocation() == LocationType.Header) {
                httpRequestBuilder.addHeader(field.getName(), this.convertToStringParams(reqValue));
                continue;
            }
            if (field.getLocation() == LocationType.Query) {
                this.buildQueryParams(httpRequestBuilder, field.getName(), reqValue);
                continue;
            }
            if (field.getLocation() == LocationType.Path) {
                httpRequestBuilder.addPathParam(field.getName(), this.convertToStringParams(reqValue));
                continue;
            }
            if (field.getLocation() == LocationType.Body) {
                this.buildRequestBody(httpRequestBuilder, reqValue);
                continue;
            }
            if (field.getLocation() != LocationType.Cname) continue;
            try {
                URL url = new URL(endpoint.replace("\r", "").replace("\n", ""));
                StringBuilder endpointBuilder = new StringBuilder();
                endpointBuilder.append(url.getProtocol()).append("://").append(reqValue).append(".").append(url.getHost());
                if (!StringUtils.isEmpty(url.getPath())) {
                    endpointBuilder.append("/").append(url.getPath());
                }
                httpRequestBuilder.withEndpoint(endpointBuilder.toString());
            }
            catch (MalformedURLException e) {
                throw new SdkException("Failed to parse endpoint");
            }
        }
        if (request instanceof SdkStreamRequest) {
            httpRequestBuilder.withBody(((SdkStreamRequest)request).extractBody());
        }
        httpRequestBuilder.addHeader("User-Agent", "huaweicloud-usdk-java/3.0");
        if (Objects.nonNull(this.extraHeader) && this.extraHeader.size() > 0) {
            this.extraHeader.forEach(httpRequestBuilder::addHeader);
        }
        if (Objects.nonNull(this.httpConfig) && Objects.nonNull((Object)this.httpConfig.getSigningAlgorithm())) {
            httpRequestBuilder.withSigningAlgorithm(this.httpConfig.getSigningAlgorithm());
        }
        return httpRequestBuilder.build();
    }

    private void buildRequestBody(HttpRequest.HttpRequestBuilder httpRequestBuilder, Object reqValue) {
        if (reqValue instanceof SdkFormDataBody) {
            httpRequestBuilder.withFormDataPart(((SdkFormDataBody)reqValue).buildFormData());
        } else if (reqValue instanceof SdkSerializable) {
            httpRequestBuilder.withBodyAsString(((SdkSerializable)reqValue).serialize());
        } else {
            httpRequestBuilder.withBodyAsString(JsonUtils.toJSON(reqValue));
        }
    }

    private void buildQueryParams(HttpRequest.HttpRequestBuilder httpRequestBuilder, String fieldName, Object reqValue) {
        if (reqValue instanceof Collection) {
            httpRequestBuilder.addQueryParam(fieldName, this.buildCollectionQueryParams(reqValue));
        } else if (reqValue instanceof Map) {
            Map<String, List<String>> params = this.buildMapQueryParamsLoop(fieldName, (Map)reqValue);
            for (Map.Entry<String, List<String>> entry : params.entrySet()) {
                httpRequestBuilder.addQueryParam(entry.getKey(), entry.getValue());
            }
        } else {
            httpRequestBuilder.addQueryParam(fieldName, Collections.singletonList(this.convertToStringParams(reqValue)));
        }
    }

    private String convertToStringParams(Object reqValue) {
        String value = reqValue instanceof OffsetDateTime ? ((OffsetDateTime)reqValue).format(DateTimeFormatter.ISO_OFFSET_DATE_TIME) : reqValue.toString();
        return value;
    }

    private List<String> buildCollectionQueryParams(Object reqValue) {
        return ((List)reqValue).stream().map(this::convertToStringParams).collect(Collectors.toList());
    }

    private Map<String, List<String>> buildMapQueryParamsLoop(String key, Map<?, ?> reqValue) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        Stack stack = new Stack();
        reqValue.forEach((k, v) -> stack.push(this.buildMapQueryParams(key, k.toString(), v)));
        while (!stack.isEmpty()) {
            Map temp = (Map)stack.pop();
            result.putAll(temp);
        }
        return result;
    }

    private Map<String, List<String>> buildMapQueryParams(String key, String entryKey, Object entryValue) {
        HashMap<String, List<String>> res = new HashMap<String, List<String>>();
        if (entryValue instanceof Map) {
            ((Map)entryValue).forEach((k, v) -> res.putAll(this.buildMapQueryParams(key + "[" + entryKey + "]", k.toString(), v)));
        } else if (entryValue instanceof Collection) {
            res.put(key + "[" + entryKey + "]", this.buildCollectionQueryParams(entryValue));
        } else {
            res.put(key + "[" + entryKey + "]", Collections.singletonList(this.convertToStringParams(entryValue)));
        }
        return res;
    }

    private void handleException(HttpRequest httpRequest, HttpResponse httpResponse) {
        if (httpResponse.getStatusCode() >= 400) {
            ServiceResponseException currException = ServiceResponseException.mapException(httpResponse.getStatusCode(), ExceptionUtils.extractErrorMessage(httpResponse));
            logger.error("ServiceResponseException occurred. Host: {} Uri: {} ServiceResponseException: {}", new Object[]{httpRequest.getUrl().getHost(), httpRequest.getUrl(), currException.toString()});
            throw currException;
        }
    }

    private <ReqT, ResT> ResT extractResponse(HttpResponse httpResponse, HttpRequestDef<ReqT, ResT> reqDef) {
        int code = httpResponse.getStatusCode();
        try {
            Object resT;
            String stringResult = httpResponse.getBodyAsString();
            String respContentType = httpResponse.getContentType();
            if (Objects.nonNull(respContentType) && (respContentType.startsWith("application/octet-stream") || respContentType.startsWith("image") || respContentType.startsWith("application/bson"))) {
                resT = reqDef.getResponseType().newInstance();
                resT = CastUtils.cast(((SdkStreamResponse)resT).parseBody(httpResponse.getBody()));
            } else if (SdkSerializable.class.isAssignableFrom(reqDef.getResponseType())) {
                resT = this.deserializeSerializableResponse(reqDef.getResponseType(), stringResult);
            } else if (!reqDef.hasResponseField("body")) {
                resT = JsonUtils.toObjectIgnoreUnknown(stringResult, reqDef.getResponseType());
                if (Objects.isNull(resT)) {
                    resT = reqDef.getResponseType().newInstance();
                }
                if (reqDef.hasResponseField(String.valueOf(code))) {
                    Field<ResT, ?> resTField2 = reqDef.getResponseField(String.valueOf(code));
                    resTField2.writeValueSafe(resT, JsonUtils.toObjectIgnoreUnknown(stringResult, resTField2.getFieldType()), resTField2.getFieldType());
                }
            } else {
                resT = reqDef.getResponseType().newInstance();
                Field<ResT, ?> responseField = reqDef.getResponseField("body");
                Object obj = this.responseToObject(stringResult, responseField);
                responseField.writeValueSafe(resT, obj, responseField.getFieldType());
                if (reqDef.hasResponseField(String.valueOf(code))) {
                    Field<ResT, ?> resTField3 = reqDef.getResponseField(String.valueOf(code));
                    resTField3.writeValueSafe(resT, obj, resTField3.getFieldType());
                }
            }
            Object finalResT = resT;
            reqDef.getResponseFields().forEach(resTField -> {
                if (resTField.getLocation() == LocationType.Header) {
                    this.fillHeaderField(httpResponse, finalResT, (Field)resTField);
                }
            });
            if (finalResT instanceof SdkResponse) {
                ((SdkResponse)finalResT).setHttpStatusCode(httpResponse.getStatusCode());
            }
            return finalResT;
        }
        catch (IllegalAccessException | InstantiationException e) {
            logger.error("Can not create response instance", (Throwable)e);
            return null;
        }
        catch (SdkException e) {
            logger.error("can not parse json result to response object", (Throwable)e);
            throw new ServerResponseException(httpResponse.getStatusCode(), null, "json parse error", httpResponse.getHeader("X-Request-Id"));
        }
    }

    private <ResT> ResT deserializeSerializableResponse(Class<ResT> clazz, String string) throws InstantiationException, IllegalAccessException {
        ResT instance = clazz.newInstance();
        return (ResT)((SdkSerializable)instance).deserialize(string);
    }

    public <ResT> Object responseToObject(String respBody, Field<ResT, ?> responseField) {
        Object obj = responseField.getFieldType().isAssignableFrom(List.class) ? JsonUtils.toListObject(respBody, responseField.getInnerContainerType()) : (responseField.getFieldType().isAssignableFrom(Map.class) ? JsonUtils.toMapObject(respBody, responseField.getInnerContainerType()) : respBody);
        return obj;
    }

    private <ResT> void fillHeaderField(HttpResponse httpResponse, ResT wrapperResponse, Field<ResT, ?> field) {
        List<String> infos = httpResponse.getHeaders().get(field.getName());
        if (Objects.nonNull(infos) && infos.size() > 0) {
            if (field.getFieldType().isAssignableFrom(List.class)) {
                field.writeValueSafe(wrapperResponse, infos, List.class);
            } else {
                field.writeValueSafe(wrapperResponse, infos.get(0), String.class);
                if (infos.size() > 1) {
                    logger.error("field {} passed list {}, but configured as single value", (Object)field.getName(), (Object)String.join((CharSequence)",", infos));
                }
            }
        } else {
            logger.warn("field {} in header read response value is empty", (Object)field.getName());
        }
    }

    @Override
    public void configJson(Consumer<ObjectMapper> func) {
        func.accept(JsonUtils.getDefaultMapper());
    }

    public void printAccessLog(HttpRequest httpRequest, HttpResponse httpResponse, SdkExchange exchange) {
        String requestId = Objects.isNull(httpResponse.getHeader("X-Request-Id")) ? "null" : httpResponse.getHeader("X-Request-Id");
        AccessLog.get().info("\"{} {}\" {} {} {} {}", new Object[]{httpRequest.getMethod(), httpRequest.getUrl(), httpResponse.getStatusCode(), httpResponse.getContentLength(), requestId, Objects.nonNull(exchange) && Objects.nonNull(exchange.getApiTimer()) ? Long.valueOf(exchange.getApiTimer().getDurationMs()) : ""});
    }

    public static class AccessLog {
        private static final Logger logger = LoggerFactory.getLogger((String)"HuaweiCloud-SDK-Access");

        public static Logger get() {
            return logger;
        }
    }
}

