/*
 * Decompiled with CFR 0.152.
 */
package io.greptime.rpc.interceptors;

import com.netflix.concurrency.limits.Limiter;
import io.greptime.common.util.MetricsUtil;
import io.greptime.rpc.limit.RequestLimitCtx;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;

public class ClientRequestLimitInterceptor
implements ClientInterceptor {
    private static final Status LIMIT_EXCEEDED_STATUS = Status.UNAVAILABLE.withDescription("Client limit reached");
    private static final AtomicBoolean LIMIT_SWITCH = new AtomicBoolean(true);
    private final Limiter<RequestLimitCtx> limiter;
    private final Function<String, Boolean> filter;

    public ClientRequestLimitInterceptor(Limiter<RequestLimitCtx> limiter) {
        this(limiter, name -> true);
    }

    public ClientRequestLimitInterceptor(Limiter<RequestLimitCtx> limiter, Function<String, Boolean> filter) {
        this.limiter = limiter;
        this.filter = filter;
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOpts, Channel next) {
        if (ClientRequestLimitInterceptor.shouldNotUseLimiter(method.getType()) || !this.filter.apply(method.getFullMethodName()).booleanValue()) {
            return next.newCall(method, callOpts);
        }
        String methodName = method.getFullMethodName();
        return ((Optional)MetricsUtil.timer((Object[])new Object[]{"rpc_limiter", "acquire_time", methodName}).timeSupplier(() -> this.limiter.acquire(() -> methodName))).map(listener -> new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOpts), (Limiter.Listener)listener){
            private final AtomicBoolean done;
            final /* synthetic */ Limiter.Listener val$listener;
            {
                this.val$listener = listener;
                super(x0);
                this.done = new AtomicBoolean(false);
            }

            public void start(ClientCall.Listener<RespT> respListener, Metadata headers) {
                super.start((ClientCall.Listener)new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(respListener){

                    public void onClose(Status status, Metadata trailers) {
                        try {
                            super.onClose(status, trailers);
                        }
                        finally {
                            if (done.compareAndSet(false, true)) {
                                if (status.isOk()) {
                                    val$listener.onSuccess();
                                } else if (Status.Code.UNAVAILABLE == status.getCode()) {
                                    val$listener.onDropped();
                                } else {
                                    val$listener.onIgnore();
                                }
                            }
                        }
                    }
                }, headers);
            }

            public void cancel(String message, Throwable cause) {
                try {
                    super.cancel(message, cause);
                }
                finally {
                    if (this.done.compareAndSet(false, true)) {
                        this.val$listener.onIgnore();
                    }
                }
            }
        }).orElseGet(() -> new ClientCall<ReqT, RespT>(){
            private ClientCall.Listener respListener;

            public void start(ClientCall.Listener<RespT> respListener, Metadata headers) {
                this.respListener = respListener;
            }

            public void request(int numMessages) {
            }

            public void cancel(String message, Throwable cause) {
            }

            public void halfClose() {
                this.respListener.onClose(LIMIT_EXCEEDED_STATUS, new Metadata());
            }

            public void sendMessage(ReqT message) {
            }
        });
    }

    public static boolean isLimitSwitchOpen() {
        return LIMIT_SWITCH.get();
    }

    public static boolean resetLimitSwitch() {
        return LIMIT_SWITCH.getAndSet(!LIMIT_SWITCH.get());
    }

    private static boolean shouldNotUseLimiter(MethodDescriptor.MethodType methodType) {
        if (!ClientRequestLimitInterceptor.isLimitSwitchOpen()) {
            return true;
        }
        return !methodType.clientSendsOneMessage() || !methodType.serverSendsOneMessage();
    }
}

