import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import { EditorTheme } from "@kie-tools-core/editor/dist/api";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
import { Tooltip } from "@patternfly/react-core/dist/js/components/Tooltip";
import { UndoIcon } from "@patternfly/react-icons/dist/js/icons/undo-icon";
import { SaveIcon } from "@patternfly/react-icons/dist/js/icons/save-icon";
import { RedoIcon } from "@patternfly/react-icons/dist/js/icons/redo-icon";
import React, { useEffect, useImperativeHandle, useMemo, useRef, useState, useCallback } from "react";
import "../styles.css";
import { FormEditorEditorController } from "./FormEditorController";
function FormEditorControl(props) {
    return (_jsx(Tooltip, { content: _jsx("div", { children: props.toolTipText }), children: _jsx(Button, { onClick: props.onClick, variant: "control", "aria-label": props.ariaLabel, children: props.icon }) }));
}
export const FormEditor = React.forwardRef(({ textContent, formLanguage, saveContent }, forwardedRef) => {
    const [content, setContent] = useState(textContent);
    const container = useRef(null);
    const controller = useMemo(() => {
        return new FormEditorEditorController(textContent, (args) => setContent(args.content), formLanguage, false);
    }, [textContent, formLanguage]);
    useEffect(() => {
        if (container.current) {
            controller.show(container.current, EditorTheme.LIGHT);
        }
        return () => {
            controller.dispose();
        };
    }, [controller]);
    useImperativeHandle(forwardedRef, () => controller, [controller]);
    const onSaveFormContent = useCallback(() => {
        saveContent(content);
    }, [content, saveContent]);
    const onUndo = useCallback(() => {
        controller.undo();
    }, [controller]);
    const onRedo = useCallback(() => {
        controller.redo();
    }, [controller]);
    return (_jsxs(_Fragment, { children: [_jsxs("div", { children: [_jsx(FormEditorControl, { icon: _jsx(SaveIcon, {}), ariaLabel: "Save form", toolTipText: "Save form", onClick: () => onSaveFormContent() }), _jsx(FormEditorControl, { icon: _jsx(UndoIcon, {}), ariaLabel: "Undo changes", toolTipText: "Undo changes", onClick: onUndo }), _jsx(FormEditorControl, { icon: _jsx(RedoIcon, {}), ariaLabel: "Redo changes", toolTipText: "Redo changes", onClick: onRedo })] }), _jsx("div", { className: "kogito-form-editor-container", ref: container, style: { height: "700px" } })] }));
});
export default FormEditor;
//# sourceMappingURL=FormEditor.js.map