import { DmnDefinitions } from "@kie-tools/dmn-feel-antlr4-parser/dist";
import { DmnLatestModel } from "@kie-tools/dmn-marshaller";
import { Expression } from "@kie-tools/dmn-feel-antlr4-parser/dist";
import { IdentifierContext } from "@kie-tools/dmn-feel-antlr4-parser/dist/parser/IdentifierContext";
import { Normalized } from "@kie-tools/dmn-marshaller/dist/normalization/normalize";
export declare class IdentifiersRefactor {
    private readonly repository;
    constructor(args: {
        writeableDmnDefinitions: Normalized<DmnDefinitions>;
        _readonly_externalDmnModelsByNamespaceMap: Map<string, Normalized<DmnLatestModel>>;
    });
    get expressions(): Map<string, Expression>;
    get identifiers(): Map<string, IdentifierContext>;
    reload(): void;
    changeType(args: {
        identifierUuid: string;
        newType: string | undefined;
    }): void;
    rename(args: {
        identifierUuid: string;
        newName: string;
    }): void;
    renameImport(args: {
        oldName: string;
        newName: string;
    }): void;
    getExpressionsThatUseTheIdentifier(identifierId: string): never[] | IterableIterator<Expression>;
    private computeIdentifiersLinksToExpressions;
    private applyExpressionsChangesToDefinition;
}
//# sourceMappingURL=IdentifiersRefactor.d.ts.map