import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import React, { useEffect, useImperativeHandle, useState } from "react";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
import { TextInput } from "@patternfly/react-core/dist/js/components/TextInput";
import { PencilAltIcon } from "@patternfly/react-icons/dist/js/icons/pencil-alt-icon";
import { CheckIcon } from "@patternfly/react-icons/dist/js/icons/check-icon";
import { TimesIcon } from "@patternfly/react-icons/dist/js/icons/times-icon";
import { componentOuiaProps } from "../../ouiaTools";
export const InlineEdit = React.forwardRef(({ setBusinessKey, getBusinessKey, ouiaId, ouiaSafe }, forwardedRef) => {
    const [isEditable, setIsEditable] = useState(false);
    const [inputValue, setInputValue] = useState("");
    const [currentBusinessKey, setCurrentBusinessKey] = useState(getBusinessKey());
    useEffect(() => {
        if (currentBusinessKey.length === 0) {
            setInputValue("");
        }
    }, [currentBusinessKey]);
    const toggleEditableMode = () => {
        setIsEditable(!isEditable);
    };
    const confirmBusinessKey = (isConfirmed) => {
        if (isConfirmed) {
            setBusinessKey(inputValue);
            setCurrentBusinessKey(inputValue);
        }
        toggleEditableMode();
    };
    useImperativeHandle(forwardedRef, () => ({
        reset: () => {
            setInputValue("");
            setCurrentBusinessKey("");
        },
    }), []);
    return (_jsxs("div", { ...componentOuiaProps(ouiaId, "inline-edit", ouiaSafe), className: `pf-c-inline-edit ${isEditable && "pf-m-inline-editable"}`, id: "inline-edit-toggle-example", children: [_jsxs("div", { className: "pf-c-inline-edit__group", children: [_jsx("div", { className: "pf-c-inline-edit__value", id: "single-editable-example-label", children: currentBusinessKey.length > 0 ? (currentBusinessKey) : (_jsx("span", { className: "pf-u-disabled-color-100", children: "Business key" })) }), _jsx("div", { className: "pf-c-inline-edit__action pf-m-enable-editable", children: _jsx(Button, { variant: "plain", onClick: toggleEditableMode, children: _jsx(PencilAltIcon, {}) }) })] }), _jsxs("div", { className: "pf-c-inline-edit__group", children: [_jsx("div", { className: "pf-c-inline-edit__input", children: _jsx(TextInput, { value: inputValue, type: "text", placeholder: "Enter business key", onChange: setInputValue, "aria-label": "text input example" }) }), _jsxs("div", { className: "pf-c-inline-edit__group pf-m-action-group pf-m-icon-group", children: [_jsx("div", { className: "pf-c-inline-edit__action pf-m-valid", children: _jsx(Button, { variant: "plain", onClick: () => confirmBusinessKey(true), children: _jsx(CheckIcon, {}) }) }), _jsx("div", { className: "pf-c-inline-edit__action", children: _jsx(Button, { variant: "plain", onClick: () => confirmBusinessKey(false), children: _jsx(TimesIcon, {}) }) })] })] })] }));
});
export default InlineEdit;
//# sourceMappingURL=InlineEdit.js.map