import { Context } from "uniforms";
import * as React from "react";
import { CodeGenContext } from "../CodeGenContext";
export declare const DEFAULT_ITEM_INDEX_NAME = "itemIndex";
export interface ListItemProps {
    isListItem: boolean;
    indexVariableName: string;
    listName: string;
    listStateName: string;
    listStateSetter: string;
}
export declare function getItemNameAndWithIsNested(name: string): {
    itemName: string;
    isNested: boolean;
};
export declare const getListItemName: ({ itemProps, name }: {
    itemProps: ListItemProps;
    name: string;
}) => string;
export declare const getListItemValue: ({ itemProps, name, callback, }: {
    itemProps: ListItemProps;
    name: string;
    callback?: (value: string) => string;
}) => string;
export declare const getListItemOnChange: ({ itemProps, name, callback, overrideNewValue, overrideParam, }: {
    itemProps: ListItemProps;
    name: string;
    callback?: (value: string) => string;
    overrideParam?: string;
    overrideNewValue?: string;
}) => string;
export declare function getNextIndexVariableName(itemProps?: ListItemProps): string;
export interface Props {
    codegenCtx: CodeGenContext;
    uniformsContext: Context<any>;
    fieldName: any;
    itemProps: ListItemProps;
    disabled?: boolean;
}
export declare const ListItemField: React.FC<Props>;
export default ListItemField;
//# sourceMappingURL=ListItemField.d.ts.map