import { domParser, getInstanceNs, getInstanceNsFromJson, getParser, } from "@kie-tools/xml-parser-ts";
import { getNsDeclarationPropName } from "@kie-tools/xml-parser-ts/dist/ns";
import { subs as dmn10subs, elements as dmn10elements, meta as dmn10meta, root as dmn10root, ns as dmn10ns, } from "./schemas/dmn-1_0/ts-gen/meta";
import { subs as dmn11subs, elements as dmn11elements, meta as dmn11meta, root as dmn11root, ns as dmn11ns, } from "./schemas/dmn-1_1/ts-gen/meta";
import { subs as dmn12subs, elements as dmn12elements, meta as dmn12meta, root as dmn12root, ns as dmn12ns, } from "./schemas/dmn-1_2/ts-gen/meta";
import { subs as dmn13subs, elements as dmn13elements, meta as dmn13meta, root as dmn13root, ns as dmn13ns, } from "./schemas/dmn-1_3/ts-gen/meta";
import { subs as dmn14subs, elements as dmn14elements, meta as dmn14meta, root as dmn14root, ns as dmn14ns, } from "./schemas/dmn-1_4/ts-gen/meta";
import { subs as dmn15subs, elements as dmn15elements, meta as dmn15meta, root as dmn15root, ns as dmn15ns, } from "./schemas/dmn-1_5/ts-gen/meta";
import { ns as kie10ns } from "./schemas/kie-1_0/ts-gen/meta";
import { KIE_NS, LEGACY_KIE_NS__PRE_GWT_REMOVAL } from "./kie-extensions";
import "./kie-extensions";
export const DMN_PARSERS = {
    "1.0": getParser({
        ns: dmn10ns,
        meta: dmn10meta,
        subs: dmn10subs,
        elements: dmn10elements,
        root: dmn10root,
    }),
    "1.1": getParser({
        ns: dmn11ns,
        meta: dmn11meta,
        subs: dmn11subs,
        elements: dmn11elements,
        root: dmn11root,
    }),
    "1.2": getParser({
        ns: dmn12ns,
        meta: dmn12meta,
        subs: dmn12subs,
        elements: dmn12elements,
        root: dmn12root,
    }),
    "1.3": getParser({
        ns: dmn13ns,
        meta: dmn13meta,
        subs: dmn13subs,
        elements: dmn13elements,
        root: dmn13root,
    }),
    "1.4": getParser({
        ns: dmn14ns,
        meta: dmn14meta,
        subs: dmn14subs,
        elements: dmn14elements,
        root: dmn14root,
    }),
    "1.5": getParser({
        ns: dmn15ns,
        meta: dmn15meta,
        subs: dmn15subs,
        elements: dmn15elements,
        root: dmn15root,
    }),
};
const FEEL_NS = "feel:";
export const FEEL_NAMESPACES = {
    "1.0": "http://www.omg.org/spec/FEEL/20140401",
    "1.1": "http://www.omg.org/spec/FEEL/20140401",
    "1.2": "http://www.omg.org/spec/DMN/20180521/FEEL/",
    "1.3": "https://www.omg.org/spec/DMN/20191111/FEEL/",
    "1.4": "https://www.omg.org/spec/DMN/20211108/FEEL/",
    "1.5": "https://www.omg.org/spec/DMN/20230324/FEEL/",
};
const feel12ns = new Map([
    [FEEL_NS, FEEL_NAMESPACES["1.2"]],
    [FEEL_NAMESPACES["1.2"], FEEL_NS],
]);
const feel13ns = new Map([
    [FEEL_NS, FEEL_NAMESPACES["1.3"]],
    [FEEL_NAMESPACES["1.3"], FEEL_NS],
]);
const feel14ns = new Map([
    [FEEL_NS, FEEL_NAMESPACES["1.4"]],
    [FEEL_NAMESPACES["1.4"], FEEL_NS],
]);
const feel15ns = new Map([
    [FEEL_NS, FEEL_NAMESPACES["1.5"]],
    [FEEL_NAMESPACES["1.5"], FEEL_NS],
]);
const kie10nsRelativeToDmns = new Map([
    [kie10ns.get(""), KIE_NS],
    [KIE_NS, kie10ns.get("")],
]);
export const DMN_VERSIONS_TIMELINE = ["1.0", "1.1", "1.2", "1.3", "1.4", "1.5"];
export const DMN_LATEST_VERSION = "1.5";
export function getMarshaller(xml, opts) {
    var _a, _b, _c, _d;
    const originalDomdoc = domParser.getDomDocument(xml);
    const originalInstanceNs = getInstanceNs(originalDomdoc);
    const originalMarshaller = getMarshallerForFixedVersion(originalDomdoc, originalInstanceNs);
    const targetVersion = (opts === null || opts === void 0 ? void 0 : opts.upgradeTo) === "latest" ? DMN_LATEST_VERSION : (_a = opts === null || opts === void 0 ? void 0 : opts.upgradeTo) !== null && _a !== void 0 ? _a : originalMarshaller.version;
    if (originalMarshaller.version === targetVersion) {
        return {
            ...originalMarshaller,
            originalVersion: originalMarshaller.version,
            isLatest: true,
        };
    }
    if (DMN_VERSIONS_TIMELINE.indexOf(originalMarshaller.version) > DMN_VERSIONS_TIMELINE.indexOf(targetVersion)) {
        throw new Error(`DMN MARSHALLER: Cannot build DMN ${targetVersion} marshaller from a model that's already in version '${originalMarshaller.version}'. Downgrading DMN models is not possible.`);
    }
    let dmn10 = undefined;
    let dmn11 = undefined;
    let dmn12 = undefined;
    let dmn13 = undefined;
    let dmn14 = undefined;
    let dmn15 = undefined;
    switch (originalMarshaller.version) {
        case "1.0":
            dmn10 = dmn10 !== null && dmn10 !== void 0 ? dmn10 : originalMarshaller.parser.parse();
            dmn11 = upgrade10to11(dmn10);
            if (targetVersion === "1.1")
                break;
        case "1.1":
            dmn11 = dmn11 !== null && dmn11 !== void 0 ? dmn11 : originalMarshaller.parser.parse();
            dmn12 = upgrade11to12(dmn11);
            if (targetVersion === "1.2")
                break;
        case "1.2":
            dmn12 = dmn12 !== null && dmn12 !== void 0 ? dmn12 : originalMarshaller.parser.parse();
            dmn13 = upgrade12to13(dmn12);
            if (targetVersion === "1.3")
                break;
        case "1.3":
            dmn13 = dmn13 !== null && dmn13 !== void 0 ? dmn13 : originalMarshaller.parser.parse();
            dmn14 = upgrade13to14(dmn13);
            if (targetVersion === "1.4")
                break;
        case "1.4":
            dmn14 = dmn14 !== null && dmn14 !== void 0 ? dmn14 : originalMarshaller.parser.parse();
            dmn15 = upgrade14to15(dmn14);
            if (targetVersion === "1.5")
                break;
        case "1.5":
            throw new Error("DMN MARSHALLER: Unexpected error. Shouldn't ever try to migrate a DMN 1.5, as DMN 1.5 is latest.");
    }
    const upgradedJson = (_d = (_c = (_b = dmn15 !== null && dmn15 !== void 0 ? dmn15 : dmn14) !== null && _b !== void 0 ? _b : dmn13) !== null && _c !== void 0 ? _c : dmn12) !== null && _d !== void 0 ? _d : dmn11;
    if (!upgradedJson) {
        throw new Error("DMN MARSHALLER: Unexpected error. At least one upgraded model should've been created.");
    }
    const parserForUpgradedJson = DMN_PARSERS[targetVersion];
    if (!parserForUpgradedJson) {
        throw new Error(`DMN MARSHALLER: Unexpected error. Couldn't find parser for version '${targetVersion}'.`);
    }
    const upgradedInstanceNs = getInstanceNsFromJson(upgradedJson.definitions);
    const upgradedXml = parserForUpgradedJson.build({ json: upgradedJson, instanceNs: upgradedInstanceNs });
    const upgradedMarshaller = getMarshallerForFixedVersion(domParser.getDomDocument(upgradedXml), upgradedInstanceNs);
    return {
        ...upgradedMarshaller,
        originalVersion: originalMarshaller.version,
        isLatest: targetVersion === DMN_LATEST_VERSION,
    };
}
export function getKieExtensionVersion(instanceNs) {
    if (instanceNs.get(LEGACY_KIE_NS__PRE_GWT_REMOVAL) !== undefined) {
        return "0.0";
    }
    else if (instanceNs.get(kie10ns.get("")) !== undefined) {
        return "1.0";
    }
    else {
        throw new Error(`DMN MARSHALLER: Unknown version declared for DMN. Instance NS --> '${JSON.stringify([
            ...instanceNs.entries(),
        ])}'.`);
    }
}
export function getDmnVersion(instanceNs) {
    if (instanceNs.get(dmn10ns.get("")) !== undefined) {
        return "1.0";
    }
    else if (instanceNs.get(dmn11ns.get("")) !== undefined) {
        return "1.1";
    }
    else if (instanceNs.get(dmn12ns.get("")) !== undefined) {
        return "1.2";
    }
    else if (instanceNs.get(dmn13ns.get("")) !== undefined) {
        return "1.3";
    }
    else if (instanceNs.get(dmn14ns.get("")) !== undefined) {
        return "1.4";
    }
    else if (instanceNs.get(dmn15ns.get("")) !== undefined) {
        return "1.5";
    }
    else {
        throw new Error(`DMN MARSHALLER: Unknown version declared for DMN. Instance NS --> '${JSON.stringify([
            ...instanceNs.entries(),
        ])}'.`);
    }
}
export function getMarshallerForFixedVersion(domdoc, instanceNs) {
    const version = getDmnVersion(instanceNs);
    switch (version) {
        case "1.0":
            return {
                instanceNs,
                version: "1.0",
                root: dmn10root,
                meta: dmn10meta,
                parser: { parse: () => DMN_PARSERS["1.0"].parse({ type: "domdoc", domdoc, instanceNs }).json },
                builder: { build: (json) => DMN_PARSERS["1.0"].build({ json, instanceNs }) },
            };
        case "1.1":
            return {
                instanceNs,
                version: "1.1",
                root: dmn11root,
                meta: dmn11meta,
                parser: { parse: () => DMN_PARSERS["1.1"].parse({ type: "domdoc", domdoc, instanceNs }).json },
                builder: { build: (json) => DMN_PARSERS["1.1"].build({ json, instanceNs }) },
            };
        case "1.2":
            return {
                instanceNs,
                version: "1.2",
                root: dmn12root,
                meta: dmn12meta,
                parser: { parse: () => DMN_PARSERS["1.2"].parse({ type: "domdoc", domdoc, instanceNs }).json },
                builder: { build: (json) => DMN_PARSERS["1.2"].build({ json, instanceNs }) },
            };
        case "1.3":
            return {
                instanceNs,
                version: "1.3",
                root: dmn13root,
                meta: dmn13meta,
                parser: { parse: () => DMN_PARSERS["1.3"].parse({ type: "domdoc", domdoc, instanceNs }).json },
                builder: { build: (json) => DMN_PARSERS["1.3"].build({ json, instanceNs }) },
            };
        case "1.4":
            return {
                instanceNs,
                version: "1.4",
                root: dmn14root,
                meta: dmn14meta,
                parser: { parse: () => DMN_PARSERS["1.4"].parse({ type: "domdoc", domdoc, instanceNs }).json },
                builder: { build: (json) => DMN_PARSERS["1.4"].build({ json, instanceNs }) },
            };
        case "1.5":
            return {
                instanceNs,
                version: "1.5",
                root: dmn15root,
                meta: dmn15meta,
                parser: { parse: () => DMN_PARSERS["1.5"].parse({ type: "domdoc", domdoc, instanceNs }).json },
                builder: { build: (json) => DMN_PARSERS["1.5"].build({ json, instanceNs }) },
            };
        default:
            throw new Error(`DMN MARSHALLER: Unknown version declared for DMN. Instance NS --> '${JSON.stringify([
                ...instanceNs.entries(),
            ])}'.`);
    }
}
const kieLegacyNs = new Map([
    ["kie:", LEGACY_KIE_NS__PRE_GWT_REMOVAL],
    [LEGACY_KIE_NS__PRE_GWT_REMOVAL, "kie:"],
]);
export function upgrade10to11(dmn10) {
    throw new Error("DMN MARSHALLER: Upgrading from DMN 1.0 is not supported. Minimum version is 1.2.");
}
export function upgrade11to12(dmn11) {
    throw new Error("DMN MARSHALLER: Upgrading from DMN 1.1 is not supported. Minimum version is 1.2.");
}
export function upgrade12to13(dmn12) {
    const instanceNs = getInstanceNsFromJson(dmn12.definitions);
    dmn12.definitions[getNsDeclarationPropName({
        namespace: dmn12ns.get(""),
        atInstanceNs: instanceNs,
        fallingBackToNs: dmn12ns,
    })] = dmn13ns.get("");
    dmn12.definitions[getNsDeclarationPropName({
        namespace: dmn12ns.get("dmndi:"),
        atInstanceNs: instanceNs,
        fallingBackToNs: dmn12ns,
    })] = dmn13ns.get("dmndi:");
    dmn12.definitions[getNsDeclarationPropName({
        namespace: LEGACY_KIE_NS__PRE_GWT_REMOVAL,
        atInstanceNs: instanceNs,
        fallingBackToNs: kieLegacyNs,
    })] = kie10ns.get("");
    dmn12.definitions[getNsDeclarationPropName({
        namespace: FEEL_NAMESPACES["1.2"],
        atInstanceNs: instanceNs,
        fallingBackToNs: feel12ns,
    })] = FEEL_NAMESPACES["1.3"];
    if (dmn12.definitions["@_typeLanguage"] === FEEL_NAMESPACES["1.2"]) {
        dmn12.definitions["@_typeLanguage"] = FEEL_NAMESPACES["1.3"];
    }
    if (dmn12.definitions["@_expressionLanguage"] === FEEL_NAMESPACES["1.2"]) {
        dmn12.definitions["@_expressionLanguage"] = FEEL_NAMESPACES["1.3"];
    }
    return dmn12;
}
export function upgrade13to14(dmn13) {
    const instanceNs = getInstanceNsFromJson(dmn13.definitions);
    dmn13.definitions[getNsDeclarationPropName({
        namespace: dmn13ns.get(""),
        atInstanceNs: instanceNs,
        fallingBackToNs: dmn13ns,
    })] = dmn14ns.get("");
    dmn13.definitions[getNsDeclarationPropName({
        namespace: dmn13ns.get("dmndi:"),
        atInstanceNs: instanceNs,
        fallingBackToNs: dmn13ns,
    })] = dmn14ns.get("dmndi:");
    dmn13.definitions[getNsDeclarationPropName({
        namespace: FEEL_NAMESPACES["1.3"],
        atInstanceNs: instanceNs,
        fallingBackToNs: feel13ns,
    })] = FEEL_NAMESPACES["1.4"];
    dmn13.definitions[getNsDeclarationPropName({
        namespace: kie10ns.get(""),
        atInstanceNs: instanceNs,
        fallingBackToNs: kie10nsRelativeToDmns,
    })] = kie10ns.get("");
    if (dmn13.definitions["@_typeLanguage"] === FEEL_NAMESPACES["1.3"]) {
        dmn13.definitions["@_typeLanguage"] = FEEL_NAMESPACES["1.4"];
    }
    if (dmn13.definitions["@_expressionLanguage"] === FEEL_NAMESPACES["1.3"]) {
        dmn13.definitions["@_expressionLanguage"] = FEEL_NAMESPACES["1.4"];
    }
    return dmn13;
}
export function upgrade14to15(dmn14) {
    const instanceNs = getInstanceNsFromJson(dmn14.definitions);
    dmn14.definitions[getNsDeclarationPropName({
        namespace: dmn14ns.get(""),
        atInstanceNs: instanceNs,
        fallingBackToNs: dmn14ns,
    })] = dmn15ns.get("");
    dmn14.definitions[getNsDeclarationPropName({
        namespace: dmn14ns.get("dmndi:"),
        atInstanceNs: instanceNs,
        fallingBackToNs: dmn14ns,
    })] = dmn15ns.get("dmndi:");
    dmn14.definitions[getNsDeclarationPropName({
        namespace: FEEL_NAMESPACES["1.4"],
        atInstanceNs: instanceNs,
        fallingBackToNs: feel14ns,
    })] = FEEL_NAMESPACES["1.5"];
    dmn14.definitions[getNsDeclarationPropName({
        namespace: kie10ns.get(""),
        atInstanceNs: instanceNs,
        fallingBackToNs: kie10nsRelativeToDmns,
    })] = kie10ns.get("");
    if (dmn14.definitions["@_typeLanguage"] === FEEL_NAMESPACES["1.4"]) {
        dmn14.definitions["@_typeLanguage"] = FEEL_NAMESPACES["1.5"];
    }
    if (dmn14.definitions["@_expressionLanguage"] === FEEL_NAMESPACES["1.4"]) {
        dmn14.definitions["@_expressionLanguage"] = FEEL_NAMESPACES["1.5"];
    }
    return dmn14;
}
//# sourceMappingURL=index.js.map