import { ValidationEntry } from "./ValidationRegistry";
import { ValidationLevel } from "./ValidationLevel";
import { Builder } from "../paths";
export const validateMiningFields = (modelIndex, miningFields, validationRegistry) => {
    miningFields.forEach((miningField, miningFieldIndex) => validateMiningField(modelIndex, miningFieldIndex, miningField, validationRegistry));
};
export const validateMiningField = (modelIndex, miningFieldIndex, miningField, validationRegistry) => {
    const importance = miningField.importance;
    if (importance !== undefined && (importance < 0 || importance > 1)) {
        validationRegistry.set(Builder().forModel(modelIndex).forMiningSchema().forMiningField(miningFieldIndex).forImportance().build(), new ValidationEntry(ValidationLevel.WARNING, `"${miningField.name}" Importance must be between 0 and 1.`));
    }
    const { outliers, lowValue, highValue } = miningField;
    if (areLowHighValuesRequired(outliers)) {
        if (lowValue === undefined && highValue === undefined) {
            validationRegistry.set(Builder().forModel(modelIndex).forMiningSchema().forMiningField(miningFieldIndex).forLowValue().build(), new ValidationEntry(ValidationLevel.WARNING, `"${miningField.name}" Low and/or High Value must be set.`));
            validationRegistry.set(Builder().forModel(modelIndex).forMiningSchema().forMiningField(miningFieldIndex).forHighValue().build(), new ValidationEntry(ValidationLevel.WARNING, `"${miningField.name}" Low and/or High Value must be set.`));
        }
    }
    else {
        if (lowValue !== undefined) {
            validationRegistry.set(Builder().forModel(modelIndex).forMiningSchema().forMiningField(miningFieldIndex).forLowValue().build(), new ValidationEntry(ValidationLevel.WARNING, `"${miningField.name}" Low Value is not needed.`));
        }
        if (highValue !== undefined) {
            validationRegistry.set(Builder().forModel(modelIndex).forMiningSchema().forMiningField(miningFieldIndex).forHighValue().build(), new ValidationEntry(ValidationLevel.WARNING, `"${miningField.name}" High Value is not needed.`));
        }
    }
    const { missingValueTreatment, missingValueReplacement } = miningField;
    if (isMissingValueReplacementRequired(missingValueTreatment)) {
        if (missingValueReplacement === undefined) {
            validationRegistry.set(Builder()
                .forModel(modelIndex)
                .forMiningSchema()
                .forMiningField(miningFieldIndex)
                .forMissingValueReplacement()
                .build(), new ValidationEntry(ValidationLevel.WARNING, `"${miningField.name}" Missing Value Replacement must be set.`));
        }
    }
    else {
        if (missingValueReplacement !== undefined) {
            validationRegistry.set(Builder()
                .forModel(modelIndex)
                .forMiningSchema()
                .forMiningField(miningFieldIndex)
                .forMissingValueReplacement()
                .build(), new ValidationEntry(ValidationLevel.WARNING, `"${miningField.name}" Missing Value Replacement is not required.`));
        }
    }
    const { invalidValueTreatment, invalidValueReplacement } = miningField;
    if (isInvalidValueReplacementRequired(invalidValueTreatment)) {
        if (invalidValueReplacement === undefined) {
            validationRegistry.set(Builder()
                .forModel(modelIndex)
                .forMiningSchema()
                .forMiningField(miningFieldIndex)
                .forInvalidValueReplacement()
                .build(), new ValidationEntry(ValidationLevel.WARNING, `"${miningField.name}" Invalid Value Replacement must be set.`));
        }
    }
    else {
        if (invalidValueReplacement !== undefined) {
            validationRegistry.set(Builder()
                .forModel(modelIndex)
                .forMiningSchema()
                .forMiningField(miningFieldIndex)
                .forInvalidValueReplacement()
                .build(), new ValidationEntry(ValidationLevel.WARNING, `"${miningField.name}" Invalid Value Replacement is not required.`));
        }
    }
};
export const validateMiningFieldsDataFieldReference = (modelIndex, dataFields, miningFields, validationRegistry) => {
    miningFields.forEach((miningField, miningFieldIndex) => validateMiningFieldDataFieldReference(modelIndex, dataFields, miningFieldIndex, miningField, validationRegistry));
};
export const validateMiningFieldDataFieldReference = (modelIndex, dataFields, miningFieldIndex, miningField, validationRegistry) => {
    if (dataFields.filter((dataField) => dataField.name === miningField.name).length === 0) {
        validationRegistry.set(Builder().forModel(modelIndex).forMiningSchema().forMiningField(miningFieldIndex).forDataFieldMissing().build(), new ValidationEntry(ValidationLevel.WARNING, `"${miningField.name}" cannot be found in the Data Dictionary.`));
    }
};
export const areLowHighValuesRequired = (outliers) => outliers === "asExtremeValues" || outliers === "asMissingValues";
export const isMissingValueReplacementRequired = (missingValueTreatment) => missingValueTreatment === "asMean" || missingValueTreatment === "asMedian" || missingValueTreatment === "asMode";
export const isInvalidValueReplacementRequired = (invalidValueTreatment) => invalidValueTreatment === "asValue";
//# sourceMappingURL=MiningSchema.js.map