import { EditorYamlCodeCompletionStrategy, EditorYamlLanguageService, indentText, positions_equals, } from "@kie-tools/json-yaml-language-service/dist/channel";
import { CompletionItemKind } from "vscode-languageserver-types";
import { dump } from "yaml-language-server-parser";
import { FileLanguage } from "../api";
import { YARD_SCHEMA } from "../assets/schemas";
import { YardLanguageService } from "./YardLanguageService";
export class YardYamlLanguageService {
    constructor() {
        this.ls = new YardLanguageService({
            fs: {},
            lang: {
                fileLanguage: FileLanguage.YAML,
                fileMatch: ["*.yard.yaml", "*.yard.yml"],
            },
        });
        this.codeCompletionStrategy = new YardYamlCodeCompletionStrategy();
        this.yamlELs = new EditorYamlLanguageService({
            ls: this.ls,
            codeCompletionStrategy: this.codeCompletionStrategy,
        });
    }
    async getCompletionItems(args) {
        return await this.yamlELs.getCompletionItems(args);
    }
    async getCodeLenses(args) {
        return await this.yamlELs.getCodeLenses(args);
    }
    async getDiagnostics(args) {
        return await this.yamlELs.getDiagnostics({
            ...args,
            getSchemaDiagnostics: (args) => this.getSchemaDiagnostics(args),
        });
    }
    async getSchemaDiagnostics(args) {
        return await this.yamlELs.getSchemaDiagnostics({
            ...args,
            jsonSchema: YARD_SCHEMA,
        });
    }
    dispose() {
        return this.yamlELs.dispose();
    }
}
export class YardYamlCodeCompletionStrategy {
    constructor() {
        this.eLsCodeCompletionStrategy = new EditorYamlCodeCompletionStrategy();
    }
    translate(args) {
        var _a, _b, _c, _d;
        const completionDump = dump(args.completion, {}).slice(2, -1).trim();
        if (["{}", "[]"].includes(completionDump) || args.completionItemKind === CompletionItemKind.Text) {
            return completionDump;
        }
        const skipFirstLineIndent = args.completionItemKind !== CompletionItemKind.Module;
        const completionItemNewLine = args.completionItemKind === CompletionItemKind.Module ? "\n" : "";
        const completionText = completionItemNewLine + indentText(completionDump, 2, " ", skipFirstLineIndent);
        return [CompletionItemKind.Interface, CompletionItemKind.Reference].includes(args.completionItemKind) && positions_equals((_b = (_a = args.overwriteRange) === null || _a === void 0 ? void 0 : _a.start) !== null && _b !== void 0 ? _b : null, (_d = (_c = args.currentNodeRange) === null || _c === void 0 ? void 0 : _c.start) !== null && _d !== void 0 ? _d : null)
            ? `- ${completionText}\n`
            : completionText;
    }
    formatLabel(label, completionItemKind) {
        return this.eLsCodeCompletionStrategy.formatLabel(label, completionItemKind);
    }
    getStartNodeValuePosition(document, node) {
        return this.eLsCodeCompletionStrategy.getStartNodeValuePosition(document, node);
    }
    shouldComplete(args) {
        return this.eLsCodeCompletionStrategy.shouldComplete(args);
    }
    shouldCreateCodelens(args) {
        return this.eLsCodeCompletionStrategy.shouldCreateCodelens(args);
    }
}
//# sourceMappingURL=YardYamlLanguageService.js.map