import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import React, { useCallback, useEffect, useState } from "react";
import { ExpandableRowContent } from "@patternfly/react-table/dist/js/components/Table";
import { TableComposable, Thead, Tbody, Tr, Th, Td } from "@patternfly/react-table/dist/js/components/TableComposable";
import _ from "lodash";
import { WorkflowInstanceState } from "@kie-tools/runtime-tools-swf-gateway-api/dist/types";
import { setTitle } from "@kie-tools/runtime-tools-components/dist/utils/Utils";
import { WorkflowInfoModal } from "@kie-tools/runtime-tools-components/dist/components/WorkflowInfoModal";
import WorkflowListChildTable from "../WorkflowListChildTable/WorkflowListChildTable";
import { EndpointLink } from "@kie-tools/runtime-tools-components/dist/components/EndpointLink";
import { KogitoEmptyState, KogitoEmptyStateType, } from "@kie-tools/runtime-tools-components/dist/components/KogitoEmptyState";
import { KogitoSpinner } from "@kie-tools/runtime-tools-components/dist/components/KogitoSpinner";
import { ItemDescriptor } from "@kie-tools/runtime-tools-components/dist/components/ItemDescriptor";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import { HistoryIcon } from "@patternfly/react-icons/dist/js/icons/history-icon";
import Moment from "react-moment";
import { getWorkflowInstanceDescription, WorkflowInstanceIconCreator } from "../utils/WorkflowListUtils";
import WorkflowListActionsKebab from "../WorkflowListActionsKebab/WorkflowListActionsKebab";
import { Checkbox } from "@patternfly/react-core/dist/js/components/Checkbox";
import DisablePopup from "../DisablePopup/DisablePopup";
import "../styles.css";
import ErrorPopover from "../ErrorPopover/ErrorPopover";
import { TitleType } from "@kie-tools/runtime-tools-shared-gateway-api/dist/types";
const WorkflowListTable = ({ isLoading, expanded, setExpanded, sortBy, onSort, workflowInstances, setWorkflowInstances, selectedInstances, setSelectedInstances, selectableInstances, setSelectableInstances, setIsAllChecked, driver, ouiaId, ouiaSafe, }) => {
    const [rowPairs, setRowPairs] = useState([]);
    const columns = ["__Toggle", "__Select", "Id", "Status", "Created", "Last update", "__Actions"];
    const [modalTitle, setModalTitle] = useState("");
    const [modalContent, setModalContent] = useState("");
    const [titleType, setTitleType] = useState("");
    const [isModalOpen, setIsModalOpen] = useState(false);
    const [selectedWorkflowInstance, setSelectedWorkflowInstance] = useState(null);
    const handleModalToggle = () => {
        setIsModalOpen(!isModalOpen);
    };
    const onShowMessage = (title, content, type, workflowInstance) => {
        setSelectedWorkflowInstance(workflowInstance);
        setTitleType(type);
        setModalTitle(title);
        setModalContent(content);
        handleModalToggle();
    };
    const onSkipClick = async (workflowInstance) => {
        try {
            await driver.handleWorkflowSkip(workflowInstance);
            onShowMessage("Skip operation", `The workflows ${workflowInstance.processName} was successfully skipped.`, TitleType.SUCCESS, workflowInstance);
        }
        catch (error) {
            onShowMessage("Skip operation", `The workflow ${workflowInstance.processName} failed to skip. Message: ${error.message}`, TitleType.FAILURE, workflowInstance);
        }
        finally {
            handleModalToggle();
        }
    };
    const onRetryClick = async (workflowInstance) => {
        try {
            await driver.handleWorkflowRetry(workflowInstance);
            onShowMessage("Retry operation", `The workflow ${workflowInstance.processName} was successfully re-executed.`, TitleType.SUCCESS, workflowInstance);
        }
        catch (error) {
            onShowMessage("Retry operation", `The workflow ${workflowInstance.processName} failed to re-execute. Message: ${error.message}`, TitleType.FAILURE, workflowInstance);
        }
        finally {
            handleModalToggle();
        }
    };
    const onAbortClick = async (workflowInstance) => {
        try {
            await driver.handleWorkflowAbort(workflowInstance);
            onShowMessage("Abort operation", `The workflow ${workflowInstance.processName} was successfully aborted.`, TitleType.SUCCESS, workflowInstance);
            workflowInstances.forEach((instance) => {
                if (instance.id === workflowInstance.id) {
                    instance.state = WorkflowInstanceState.Aborted;
                }
            });
            setWorkflowInstances([...workflowInstances]);
        }
        catch (error) {
            onShowMessage("Abort operation", `Failed to abort workflow ${workflowInstance.processName}. Message: ${error.message}`, TitleType.FAILURE, workflowInstance);
        }
        finally {
            handleModalToggle();
        }
    };
    const onOpenTriggerCloudEvent = useCallback((workflowInstance) => {
        return (instance) => driver.openTriggerCloudEvent(instance);
    }, [driver]);
    const handleClick = (workflowInstance) => {
        driver.openWorkflow(workflowInstance);
    };
    useEffect(() => {
        if (!_.isEmpty(workflowInstances)) {
            const tempRows = [];
            workflowInstances.forEach((workflowInstance) => {
                var _a;
                tempRows.push({
                    id: workflowInstance.id,
                    parent: [
                        _jsx(_Fragment, { children: ((_a = workflowInstance.addons) === null || _a === void 0 ? void 0 : _a.includes("workflow-management")) && workflowInstance.serviceUrl !== null ? (_jsx(Checkbox, { isChecked: workflowInstance.isSelected, onChange: () => checkBoxSelect(workflowInstance), "aria-label": "workflow-list-checkbox", id: `checkbox-${workflowInstance.id}`, name: `checkbox-${workflowInstance.id}` })) : (_jsx(DisablePopup, { workflowInstanceData: workflowInstance, component: _jsx(Checkbox, { "aria-label": "workflow-list-checkbox-disabled", id: `checkbox-${workflowInstance.id}`, isDisabled: true }) })) }),
                        _jsxs(_Fragment, { children: [_jsx("a", { className: "kogito-workflow-list__link", onClick: () => handleClick(workflowInstance), ...componentOuiaProps(ouiaId, "workflow-description", ouiaSafe), children: _jsx("strong", { children: _jsx(ItemDescriptor, { itemDescription: getWorkflowInstanceDescription(workflowInstance) }) }) }), _jsx(EndpointLink, { serviceUrl: workflowInstance.serviceUrl, isLinkShown: false })] }),
                        workflowInstance.state === WorkflowInstanceState.Error ? (_jsx(ErrorPopover, { workflowInstanceData: workflowInstance, onSkipClick: onSkipClick, onRetryClick: onRetryClick })) : (WorkflowInstanceIconCreator(workflowInstance.state)),
                        workflowInstance.start ? _jsx(Moment, { fromNow: true, children: new Date(`${workflowInstance.start}`) }) : "",
                        workflowInstance.lastUpdate ? (_jsxs("span", { children: [_jsx(HistoryIcon, { className: "pf-u-mr-sm" }), " ", "Updated ", _jsx(Moment, { fromNow: true, children: new Date(`${workflowInstance.lastUpdate}`) })] })) : (""),
                        _jsx(WorkflowListActionsKebab, { workflowInstance: workflowInstance, onSkipClick: onSkipClick, onRetryClick: onRetryClick, onAbortClick: onAbortClick, onOpenTriggerCloudEvent: onOpenTriggerCloudEvent }, workflowInstance.id),
                    ],
                    child: [workflowInstance.id],
                });
            });
            setRowPairs(tempRows);
        }
        else {
            setRowPairs([]);
        }
    }, [workflowInstances]);
    const loadChild = (parentId, parentIndex) => {
        if (!expanded[parentIndex]) {
            return null;
        }
        else {
            return (_jsx(WorkflowListChildTable, { parentWorkflowId: parentId, workflowInstances: workflowInstances, setWorkflowInstances: setWorkflowInstances, selectedInstances: selectedInstances, setSelectedInstances: setSelectedInstances, setSelectableInstances: setSelectableInstances, driver: driver, onSkipClick: onSkipClick, onRetryClick: onRetryClick, onAbortClick: onAbortClick, ouiaId: parentId }));
        }
    };
    const checkBoxSelect = (workflowInstance) => {
        const clonedWorkflowInstances = [...workflowInstances];
        clonedWorkflowInstances.forEach((instance) => {
            if (workflowInstance.id === instance.id) {
                if (instance.isSelected) {
                    instance.isSelected = false;
                    setSelectedInstances(selectedInstances.filter((selectedInstance) => selectedInstance.id !== instance.id));
                }
                else {
                    instance.isSelected = true;
                    setSelectedInstances([...selectedInstances, instance]);
                }
            }
        });
        setWorkflowInstances(clonedWorkflowInstances);
    };
    const onToggle = (pairIndex, pair) => {
        var _a;
        setExpanded({
            ...expanded,
            [pairIndex]: !expanded[pairIndex],
        });
        if (expanded[pairIndex]) {
            const workflowInstance = workflowInstances.find((instance) => instance.id === pair.id);
            (_a = workflowInstance === null || workflowInstance === void 0 ? void 0 : workflowInstance.childWorkflowInstances) === null || _a === void 0 ? void 0 : _a.forEach((childInstance) => {
                if (childInstance.isSelected) {
                    const index = selectedInstances.findIndex((selectedInstance) => selectedInstance.id === childInstance.id);
                    if (index !== -1) {
                        selectedInstances.splice(index, 1);
                    }
                }
            });
            workflowInstances.forEach((instance) => {
                var _a;
                if ((workflowInstance === null || workflowInstance === void 0 ? void 0 : workflowInstance.id) === instance.id) {
                    instance.isOpen = false;
                    (_a = instance.childWorkflowInstances) === null || _a === void 0 ? void 0 : _a.forEach((child) => {
                        var _a;
                        if (child.serviceUrl && ((_a = child.addons) === null || _a === void 0 ? void 0 : _a.includes("workflow-management"))) {
                            setSelectableInstances((prev) => prev - 1);
                        }
                    });
                }
            });
        }
        else {
            const workflowInstance = !_.isEmpty(workflowInstances)
                ? workflowInstances.find((instance) => instance.id === pair.id)
                : undefined;
            !_.isEmpty(workflowInstances) &&
                workflowInstances.forEach((instance) => {
                    if ((workflowInstance === null || workflowInstance === void 0 ? void 0 : workflowInstance.id) === instance.id) {
                        instance.isOpen = true;
                    }
                });
        }
        if (selectedInstances.length === selectableInstances && selectableInstances !== 0) {
            setIsAllChecked(true);
        }
        else {
            setIsAllChecked(false);
        }
    };
    return (_jsxs(React.Fragment, { children: [_jsx(WorkflowInfoModal, { isModalOpen: isModalOpen, handleModalToggle: handleModalToggle, modalTitle: setTitle(titleType, modalTitle), modalContent: modalContent, workflowName: selectedWorkflowInstance === null || selectedWorkflowInstance === void 0 ? void 0 : selectedWorkflowInstance.processName, ouiaId: selectedWorkflowInstance ? "workflow-" + selectedWorkflowInstance.id : undefined }), _jsxs(TableComposable, { "aria-label": "Workflow List Table", ...componentOuiaProps(ouiaId, "workflow-list-table", ouiaSafe ? ouiaSafe : !isLoading), children: [_jsx(Thead, { children: _jsx(Tr, { ouiaId: "workflow-list-table-header", children: columns.map((column, columnIndex) => {
                                let sortParams = {};
                                if (!isLoading && rowPairs.length > 0) {
                                    sortParams = {
                                        sort: {
                                            sortBy,
                                            onSort,
                                            columnIndex,
                                        },
                                    };
                                }
                                let styleParams;
                                switch (columnIndex) {
                                    case 0:
                                        styleParams = { width: "72px" };
                                        sortParams = {};
                                        break;
                                    case 1:
                                        styleParams = { width: "86px" };
                                        sortParams = {};
                                        break;
                                    case columns.length - 1:
                                        styleParams = { width: "188px" };
                                        sortParams = {};
                                        break;
                                }
                                return (_jsx(Th, { style: styleParams, ...sortParams, children: column.startsWith("__") ? "" : column }, `${column}_header`));
                            }) }) }), !isLoading && !_.isEmpty(rowPairs) ? (rowPairs.map((pair, pairIndex) => {
                        const parentRow = (_jsxs(Tr, { ...componentOuiaProps(pair.id, "workflow-list-row", true), children: [_jsx(Td, { expand: {
                                        rowIndex: pairIndex,
                                        isExpanded: expanded[pairIndex],
                                        onToggle: () => onToggle(pairIndex, pair),
                                    }, ...componentOuiaProps(columns[0].toLowerCase(), "workflow-list-cell", true) }, `${pair.id}-parent-0`), pair.parent.map((cell, cellIndex) => (_jsx(Td, { dataLabel: columns[cellIndex + 1], ...componentOuiaProps(columns[cellIndex + 1].toLowerCase(), "workflow-list-cell", true), children: cell }, `${pair.id}-parent-${columns[cellIndex + 1]}`)))] }, `${pair.id}-parent`));
                        const childRow = (_jsxs(Tr, { isExpanded: expanded[pairIndex] === true, ...componentOuiaProps(pair.id, "workflow-list-row-expanded", true), children: [_jsx(Td, {}, `${pair.id}-child-0`), rowPairs[pairIndex].child.map((cell, cellIndex) => (_jsx(Td, { dataLabel: columns[cellIndex], noPadding: rowPairs[pairIndex].noPadding, colSpan: 6, children: _jsx(ExpandableRowContent, { children: loadChild(cell, pairIndex) }) }, `${pair.id}-child-${columns[++cellIndex]}`)))] }, `${pair.id}-child`));
                        return (_jsxs(Tbody, { children: [parentRow, childRow] }, `${pair.id}_tBody`));
                    })) : (_jsx("tbody", { children: _jsx(Tr, { children: _jsx(Td, { colSpan: 7, children: _jsxs(_Fragment, { children: [isLoading && rowPairs.length === 0 && (_jsx(KogitoSpinner, { spinnerText: "Loading workflow instances..." })), !isLoading && rowPairs.length === 0 && (_jsx(KogitoEmptyState, { type: KogitoEmptyStateType.Search, title: "No results found", body: "Try using different filters" }))] }) }) }) }))] })] }));
};
export default WorkflowListTable;
//# sourceMappingURL=WorkflowListTable.js.map