import { builtInFeelTypeNames } from "../../dataTypes/BuiltInFeelTypes";
import { buildFeelQNameFromNamespace } from "../../feel/buildFeelQName";
export function computeDataTypes(namespace, itemDefinitions, externalModelTypesByNamespace, thisDmnsImportsByNamespace) {
    const allDataTypesById = new Map();
    const allTopLevelDataTypesByFeelName = new Map();
    const externalDmnsDataTypeTree = [...externalModelTypesByNamespace.dmns.values()].flatMap((externalDmn) => {
        var _a;
        return buildDataTypesTree((_a = externalDmn.model.definitions.itemDefinition) !== null && _a !== void 0 ? _a : [], thisDmnsImportsByNamespace, allDataTypesById, allTopLevelDataTypesByFeelName, undefined, new Set(), externalDmn.model.definitions["@_namespace"], namespace);
    });
    const thisDmnsDataTypeTree = buildDataTypesTree(itemDefinitions !== null && itemDefinitions !== void 0 ? itemDefinitions : [], thisDmnsImportsByNamespace, allDataTypesById, allTopLevelDataTypesByFeelName, undefined, new Set(), namespace, namespace);
    const allTopLevelItemDefinitionUniqueNames = new Map();
    for (const [k, v] of allTopLevelDataTypesByFeelName.entries()) {
        allTopLevelItemDefinitionUniqueNames.set(k, v.itemDefinition["@_id"]);
    }
    for (const type of builtInFeelTypeNames) {
        allTopLevelItemDefinitionUniqueNames.set(type, type);
    }
    return {
        dataTypesTree: [...thisDmnsDataTypeTree, ...externalDmnsDataTypeTree],
        allDataTypesById,
        allTopLevelDataTypesByFeelName,
        allTopLevelItemDefinitionUniqueNames,
    };
}
export function buildDataTypesTree(items, importsByNamespace, allDataTypesById, allTopLevelDataTypesByFeelName, parentId, parents, namespace, relativeToNamespace) {
    var _a;
    const dataTypesTree = [];
    for (let i = 0; i < items.length; i++) {
        const itemDefinition = items[i];
        const feelName = buildFeelQNameFromNamespace({
            importsByNamespace,
            namedElement: itemDefinition,
            namespace,
            relativeToNamespace,
        }).full;
        const dataType = {
            itemDefinition,
            index: i,
            parentId,
            parents,
            feelName,
            namespace,
            children: buildDataTypesTree((_a = itemDefinition.itemComponent) !== null && _a !== void 0 ? _a : [], importsByNamespace, allDataTypesById, allTopLevelDataTypesByFeelName, itemDefinition["@_id"], new Set([...parents, itemDefinition["@_id"]]), namespace, relativeToNamespace),
        };
        dataTypesTree.push(dataType);
        allDataTypesById.set(itemDefinition["@_id"], dataType);
        if (parentId === undefined) {
            allTopLevelDataTypesByFeelName.set(feelName, dataType);
        }
    }
    return dataTypesTree;
}
//# sourceMappingURL=computeDataTypes.js.map