import { jsx as _jsx } from "react/jsx-runtime";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
import { MinusCircleIcon } from "@patternfly/react-icons/dist/js/icons/minus-circle-icon";
import { connectField, filterDOMProps, joinName, useField } from "uniforms";
function ListDelField({ name, disabled, ...props }) {
    const nameParts = joinName(null, name);
    const nameIndex = +nameParts[nameParts.length - 1];
    const parentName = joinName(nameParts.slice(0, -1));
    const parent = useField(parentName, {}, { absoluteName: true })[0];
    const limitNotReached = !disabled && !(parent.minCount >= parent.value.length);
    return (_jsx(Button, { "data-testid": "list-del-field", disabled: !limitNotReached || disabled, variant: "plain", style: { paddingLeft: "0", paddingRight: "0" }, onClick: () => {
            const value = parent.value.slice();
            value.splice(nameIndex, 1);
            !disabled && limitNotReached && parent.onChange(value);
        }, ...filterDOMProps(props), children: _jsx(MinusCircleIcon, { color: "#cc0000" }) }));
}
export default connectField(ListDelField, {
    initialValue: false,
    kind: "leaf",
});
//# sourceMappingURL=ListDelField.js.map