import { MiningSchema, SequenceModel } from "../../model/pmml4_4";
import { LOCAL_TRANSFORMATIONS } from "./LocalTransformations";
import { MINING_SCHEMA } from "./MiningSchema";
import { MODEL_STATS } from "./ModelStats";
export const SEQUENCE_MODEL = `
elements.elements[(name = "SequenceModel")] ~> $map(function($v, $i) {
  $merge([
    $sequenceModelFactory(),
    $v.attributes,
    {
      "_type": $v.name
    },
    {
      ${MINING_SCHEMA}, 
      ${MODEL_STATS},
      ${LOCAL_TRANSFORMATIONS}
    }
  ])
})`;
export function sequenceModelFactory() {
    return new SequenceModel({
        MiningSchema: new MiningSchema({ MiningField: [] }),
        Sequence: [],
        minimumConfidence: 0,
        minimumSupport: 0,
        numberOfItems: 0,
        numberOfRules: 0,
        numberOfSequences: 0,
        numberOfSets: 0,
        functionName: "regression",
    });
}
//# sourceMappingURL=SequenceModel.js.map