/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.tls.runtime.config;

import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.tls.runtime.config.TlsConfigUtils;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.net.PemTrustOptions;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;

@ConfigGroup
public interface PemCertsConfig {
    public Optional<List<Path>> certs();

    default public PemTrustOptions toOptions() {
        PemTrustOptions options = new PemTrustOptions();
        if (this.certs().isEmpty()) {
            throw new IllegalArgumentException("You must specify the key files and certificate files");
        }
        for (Path path : this.certs().get()) {
            options.addCertValue(Buffer.buffer((byte[])TlsConfigUtils.read(path)));
        }
        return options;
    }

    public static interface KeyCertConfig {
        public Path key();

        public Path cert();
    }
}

