/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fury.serializer;

import java.util.Arrays;
import org.apache.fury.Fury;
import org.apache.fury.memory.MemoryBuffer;
import org.apache.fury.serializer.ImmutableSerializer;
import org.apache.fury.util.Preconditions;

public final class EnumSerializer
extends ImmutableSerializer<Enum> {
    private final Enum[] enumConstants;

    public EnumSerializer(Fury fury, Class<Enum> cls) {
        super(fury, cls, false);
        if (cls.isEnum()) {
            this.enumConstants = cls.getEnumConstants();
        } else {
            Preconditions.checkArgument(Enum.class.isAssignableFrom(cls) && cls != Enum.class);
            Class<?> enclosingClass = cls.getEnclosingClass();
            Preconditions.checkNotNull(enclosingClass);
            Preconditions.checkArgument(enclosingClass.isEnum());
            this.enumConstants = (Enum[])enclosingClass.getEnumConstants();
        }
    }

    @Override
    public void write(MemoryBuffer buffer, Enum value) {
        buffer.writeVarUint32Small7(value.ordinal());
    }

    @Override
    public Enum read(MemoryBuffer buffer) {
        int value = buffer.readVarUint32Small7();
        if (value >= this.enumConstants.length) {
            return this.handleNonexistentEnumValue(value);
        }
        return this.enumConstants[value];
    }

    private Enum handleNonexistentEnumValue(int value) {
        if (this.fury.getConfig().deserializeNonexistentEnumValueAsNull()) {
            return null;
        }
        throw new IllegalArgumentException(String.format("Enum ordinal %s not in %s", value, Arrays.toString(this.enumConstants)));
    }
}

