/*
 * Decompiled with CFR 0.152.
 */
package com.ecwid.consul.v1.catalog;

import com.ecwid.consul.SingleUrlParameters;
import com.ecwid.consul.UrlParameters;
import com.ecwid.consul.json.GsonFactory;
import com.ecwid.consul.transport.RawResponse;
import com.ecwid.consul.transport.TLSConfig;
import com.ecwid.consul.v1.ConsulRawClient;
import com.ecwid.consul.v1.OperationException;
import com.ecwid.consul.v1.QueryParams;
import com.ecwid.consul.v1.Response;
import com.ecwid.consul.v1.catalog.CatalogClient;
import com.ecwid.consul.v1.catalog.CatalogNodesRequest;
import com.ecwid.consul.v1.catalog.CatalogServiceRequest;
import com.ecwid.consul.v1.catalog.CatalogServicesRequest;
import com.ecwid.consul.v1.catalog.model.CatalogDeregistration;
import com.ecwid.consul.v1.catalog.model.CatalogNode;
import com.ecwid.consul.v1.catalog.model.CatalogRegistration;
import com.ecwid.consul.v1.catalog.model.CatalogService;
import com.ecwid.consul.v1.catalog.model.Node;
import com.google.gson.reflect.TypeToken;
import java.util.List;
import java.util.Map;

public final class CatalogConsulClient
implements CatalogClient {
    private final ConsulRawClient rawClient;

    public CatalogConsulClient(ConsulRawClient rawClient) {
        this.rawClient = rawClient;
    }

    public CatalogConsulClient() {
        this(new ConsulRawClient());
    }

    public CatalogConsulClient(TLSConfig tlsConfig) {
        this(new ConsulRawClient(tlsConfig));
    }

    public CatalogConsulClient(String agentHost) {
        this(new ConsulRawClient(agentHost));
    }

    public CatalogConsulClient(String agentHost, TLSConfig tlsConfig) {
        this(new ConsulRawClient(agentHost, tlsConfig));
    }

    public CatalogConsulClient(String agentHost, int agentPort) {
        this(new ConsulRawClient(agentHost, agentPort));
    }

    public CatalogConsulClient(String agentHost, int agentPort, TLSConfig tlsConfig) {
        this(new ConsulRawClient(agentHost, agentPort, tlsConfig));
    }

    @Override
    public Response<Void> catalogRegister(CatalogRegistration catalogRegistration) {
        return this.catalogRegister(catalogRegistration, null);
    }

    @Override
    public Response<Void> catalogRegister(CatalogRegistration catalogRegistration, String token) {
        SingleUrlParameters tokenParam;
        String json = GsonFactory.getGson().toJson((Object)catalogRegistration);
        RawResponse rawResponse = this.rawClient.makePutRequest("/v1/catalog/register", json, tokenParam = token != null ? new SingleUrlParameters("token", token) : null);
        if (rawResponse.getStatusCode() == 200) {
            return new Response<Object>(null, rawResponse);
        }
        throw new OperationException(rawResponse);
    }

    @Override
    public Response<Void> catalogDeregister(CatalogDeregistration catalogDeregistration) {
        return this.catalogDeregister(catalogDeregistration, null);
    }

    @Override
    public Response<Void> catalogDeregister(CatalogDeregistration catalogDeregistration, String token) {
        SingleUrlParameters tokenParam;
        String json = GsonFactory.getGson().toJson((Object)catalogDeregistration);
        RawResponse rawResponse = this.rawClient.makePutRequest("/v1/catalog/deregister", json, tokenParam = token != null ? new SingleUrlParameters("token", token) : null);
        if (rawResponse.getStatusCode() == 200) {
            return new Response<Object>(null, rawResponse);
        }
        throw new OperationException(rawResponse);
    }

    @Override
    public Response<List<String>> getCatalogDatacenters() {
        RawResponse rawResponse = this.rawClient.makeGetRequest("/v1/catalog/datacenters", new UrlParameters[0]);
        if (rawResponse.getStatusCode() == 200) {
            List value = (List)GsonFactory.getGson().fromJson(rawResponse.getContent(), new TypeToken<List<String>>(){}.getType());
            return new Response<List<String>>(value, rawResponse);
        }
        throw new OperationException(rawResponse);
    }

    @Override
    public Response<List<Node>> getCatalogNodes(QueryParams queryParams) {
        CatalogNodesRequest request = CatalogNodesRequest.newBuilder().setQueryParams(queryParams).build();
        return this.getCatalogNodes(request);
    }

    @Override
    public Response<List<Node>> getCatalogNodes(CatalogNodesRequest catalogNodesRequest) {
        RawResponse rawResponse = this.rawClient.makeGetRequest("/v1/catalog/nodes", catalogNodesRequest.asUrlParameters());
        if (rawResponse.getStatusCode() == 200) {
            List value = (List)GsonFactory.getGson().fromJson(rawResponse.getContent(), new TypeToken<List<Node>>(){}.getType());
            return new Response<List<Node>>(value, rawResponse);
        }
        throw new OperationException(rawResponse);
    }

    @Override
    public Response<Map<String, List<String>>> getCatalogServices(QueryParams queryParams) {
        return this.getCatalogServices(queryParams, null);
    }

    @Override
    public Response<Map<String, List<String>>> getCatalogServices(QueryParams queryParams, String token) {
        CatalogServicesRequest request = CatalogServicesRequest.newBuilder().setQueryParams(queryParams).setToken(token).build();
        return this.getCatalogServices(request);
    }

    @Override
    public Response<Map<String, List<String>>> getCatalogServices(CatalogServicesRequest catalogServicesRequest) {
        RawResponse rawResponse = this.rawClient.makeGetRequest("/v1/catalog/services", catalogServicesRequest.asUrlParameters());
        if (rawResponse.getStatusCode() == 200) {
            Map value = (Map)GsonFactory.getGson().fromJson(rawResponse.getContent(), new TypeToken<Map<String, List<String>>>(){}.getType());
            return new Response<Map<String, List<String>>>(value, rawResponse);
        }
        throw new OperationException(rawResponse);
    }

    @Override
    public Response<List<CatalogService>> getCatalogService(String serviceName, QueryParams queryParams) {
        return this.getCatalogService(serviceName, null, queryParams, null);
    }

    @Override
    public Response<List<CatalogService>> getCatalogService(String serviceName, QueryParams queryParams, String token) {
        return this.getCatalogService(serviceName, null, queryParams, token);
    }

    @Override
    public Response<List<CatalogService>> getCatalogService(String serviceName, String tag, QueryParams queryParams) {
        return this.getCatalogService(serviceName, tag, queryParams, null);
    }

    @Override
    public Response<List<CatalogService>> getCatalogService(String serviceName, String tag, QueryParams queryParams, String token) {
        CatalogServiceRequest request = CatalogServiceRequest.newBuilder().setTag(tag).setQueryParams(queryParams).setToken(token).build();
        return this.getCatalogService(serviceName, request);
    }

    @Override
    public Response<List<CatalogService>> getCatalogService(String serviceName, CatalogServiceRequest catalogServiceRequest) {
        RawResponse rawResponse = this.rawClient.makeGetRequest("/v1/catalog/service/" + serviceName, catalogServiceRequest.asUrlParameters());
        if (rawResponse.getStatusCode() == 200) {
            List value = (List)GsonFactory.getGson().fromJson(rawResponse.getContent(), new TypeToken<List<CatalogService>>(){}.getType());
            return new Response<List<CatalogService>>(value, rawResponse);
        }
        throw new OperationException(rawResponse);
    }

    @Override
    public Response<CatalogNode> getCatalogNode(String nodeName, QueryParams queryParams) {
        RawResponse rawResponse = this.rawClient.makeGetRequest("/v1/catalog/node/" + nodeName, queryParams);
        if (rawResponse.getStatusCode() == 200) {
            CatalogNode catalogNode = (CatalogNode)GsonFactory.getGson().fromJson(rawResponse.getContent(), CatalogNode.class);
            return new Response<CatalogNode>(catalogNode, rawResponse);
        }
        throw new OperationException(rawResponse);
    }
}

