/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.common.fileconfig;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.inlong.tubemq.corebase.utils.TStringUtils;

public class ADConfig {
    private boolean auditEnable = false;
    private HashSet<String> auditProxyAddrSet = new HashSet<String>(Arrays.asList("127.0.0.1:10081"));
    private String auditCacheFilePath = "/data/inlong/audit";
    private int auditCacheMaxRows = 2000000;
    private int auditIdProduce = 9;
    private int auditIdConsume = 10;

    public boolean isAuditEnable() {
        return this.auditEnable;
    }

    public void setAuditEnable(boolean auditEnable) {
        this.auditEnable = auditEnable;
    }

    public HashSet<String> getAuditProxyAddrSet() {
        return this.auditProxyAddrSet;
    }

    public void setAuditProxyAddrSet(List<String> auditProxyAddrs) {
        if (auditProxyAddrs == null || auditProxyAddrs.isEmpty()) {
            return;
        }
        this.auditProxyAddrSet.clear();
        for (String addrItem : auditProxyAddrs) {
            if (TStringUtils.isEmpty((String)addrItem)) continue;
            this.auditProxyAddrSet.add(addrItem);
        }
    }

    public String getAuditCacheFilePath() {
        return this.auditCacheFilePath;
    }

    public void setAuditCacheFilePath(String auditCacheFilePath) {
        this.auditCacheFilePath = auditCacheFilePath;
    }

    public int getAuditCacheMaxRows() {
        return this.auditCacheMaxRows;
    }

    public void setAuditCacheMaxRows(int auditCacheMaxRows) {
        this.auditCacheMaxRows = auditCacheMaxRows;
    }

    public int getAuditIdProduce() {
        return this.auditIdProduce;
    }

    public void setAuditIdProduce(int auditIdProduce) {
        this.auditIdProduce = auditIdProduce;
    }

    public int getAuditIdConsume() {
        return this.auditIdConsume;
    }

    public void setAuditIdConsume(int auditIdConsume) {
        this.auditIdConsume = auditIdConsume;
    }

    public String toString() {
        return new StringBuilder(512).append("\"ADConfig\":{\"auditEnable\":").append(this.auditEnable).append(",\"auditProxyAddr\":\"").append(this.auditProxyAddrSet).append("\",\"auditCacheFilePath\":\"").append(this.auditCacheFilePath).append("\",\"auditCacheMaxRows\":").append(this.auditCacheMaxRows).append(",\"auditIdProduce\":").append(this.auditIdProduce).append(",\"auditIdConsume\":").append(this.auditIdConsume).append("}").toString();
    }
}

