/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.sink.hudi;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.List;
import javax.validation.constraints.Pattern;
import org.apache.inlong.manager.common.util.JsonTypeDefine;
import org.apache.inlong.manager.pojo.sink.SinkRequest;

@ApiModel(value="Hudi sink request")
@JsonTypeDefine(value="HUDI")
public class HudiSinkRequest
extends SinkRequest {
    @ApiModelProperty(value="Catalog type, like: HIVE, HADOOP, default is HIVE")
    private String catalogType = "HIVE";
    @ApiModelProperty(value="Catalog uri, such as hive metastore thrift://ip:port")
    @Pattern(regexp="^((?!\\s).)*$", message="not supports blank in url")
    private @Pattern(regexp="^((?!\\s).)*$", message="not supports blank in url") String catalogUri;
    @ApiModelProperty(value="Hudi data warehouse dir")
    private String warehouse;
    @ApiModelProperty(value="Target database name")
    private String dbName;
    @ApiModelProperty(value="Target table name")
    private String tableName;
    @ApiModelProperty(value="Data path, such as: hdfs://ip:port/user/hive/warehouse/test.db")
    private String dataPath;
    @ApiModelProperty(value="File format, support: Parquet, Orc, Avro")
    private String fileFormat;
    @ApiModelProperty(value="Extended properties")
    private List<HashMap<String, String>> extList;
    @ApiModelProperty(value="Partition field list")
    private String partitionKey;
    @ApiModelProperty(value="Primary key")
    private String primaryKey;

    public String getCatalogType() {
        return this.catalogType;
    }

    public String getCatalogUri() {
        return this.catalogUri;
    }

    public String getWarehouse() {
        return this.warehouse;
    }

    public String getDbName() {
        return this.dbName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getDataPath() {
        return this.dataPath;
    }

    public String getFileFormat() {
        return this.fileFormat;
    }

    public List<HashMap<String, String>> getExtList() {
        return this.extList;
    }

    public String getPartitionKey() {
        return this.partitionKey;
    }

    public String getPrimaryKey() {
        return this.primaryKey;
    }

    public void setCatalogType(String catalogType) {
        this.catalogType = catalogType;
    }

    public void setCatalogUri(String catalogUri) {
        this.catalogUri = catalogUri;
    }

    public void setWarehouse(String warehouse) {
        this.warehouse = warehouse;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setDataPath(String dataPath) {
        this.dataPath = dataPath;
    }

    public void setFileFormat(String fileFormat) {
        this.fileFormat = fileFormat;
    }

    public void setExtList(List<HashMap<String, String>> extList) {
        this.extList = extList;
    }

    public void setPartitionKey(String partitionKey) {
        this.partitionKey = partitionKey;
    }

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    @Override
    public String toString() {
        return "HudiSinkRequest(super=" + super.toString() + ", catalogType=" + this.getCatalogType() + ", catalogUri=" + this.getCatalogUri() + ", warehouse=" + this.getWarehouse() + ", dbName=" + this.getDbName() + ", tableName=" + this.getTableName() + ", dataPath=" + this.getDataPath() + ", fileFormat=" + this.getFileFormat() + ", extList=" + this.getExtList() + ", partitionKey=" + this.getPartitionKey() + ", primaryKey=" + this.getPrimaryKey() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HudiSinkRequest)) {
            return false;
        }
        HudiSinkRequest other = (HudiSinkRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$catalogType = this.getCatalogType();
        String other$catalogType = other.getCatalogType();
        if (this$catalogType == null ? other$catalogType != null : !this$catalogType.equals(other$catalogType)) {
            return false;
        }
        String this$catalogUri = this.getCatalogUri();
        String other$catalogUri = other.getCatalogUri();
        if (this$catalogUri == null ? other$catalogUri != null : !this$catalogUri.equals(other$catalogUri)) {
            return false;
        }
        String this$warehouse = this.getWarehouse();
        String other$warehouse = other.getWarehouse();
        if (this$warehouse == null ? other$warehouse != null : !this$warehouse.equals(other$warehouse)) {
            return false;
        }
        String this$dbName = this.getDbName();
        String other$dbName = other.getDbName();
        if (this$dbName == null ? other$dbName != null : !this$dbName.equals(other$dbName)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$dataPath = this.getDataPath();
        String other$dataPath = other.getDataPath();
        if (this$dataPath == null ? other$dataPath != null : !this$dataPath.equals(other$dataPath)) {
            return false;
        }
        String this$fileFormat = this.getFileFormat();
        String other$fileFormat = other.getFileFormat();
        if (this$fileFormat == null ? other$fileFormat != null : !this$fileFormat.equals(other$fileFormat)) {
            return false;
        }
        List<HashMap<String, String>> this$extList = this.getExtList();
        List<HashMap<String, String>> other$extList = other.getExtList();
        if (this$extList == null ? other$extList != null : !((Object)this$extList).equals(other$extList)) {
            return false;
        }
        String this$partitionKey = this.getPartitionKey();
        String other$partitionKey = other.getPartitionKey();
        if (this$partitionKey == null ? other$partitionKey != null : !this$partitionKey.equals(other$partitionKey)) {
            return false;
        }
        String this$primaryKey = this.getPrimaryKey();
        String other$primaryKey = other.getPrimaryKey();
        return !(this$primaryKey == null ? other$primaryKey != null : !this$primaryKey.equals(other$primaryKey));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof HudiSinkRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $catalogType = this.getCatalogType();
        result = result * 59 + ($catalogType == null ? 43 : $catalogType.hashCode());
        String $catalogUri = this.getCatalogUri();
        result = result * 59 + ($catalogUri == null ? 43 : $catalogUri.hashCode());
        String $warehouse = this.getWarehouse();
        result = result * 59 + ($warehouse == null ? 43 : $warehouse.hashCode());
        String $dbName = this.getDbName();
        result = result * 59 + ($dbName == null ? 43 : $dbName.hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $dataPath = this.getDataPath();
        result = result * 59 + ($dataPath == null ? 43 : $dataPath.hashCode());
        String $fileFormat = this.getFileFormat();
        result = result * 59 + ($fileFormat == null ? 43 : $fileFormat.hashCode());
        List<HashMap<String, String>> $extList = this.getExtList();
        result = result * 59 + ($extList == null ? 43 : ((Object)$extList).hashCode());
        String $partitionKey = this.getPartitionKey();
        result = result * 59 + ($partitionKey == null ? 43 : $partitionKey.hashCode());
        String $primaryKey = this.getPrimaryKey();
        result = result * 59 + ($primaryKey == null ? 43 : $primaryKey.hashCode());
        return result;
    }
}

