/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.collect.ImmutableList;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.TableExpressionType;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class ArithmeticUnaryExpression
extends Expression {
    private final Expression value;
    private final Sign sign;

    public ArithmeticUnaryExpression(NodeLocation location, Sign sign, Expression value) {
        super(location);
        Objects.requireNonNull(value, "value is null");
        Objects.requireNonNull(sign, "sign is null");
        this.value = value;
        this.sign = sign;
    }

    public ArithmeticUnaryExpression(Sign sign, Expression value) {
        super(null);
        Objects.requireNonNull(value, "value is null");
        Objects.requireNonNull(sign, "sign is null");
        this.value = value;
        this.sign = sign;
    }

    public ArithmeticUnaryExpression(ByteBuffer byteBuffer) {
        super(null);
        this.value = Expression.deserialize(byteBuffer);
        this.sign = Sign.values()[ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer)];
    }

    @Override
    public TableExpressionType getExpressionType() {
        return TableExpressionType.ARITHMETIC_UNARY;
    }

    @Override
    protected void serialize(DataOutputStream stream) throws IOException {
        Expression.serialize(this.value, stream);
        ReadWriteIOUtils.write((int)this.sign.ordinal(), (OutputStream)stream);
    }

    public static ArithmeticUnaryExpression positive(@Nonnull NodeLocation location, Expression value) {
        return new ArithmeticUnaryExpression(Objects.requireNonNull(location, "location is null"), Sign.PLUS, value);
    }

    public static ArithmeticUnaryExpression negative(@Nonnull NodeLocation location, Expression value) {
        return new ArithmeticUnaryExpression(Objects.requireNonNull(location, "location is null"), Sign.MINUS, value);
    }

    public static ArithmeticUnaryExpression positive(Expression value) {
        return new ArithmeticUnaryExpression(null, Sign.PLUS, value);
    }

    public static ArithmeticUnaryExpression negative(Expression value) {
        return new ArithmeticUnaryExpression(null, Sign.MINUS, value);
    }

    public Expression getValue() {
        return this.value;
    }

    public Sign getSign() {
        return this.sign;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitArithmeticUnary(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of((Object)this.value);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArithmeticUnaryExpression that = (ArithmeticUnaryExpression)o;
        return Objects.equals(this.value, that.value) && this.sign == that.sign;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.value, this.sign});
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!ArithmeticUnaryExpression.sameClass(this, other)) {
            return false;
        }
        return this.sign == ((ArithmeticUnaryExpression)other).sign;
    }

    public static enum Sign {
        PLUS,
        MINUS;

    }
}

