/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.read.common.type;

import java.util.Collections;
import java.util.List;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.read.common.block.column.BooleanColumnBuilder;
import org.apache.tsfile.read.common.type.AbstractType;
import org.apache.tsfile.read.common.type.Type;
import org.apache.tsfile.read.common.type.TypeEnum;
import org.apache.tsfile.utils.Preconditions;

public class UnknownType
extends AbstractType {
    public static final UnknownType UNKNOWN = new UnknownType();
    public static final String NAME = "unknown";

    private UnknownType() {
    }

    @Override
    public void writeBoolean(ColumnBuilder columnBuilder, boolean value) {
        Preconditions.checkArgument(!value);
        columnBuilder.appendNull();
    }

    @Override
    public boolean getBoolean(Column column, int position) {
        Preconditions.checkArgument(column.isNull(position));
        return false;
    }

    @Override
    public ColumnBuilder createColumnBuilder(int expectedEntries) {
        return new BooleanColumnBuilder(null, expectedEntries);
    }

    @Override
    public TypeEnum getTypeEnum() {
        return TypeEnum.UNKNOWN;
    }

    @Override
    public String getDisplayName() {
        return NAME;
    }

    @Override
    public boolean isComparable() {
        return true;
    }

    @Override
    public boolean isOrderable() {
        return true;
    }

    @Override
    public List<Type> getTypeParameters() {
        return Collections.emptyList();
    }

    public static UnknownType getInstance() {
        return UNKNOWN;
    }
}

