/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.session.pool;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.iotdb.isession.ITableSession;
import org.apache.iotdb.isession.SessionDataSet;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.session.Session;
import org.apache.iotdb.session.pool.SessionPool;
import org.apache.tsfile.write.record.Tablet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableSessionWrapper
implements ITableSession {
    private static final Logger LOGGER = LoggerFactory.getLogger(TableSessionWrapper.class);
    private Session session;
    private final SessionPool sessionPool;
    private final AtomicBoolean closed;

    protected TableSessionWrapper(Session session, SessionPool sessionPool) {
        this.session = session;
        this.sessionPool = sessionPool;
        this.closed = new AtomicBoolean(false);
    }

    public void insert(Tablet tablet) throws StatementExecutionException, IoTDBConnectionException {
        try {
            this.session.insertRelationalTablet(tablet);
        }
        catch (IoTDBConnectionException e) {
            this.sessionPool.cleanSessionAndMayThrowConnectionException(this.session);
            this.closed.set(true);
            this.session = null;
            throw e;
        }
    }

    public SessionDataSet executeQueryStatement(String sql) throws StatementExecutionException, IoTDBConnectionException {
        try {
            return this.session.executeQueryStatement(sql);
        }
        catch (IoTDBConnectionException e) {
            this.sessionPool.cleanSessionAndMayThrowConnectionException(this.session);
            this.closed.set(true);
            this.session = null;
            throw e;
        }
    }

    public SessionDataSet executeQueryStatement(String sql, long timeoutInMs) throws StatementExecutionException, IoTDBConnectionException {
        try {
            return this.session.executeQueryStatement(sql, timeoutInMs);
        }
        catch (IoTDBConnectionException e) {
            this.sessionPool.cleanSessionAndMayThrowConnectionException(this.session);
            this.closed.set(true);
            this.session = null;
            throw e;
        }
    }

    public void executeNonQueryStatement(String sql) throws IoTDBConnectionException, StatementExecutionException {
        try {
            this.session.executeNonQueryStatement(sql);
        }
        catch (IoTDBConnectionException e) {
            this.sessionPool.cleanSessionAndMayThrowConnectionException(this.session);
            this.closed.set(true);
            this.session = null;
            throw e;
        }
    }

    public void close() throws IoTDBConnectionException {
        if (!Objects.equals(this.session.getSqlDialect(), this.sessionPool.sqlDialect)) {
            try {
                this.session.executeNonQueryStatement("set sql_dialect=" + this.sessionPool.sqlDialect);
            }
            catch (StatementExecutionException e) {
                LOGGER.warn("Failed to change back sql_dialect by executing: set sql_dialect={}", (Object)this.sessionPool.sqlDialect, (Object)e);
                this.session.close();
                this.session = null;
                return;
            }
        }
        if (this.closed.compareAndSet(false, true)) {
            if (!Objects.equals(this.session.getDatabase(), this.sessionPool.database) && this.sessionPool.database != null) {
                try {
                    this.session.executeNonQueryStatement("use " + this.sessionPool.database);
                }
                catch (StatementExecutionException e) {
                    LOGGER.warn("Failed to change back database by executing: use {}", (Object)this.sessionPool.database, (Object)e);
                    this.session.close();
                    this.session = null;
                    return;
                }
            }
            this.sessionPool.putBack(this.session);
            this.session = null;
        }
    }
}

