/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.column.unary.scalar;

import java.util.regex.Pattern;
import org.apache.iotdb.db.queryengine.transformation.dag.column.ColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.unary.UnaryColumnTransformer;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.read.common.type.Type;

public class RegexpLikeColumnTransformer
extends UnaryColumnTransformer {
    private final Pattern pattern;

    public RegexpLikeColumnTransformer(Type returnType, ColumnTransformer childColumnTransformer, String regex) {
        super(returnType, childColumnTransformer);
        this.pattern = Pattern.compile(regex);
    }

    @Override
    protected void doTransform(Column column, ColumnBuilder columnBuilder) {
        int n = column.getPositionCount();
        for (int i = 0; i < n; ++i) {
            if (!column.isNull(i)) {
                String currentValue = column.getBinary(i).getStringValue(TSFileConfig.STRING_CHARSET);
                columnBuilder.writeBoolean(this.pattern.matcher(currentValue).matches());
                continue;
            }
            columnBuilder.appendNull();
        }
    }

    @Override
    protected void doTransform(Column column, ColumnBuilder columnBuilder, boolean[] selection) {
        int n = column.getPositionCount();
        for (int i = 0; i < n; ++i) {
            if (selection[i] && !column.isNull(i)) {
                String currentValue = column.getBinary(i).getStringValue(TSFileConfig.STRING_CHARSET);
                columnBuilder.writeBoolean(this.pattern.matcher(currentValue).matches());
                continue;
            }
            columnBuilder.appendNull();
        }
    }
}

