/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.method;

import eu.timepit.refined.api.RefType$;
import eu.timepit.refined.api.Refined;
import eu.timepit.refined.boolean;
import eu.timepit.refined.collection;
import java.io.Serializable;
import java.time.ZonedDateTime;
import java.util.Date;
import javax.inject.Inject;
import javax.mail.Flags;
import org.apache.james.jmap.JMAPConfiguration;
import org.apache.james.jmap.api.model.Size$;
import org.apache.james.jmap.core.Properties;
import org.apache.james.jmap.core.Properties$;
import org.apache.james.jmap.core.SetError;
import org.apache.james.jmap.core.SetError$;
import org.apache.james.jmap.core.UTCDate;
import org.apache.james.jmap.json.EmailSetSerializer;
import org.apache.james.jmap.mail.BlobId$;
import org.apache.james.jmap.mail.EmailCreationId;
import org.apache.james.jmap.mail.EmailCreationRequest;
import org.apache.james.jmap.mail.EmailCreationResponse;
import org.apache.james.jmap.mail.EmailSetRequest;
import org.apache.james.jmap.mail.ThreadId$;
import org.apache.james.jmap.method.EmailSetCreatePerformer$CreationResults$;
import org.apache.james.jmap.method.SizeExceededException;
import org.apache.james.jmap.routes.BlobNotFoundException;
import org.apache.james.jmap.routes.BlobResolvers;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.exception.OverQuotaException;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.util.html.HtmlTextExtractor;
import play.api.libs.json.JsObject;
import play.api.libs.json.JsValue;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import reactor.core.scheduler.Schedulers;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0005\r}v!B,Y\u0011\u0003\u0019g!B3Y\u0011\u00031\u0007\"B7\u0002\t\u0003qg\u0001B8\u0002\u0001BD!\"!\u0001\u0004\u0005+\u0007I\u0011AA\u0002\u0011)\t\u0019b\u0001B\tB\u0003%\u0011Q\u0001\u0005\u0007[\u000e!\t!!\u0006\t\u000f\u0005m1\u0001\"\u0001\u0002\u001e!9\u0011qI\u0002\u0005\u0002\u0005%\u0003\"CA.\u0007\u0005\u0005I\u0011AA/\u0011%\t\tgAI\u0001\n\u0003\t\u0019\u0007C\u0005\u0002z\r\t\t\u0011\"\u0011\u0002|!I\u0011QR\u0002\u0002\u0002\u0013\u0005\u0011q\u0012\u0005\n\u0003/\u001b\u0011\u0011!C\u0001\u00033C\u0011\"!*\u0004\u0003\u0003%\t!a*\t\u0013\u0005E6!!A\u0005B\u0005M\u0006\"CA\\\u0007\u0005\u0005I\u0011IA]\u0011%\tYlAA\u0001\n\u0003\ni\fC\u0005\u0002@\u000e\t\t\u0011\"\u0011\u0002B\u001eI\u0011QY\u0001\u0002\u0002#\u0005\u0011q\u0019\u0004\t_\u0006\t\t\u0011#\u0001\u0002J\"1Q\u000e\u0006C\u0001\u0003CD\u0011\"a/\u0015\u0003\u0003%)%!0\t\u0013\u0005\rH#!A\u0005\u0002\u0006\u0015\b\"CAu)\u0005\u0005I\u0011QAv\u0011%\t\u0019\u0010FA\u0001\n\u0013\t)PB\u0005\u0002\u0010\u0005\u0001\n1%\u0001\u0002\u0012\u00191\u0011Q`\u0001A\u0003\u007fD!B!\u0001\u001c\u0005+\u0007I\u0011\u0001B\u0002\u0011)\u0011)a\u0007B\tB\u0003%\u0011Q\u0007\u0005\u000b\u0005\u000fY\"Q3A\u0005\u0002\t%\u0001B\u0003B\u00067\tE\t\u0015!\u0003\u0002B!1Qn\u0007C\u0001\u0005\u001bA\u0011\"a\u0017\u001c\u0003\u0003%\tA!\u0006\t\u0013\u0005\u00054$%A\u0005\u0002\tm\u0001\"\u0003B\u00107E\u0005I\u0011\u0001B\u0011\u0011%\tIhGA\u0001\n\u0003\nY\bC\u0005\u0002\u000en\t\t\u0011\"\u0001\u0002\u0010\"I\u0011qS\u000e\u0002\u0002\u0013\u0005!Q\u0005\u0005\n\u0003K[\u0012\u0011!C\u0001\u0005SA\u0011\"!-\u001c\u0003\u0003%\tE!\f\t\u0013\u0005]6$!A\u0005B\u0005e\u0006\"CA^7\u0005\u0005I\u0011IA_\u0011%\tylGA\u0001\n\u0003\u0012\tdB\u0005\u00036\u0005\t\t\u0011#\u0001\u00038\u0019I\u0011Q`\u0001\u0002\u0002#\u0005!\u0011\b\u0005\u0007[6\"\tA!\u0011\t\u0013\u0005mV&!A\u0005F\u0005u\u0006\"CAr[\u0005\u0005I\u0011\u0011B\"\u0011%\tI/LA\u0001\n\u0003\u0013I\u0005C\u0005\u0002t6\n\t\u0011\"\u0003\u0002v\u001a1!QK\u0001A\u0005/B!B!\u00014\u0005+\u0007I\u0011\u0001B\u0002\u0011)\u0011)a\rB\tB\u0003%\u0011Q\u0007\u0005\u000b\u00053\u001a$Q3A\u0005\u0002\tm\u0003B\u0003B2g\tE\t\u0015!\u0003\u0003^!1Qn\rC\u0001\u0005KBqA!\u001c4\t\u0003\u0011y\u0007C\u0005\u0002\\M\n\t\u0011\"\u0001\u0003r!I\u0011\u0011M\u001a\u0012\u0002\u0013\u0005!1\u0004\u0005\n\u0005?\u0019\u0014\u0013!C\u0001\u0005oB\u0011\"!\u001f4\u0003\u0003%\t%a\u001f\t\u0013\u000555'!A\u0005\u0002\u0005=\u0005\"CALg\u0005\u0005I\u0011\u0001B>\u0011%\t)kMA\u0001\n\u0003\u0011y\bC\u0005\u00022N\n\t\u0011\"\u0011\u0003\u0004\"I\u0011qW\u001a\u0002\u0002\u0013\u0005\u0013\u0011\u0018\u0005\n\u0003w\u001b\u0014\u0011!C!\u0003{C\u0011\"a04\u0003\u0003%\tEa\"\b\u0013\t-\u0015!!A\t\u0002\t5e!\u0003B+\u0003\u0005\u0005\t\u0012\u0001BH\u0011\u0019ig\t\"\u0001\u0003\u0014\"I\u00111\u0018$\u0002\u0002\u0013\u0015\u0013Q\u0018\u0005\n\u0003G4\u0015\u0011!CA\u0005+C\u0011\"!;G\u0003\u0003%\tIa'\t\u0013\u0005Mh)!A\u0005\n\u0005Uh!B3Y\u0001\t\r\u0006B\u0003BS\u0019\n\u0005\t\u0015!\u0003\u0003(\"Q!1\u0017'\u0003\u0002\u0003\u0006IA!.\t\u0015\t\u0005GJ!A!\u0002\u0013\u0011\u0019\r\u0003\u0006\u0003T2\u0013\t\u0011)A\u0005\u0005+D!B!9M\u0005\u0003\u0005\u000b\u0011\u0002Br\u0011\u0019iG\n\"\u0001\u0003l\"911\u0002'\u0005\u0002\r5\u0001bBB\u0006\u0019\u0012%1q\n\u0005\b\u0007CbE\u0011BB2\u0011\u001d\u0019I\n\u0014C\u0005\u00077\u000bq#R7bS2\u001cV\r^\"sK\u0006$X\rU3sM>\u0014X.\u001a:\u000b\u0005eS\u0016AB7fi\"|GM\u0003\u0002\\9\u0006!!.\\1q\u0015\tif,A\u0003kC6,7O\u0003\u0002`A\u00061\u0011\r]1dQ\u0016T\u0011!Y\u0001\u0004_J<7\u0001\u0001\t\u0003I\u0006i\u0011\u0001\u0017\u0002\u0018\u000b6\f\u0017\u000e\\*fi\u000e\u0013X-\u0019;f!\u0016\u0014hm\u001c:nKJ\u001c\"!A4\u0011\u0005!\\W\"A5\u000b\u0003)\fQa]2bY\u0006L!\u0001\\5\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t1MA\bDe\u0016\fG/[8o%\u0016\u001cX\u000f\u001c;t'\u0011\u0019q-\u001d;\u0011\u0005!\u0014\u0018BA:j\u0005\u001d\u0001&o\u001c3vGR\u0004\"!^?\u000f\u0005Y\\hBA<{\u001b\u0005A(BA=c\u0003\u0019a$o\\8u}%\t!.\u0003\u0002}S\u00069\u0001/Y2lC\u001e,\u0017B\u0001@\u0000\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\ta\u0018.A\u0004sKN,H\u000e^:\u0016\u0005\u0005\u0015\u0001#B;\u0002\b\u0005-\u0011bAA\u0005\u007f\n\u00191+Z9\u0011\u0007\u00055!$D\u0001\u0002\u00059\u0019%/Z1uS>t'+Z:vYR\u001c\"AG4\u0002\u0011I,7/\u001e7ug\u0002\"B!a\u0006\u0002\u001aA\u0019\u0011QB\u0002\t\u000f\u0005\u0005a\u00011\u0001\u0002\u0006\u000591M]3bi\u0016$WCAA\u0010!\u0015A\u0017\u0011EA\u0013\u0013\r\t\u0019#\u001b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0011\u0005\u001d\u0012qFA\u001b\u0003\u0003rA!!\u000b\u0002,A\u0011q/[\u0005\u0004\u0003[I\u0017A\u0002)sK\u0012,g-\u0003\u0003\u00022\u0005M\"aA'ba*\u0019\u0011QF5\u0011\t\u0005]\u0012QH\u0007\u0003\u0003sQ1!a\u000f[\u0003\u0011i\u0017-\u001b7\n\t\u0005}\u0012\u0011\b\u0002\u0010\u000b6\f\u0017\u000e\\\"sK\u0006$\u0018n\u001c8JIB!\u0011qGA\"\u0013\u0011\t)%!\u000f\u0003+\u0015k\u0017-\u001b7De\u0016\fG/[8o%\u0016\u001c\bo\u001c8tK\u0006Qan\u001c;De\u0016\fG/\u001a3\u0016\u0005\u0005-\u0003#\u00025\u0002\"\u00055\u0003\u0003CA\u0014\u0003_\t)$a\u0014\u0011\t\u0005E\u0013qK\u0007\u0003\u0003'R1!!\u0016[\u0003\u0011\u0019wN]3\n\t\u0005e\u00131\u000b\u0002\t'\u0016$XI\u001d:pe\u0006!1m\u001c9z)\u0011\t9\"a\u0018\t\u0013\u0005\u0005\u0011\u0002%AA\u0002\u0005\u0015\u0011AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003KRC!!\u0002\u0002h-\u0012\u0011\u0011\u000e\t\u0005\u0003W\n)(\u0004\u0002\u0002n)!\u0011qNA9\u0003%)hn\u00195fG.,GMC\u0002\u0002t%\f!\"\u00198o_R\fG/[8o\u0013\u0011\t9(!\u001c\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003{\u0002B!a \u0002\n6\u0011\u0011\u0011\u0011\u0006\u0005\u0003\u0007\u000b))\u0001\u0003mC:<'BAAD\u0003\u0011Q\u0017M^1\n\t\u0005-\u0015\u0011\u0011\u0002\u0007'R\u0014\u0018N\\4\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005E\u0005c\u00015\u0002\u0014&\u0019\u0011QS5\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005m\u0015\u0011\u0015\t\u0004Q\u0006u\u0015bAAPS\n\u0019\u0011I\\=\t\u0013\u0005\rV\"!AA\u0002\u0005E\u0015a\u0001=%c\u0005A1-\u00198FcV\fG\u000e\u0006\u0003\u0002*\u0006=\u0006c\u00015\u0002,&\u0019\u0011QV5\u0003\u000f\t{w\u000e\\3b]\"I\u00111\u0015\b\u0002\u0002\u0003\u0007\u00111T\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002~\u0005U\u0006\"CAR\u001f\u0005\u0005\t\u0019AAI\u0003!A\u0017m\u001d5D_\u0012,GCAAI\u0003!!xn\u0015;sS:<GCAA?\u0003\u0019)\u0017/^1mgR!\u0011\u0011VAb\u0011%\t\u0019KEA\u0001\u0002\u0004\tY*A\bDe\u0016\fG/[8o%\u0016\u001cX\u000f\u001c;t!\r\ti\u0001F\n\u0006)\u0005-\u0017q\u001b\t\t\u0003\u001b\f\u0019.!\u0002\u0002\u00185\u0011\u0011q\u001a\u0006\u0004\u0003#L\u0017a\u0002:v]RLW.Z\u0005\u0005\u0003+\fyMA\tBEN$(/Y2u\rVt7\r^5p]F\u0002B!!7\u0002`6\u0011\u00111\u001c\u0006\u0005\u0003;\f))\u0001\u0002j_&\u0019a0a7\u0015\u0005\u0005\u001d\u0017!B1qa2LH\u0003BA\f\u0003ODq!!\u0001\u0018\u0001\u0004\t)!A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u00055\u0018q\u001e\t\u0006Q\u0006\u0005\u0012Q\u0001\u0005\n\u0003cD\u0012\u0011!a\u0001\u0003/\t1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\t9\u0010\u0005\u0003\u0002\u0000\u0005e\u0018\u0002BA~\u0003\u0003\u0013aa\u00142kK\u000e$(aD\"sK\u0006$\u0018n\u001c8Tk\u000e\u001cWm]:\u0014\rm9\u00171B9u\u0003!\u0019G.[3oi&#WCAA\u001b\u0003%\u0019G.[3oi&#\u0007%\u0001\u0005sKN\u0004xN\\:f+\t\t\t%A\u0005sKN\u0004xN\\:fAQ1!q\u0002B\t\u0005'\u00012!!\u0004\u001c\u0011\u001d\u0011\t\u0001\ta\u0001\u0003kAqAa\u0002!\u0001\u0004\t\t\u0005\u0006\u0004\u0003\u0010\t]!\u0011\u0004\u0005\n\u0005\u0003\t\u0003\u0013!a\u0001\u0003kA\u0011Ba\u0002\"!\u0003\u0005\r!!\u0011\u0016\u0005\tu!\u0006BA\u001b\u0003O\nabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0003$)\"\u0011\u0011IA4)\u0011\tYJa\n\t\u0013\u0005\rf%!AA\u0002\u0005EE\u0003BAU\u0005WA\u0011\"a)(\u0003\u0003\u0005\r!a'\u0015\t\u0005u$q\u0006\u0005\n\u0003GC\u0013\u0011!a\u0001\u0003##B!!+\u00034!I\u00111U\u0016\u0002\u0002\u0003\u0007\u00111T\u0001\u0010\u0007J,\u0017\r^5p]N+8mY3tgB\u0019\u0011QB\u0017\u0014\u000b5\u0012Y$a6\u0011\u0015\u00055'QHA\u001b\u0003\u0003\u0012y!\u0003\u0003\u0003@\u0005='!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeQ\u0011!q\u0007\u000b\u0007\u0005\u001f\u0011)Ea\u0012\t\u000f\t\u0005\u0001\u00071\u0001\u00026!9!q\u0001\u0019A\u0002\u0005\u0005C\u0003\u0002B&\u0005'\u0002R\u0001[A\u0011\u0005\u001b\u0002r\u0001\u001bB(\u0003k\t\t%C\u0002\u0003R%\u0014a\u0001V;qY\u0016\u0014\u0004\"CAyc\u0005\u0005\t\u0019\u0001B\b\u0005=\u0019%/Z1uS>tg)Y5mkJ,7CB\u001ah\u0003\u0017\tH/A\u0001f+\t\u0011i\u0006E\u0002v\u0005?J1A!\u0019\u0000\u0005%!\u0006N]8xC\ndW-\u0001\u0002fAQ1!q\rB5\u0005W\u00022!!\u00044\u0011\u001d\u0011\t\u0001\u000fa\u0001\u0003kAqA!\u00179\u0001\u0004\u0011i&A\tbg6+7o]1hKN+G/\u0012:s_J,\"!a\u0014\u0015\r\t\u001d$1\u000fB;\u0011%\u0011\tA\u000fI\u0001\u0002\u0004\t)\u0004C\u0005\u0003Zi\u0002\n\u00111\u0001\u0003^U\u0011!\u0011\u0010\u0016\u0005\u0005;\n9\u0007\u0006\u0003\u0002\u001c\nu\u0004\"CAR\u007f\u0005\u0005\t\u0019AAI)\u0011\tIK!!\t\u0013\u0005\r\u0006)!AA\u0002\u0005mE\u0003BA?\u0005\u000bC\u0011\"a)B\u0003\u0003\u0005\r!!%\u0015\t\u0005%&\u0011\u0012\u0005\n\u0003G#\u0015\u0011!a\u0001\u00037\u000bqb\u0011:fCRLwN\u001c$bS2,(/\u001a\t\u0004\u0003\u001b15#\u0002$\u0003\u0012\u0006]\u0007CCAg\u0005{\t)D!\u0018\u0003hQ\u0011!Q\u0012\u000b\u0007\u0005O\u00129J!'\t\u000f\t\u0005\u0011\n1\u0001\u00026!9!\u0011L%A\u0002\tuC\u0003\u0002BO\u0005C\u0003R\u0001[A\u0011\u0005?\u0003r\u0001\u001bB(\u0003k\u0011i\u0006C\u0005\u0002r*\u000b\t\u00111\u0001\u0003hM\u0011AjZ\u0001\u000bg\u0016\u0014\u0018.\u00197ju\u0016\u0014\b\u0003\u0002BU\u0005_k!Aa+\u000b\u0007\t5&,\u0001\u0003kg>t\u0017\u0002\u0002BY\u0005W\u0013!#R7bS2\u001cV\r^*fe&\fG.\u001b>fe\u0006i!\r\\8c%\u0016\u001cx\u000e\u001c<feN\u0004BAa.\u0003>6\u0011!\u0011\u0018\u0006\u0004\u0005wS\u0016A\u0002:pkR,7/\u0003\u0003\u0003@\ne&!\u0004\"m_\n\u0014Vm]8mm\u0016\u00148/A\tii6dG+\u001a=u\u000bb$(/Y2u_J\u0004BA!2\u0003P6\u0011!q\u0019\u0006\u0005\u0005\u0013\u0014Y-\u0001\u0003ii6d'b\u0001Bg9\u0006!Q\u000f^5m\u0013\u0011\u0011\tNa2\u0003#!#X\u000e\u001c+fqR,\u0005\u0010\u001e:bGR|'/\u0001\bnC&d'm\u001c=NC:\fw-\u001a:\u0011\t\t]'Q\\\u0007\u0003\u00053T1Aa7]\u0003\u001di\u0017-\u001b7c_bLAAa8\u0003Z\nqQ*Y5mE>DX*\u00198bO\u0016\u0014\u0018!D2p]\u001aLw-\u001e:bi&|g\u000e\u0005\u0003\u0003f\n\u001dX\"\u0001.\n\u0007\t%(LA\tK\u001b\u0006\u00036i\u001c8gS\u001e,(/\u0019;j_:$BB!<\u0003p\nE(1\u001fB{\u0005o\u0004\"\u0001\u001a'\t\u000f\t\u0015&\u000b1\u0001\u0003(\"9!1\u0017*A\u0002\tU\u0006b\u0002Ba%\u0002\u0007!1\u0019\u0005\b\u0005'\u0014\u0006\u0019\u0001Bk\u0011\u001d\u0011\tO\u0015a\u0001\u0005GD3A\u0015B~!\u0011\u0011ipa\u0002\u000e\u0005\t}(\u0002BB\u0001\u0007\u0007\ta!\u001b8kK\u000e$(BAB\u0003\u0003\u0015Q\u0017M^1y\u0013\u0011\u0019IAa@\u0003\r%s'.Z2u\u0003\u0019\u0019'/Z1uKR11qBB\u001e\u0007\u000b\u0002ba!\u0005\u0004 \r\rRBAB\n\u0015\u0011\u0019)ba\u0006\u0002\u0013A,(\r\\5tQ\u0016\u0014(b\u00016\u0004\u001a)!\u0011QKB\u000e\u0015\t\u0019i\"A\u0004sK\u0006\u001cGo\u001c:\n\t\r\u000521\u0003\u0002\u0006'6{gn\u001c\t\u0004\u0007K\u0019abAB\u0014\u00019!1\u0011FB\u001d\u001d\u0011\u0019Yca\u000e\u000f\t\r52Q\u0007\b\u0005\u0007_\u0019\u0019DD\u0002x\u0007cI\u0011!Y\u0005\u0003?\u0002L!!\u00180\n\u0005mc\u0016BA-[\u0011\u001d\u0019id\u0015a\u0001\u0007\u007f\tqA]3rk\u0016\u001cH\u000f\u0005\u0003\u00028\r\u0005\u0013\u0002BB\"\u0003s\u0011q\"R7bS2\u001cV\r\u001e*fcV,7\u000f\u001e\u0005\b\u0007\u000f\u001a\u0006\u0019AB%\u00039i\u0017-\u001b7c_b\u001cVm]:j_:\u0004BAa6\u0004L%!1Q\nBm\u00059i\u0015-\u001b7c_b\u001cVm]:j_:$\u0002b!\u0015\u0004V\r]3q\f\t\u0007\u0007#\u0019yba\u0015\u0011\u0007\r\u0015\"\u0004C\u0004\u0003\u0002Q\u0003\r!!\u000e\t\u000f\ruB\u000b1\u0001\u0004ZA!\u0011qGB.\u0013\u0011\u0019i&!\u000f\u0003)\u0015k\u0017-\u001b7De\u0016\fG/[8o%\u0016\fX/Z:u\u0011\u001d\u00199\u0005\u0016a\u0001\u0007\u0013\na!\u00199qK:$GCCB3\u0007S\u001aYg!!\u0004\u0004B11\u0011CB\u0010\u0007O\u00022a!\n\u001c\u0011\u001d\u0011\t!\u0016a\u0001\u0003kAqa!\u001cV\u0001\u0004\u0019y'A\u0007baB,g\u000eZ\"p[6\fg\u000e\u001a\t\u0005\u0007c\u001aYH\u0004\u0003\u0004t\r]d\u0002BB\u0016\u0007kJ1Aa7]\u0013\u0011\u0019IH!7\u0002\u001d5+7o]1hK6\u000bg.Y4fe&!1QPB@\u00055\t\u0005\u000f]3oI\u000e{W.\\1oI*!1\u0011\u0010Bm\u0011\u001d\u00199%\u0016a\u0001\u0007\u0013Bqa!\"V\u0001\u0004\u00199)\u0001\u0006nC&d'm\u001c=JIN\u0004R!^BE\u0007\u001bK1aa#\u0000\u0005\u0011a\u0015n\u001d;\u0011\t\r=5QS\u0007\u0003\u0007#SAaa%\u0003Z\u0006)Qn\u001c3fY&!1qSBI\u0005%i\u0015-\u001b7c_bLE-A\bbg\u0006\u0003\b/\u001a8e\u0007>lW.\u00198e)\u0019\u0019ij!+\u0004,B9Qoa(\u0004$\u000e=\u0014bABQ\u007f\n1Q)\u001b;iKJ\u00042!^BS\u0013\r\u00199k \u0002\u0019\u00132dWmZ1m\u0003J<W/\\3oi\u0016C8-\u001a9uS>t\u0007bBB\u001f-\u0002\u00071\u0011\f\u0005\b\u0007[3\u0006\u0019ABX\u0003\u001diWm]:bO\u0016\u0004Ba!-\u0004<6\u001111\u0017\u0006\u0005\u0007k\u001b9,A\u0002e_6T1a!/]\u0003\u0019i\u0017.\\35U&!1QXBZ\u0005\u001diUm]:bO\u0016\u0004")
public class EmailSetCreatePerformer {
    private final EmailSetSerializer serializer;
    private final BlobResolvers blobResolvers;
    private final HtmlTextExtractor htmlTextExtractor;
    private final MailboxManager mailboxManager;
    private final JMAPConfiguration configuration;

    public SMono<CreationResults> create(EmailSetRequest request, MailboxSession mailboxSession) {
        SFlux qual$1 = SFlux$.MODULE$.fromIterable((Iterable)request.create().getOrElse((Function0 & Serializable)() -> (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
        Function1 & Serializable x$1 = (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                EmailCreationId clientId = (EmailCreationId)tuple2._1();
                JsObject json = (JsObject)tuple2._2();
                return (SMono)$this.serializer.deserializeCreationRequest((JsValue)json).fold((Function1 & Serializable)e -> SMono$.MODULE$.just((Object)new CreationFailure(clientId, new IllegalArgumentException(e.toString()))), (Function1 & Serializable)creationRequest -> this.create(clientId, (EmailCreationRequest)creationRequest, mailboxSession));
            }
            throw new MatchError((Object)tuple2);
        };
        int x$2 = qual$1.concatMap$default$2();
        return qual$1.concatMap((Function1)x$1, x$2).collectSeq().map((Function1)EmailSetCreatePerformer$CreationResults$.MODULE$);
    }

    private SMono<CreationResult> create(EmailCreationId clientId, EmailCreationRequest request, MailboxSession mailboxSession) {
        List<MailboxId> mailboxIds = request.mailboxIds().value();
        if (mailboxIds.size() != 1) {
            return SMono$.MODULE$.just((Object)new CreationFailure(clientId, new IllegalArgumentException("mailboxIds need to have size 1")));
        }
        return SMono$.MODULE$.fromCallable(() -> request.toMime4JMessage($this.blobResolvers, $this.htmlTextExtractor, mailboxSession)).flatMap((Function1 & Serializable)either -> (SMono)either.fold((Function1 & Serializable)e -> SMono$.MODULE$.just((Object)new CreationFailure(clientId, (Throwable)e)), (Function1 & Serializable)message -> (SMono)this.asAppendCommand(request, (Message)message).fold((Function1 & Serializable)e -> SMono$.MODULE$.error((Throwable)e), (Function1 & Serializable)appendCommand -> this.append(clientId, (MessageManager.AppendCommand)appendCommand, mailboxSession, mailboxIds)))).onErrorResume((Function1 & Serializable)e -> SMono$.MODULE$.just((Object)new CreationFailure(clientId, (Throwable)e))).subscribeOn(Schedulers.elastic());
    }

    private SMono<CreationSuccess> append(EmailCreationId clientId, MessageManager.AppendCommand appendCommand, MailboxSession mailboxSession, List<MailboxId> mailboxIds) {
        return SMono$.MODULE$.apply(this.mailboxManager.getMailboxReactive((MailboxId)mailboxIds.head(), mailboxSession)).flatMap((Function1 & Serializable)mailbox -> SMono$.MODULE$.apply(mailbox.appendMessageReactive(appendCommand, mailboxSession)).map((Function1 & Serializable)appendResult -> {
            Option blobId = BlobId$.MODULE$.of(appendResult.getId().getMessageId()).toOption();
            String threadId = ThreadId$.MODULE$.fromJava(appendResult.getThreadId());
            return new CreationSuccess(clientId, new EmailCreationResponse(appendResult.getId().getMessageId(), blobId, threadId, Size$.MODULE$.sanitizeSize(Predef$.MODULE$.Long2long(appendResult.getSize()))));
        }));
    }

    private Either<IllegalArgumentException, MessageManager.AppendCommand> asAppendCommand(EmailCreationRequest request, Message message) {
        return package$.MODULE$.Right().apply((Object)MessageManager.AppendCommand.builder().recent().withFlags((Flags)request.keywords().map((Function1 & Serializable)x$3 -> x$3.asFlags()).getOrElse((Function0 & Serializable)() -> new Flags())).withInternalDate(Date.from(((UTCDate)request.receivedAt().getOrElse((Function0 & Serializable)() -> new UTCDate(ZonedDateTime.now()))).asUTC().toInstant())).build(message)).flatMap((Function1 & Serializable)appendCommand -> (Either)OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional($this.configuration.getMaximumSendSize())).filter((Function1 & Serializable)limit -> BoxesRunTime.boxToBoolean((boolean)EmailSetCreatePerformer.$anonfun$asAppendCommand$5(appendCommand, limit))).map((Function1 & Serializable)limit -> package$.MODULE$.Left().apply((Object)new SizeExceededException(appendCommand.getMsgIn().size(), Predef$.MODULE$.Long2long(limit)))).getOrElse((Function0 & Serializable)() -> package$.MODULE$.Right().apply(appendCommand)));
    }

    public static final /* synthetic */ boolean $anonfun$asAppendCommand$5(MessageManager.AppendCommand appendCommand$2, Long limit) {
        return appendCommand$2.getMsgIn().size() > Predef$.MODULE$.Long2long(limit);
    }

    @Inject
    public EmailSetCreatePerformer(EmailSetSerializer serializer, BlobResolvers blobResolvers, HtmlTextExtractor htmlTextExtractor, MailboxManager mailboxManager, JMAPConfiguration configuration) {
        this.serializer = serializer;
        this.blobResolvers = blobResolvers;
        this.htmlTextExtractor = htmlTextExtractor;
        this.mailboxManager = mailboxManager;
        this.configuration = configuration;
    }

    public static class CreationFailure
    implements CreationResult,
    Product,
    Serializable {
        private final EmailCreationId clientId;
        private final Throwable e;

        public Iterator<Object> productIterator() {
            return Product.productIterator$((Product)this);
        }

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public EmailCreationId clientId() {
            return this.clientId;
        }

        public Throwable e() {
            return this.e;
        }

        public SetError asMessageSetError() {
            Throwable throwable = this.e();
            if (throwable instanceof MailboxNotFoundException) {
                MailboxNotFoundException mailboxNotFoundException = (MailboxNotFoundException)throwable;
                return SetError$.MODULE$.notFound(new StringBuilder(8).append("Mailbox ").append(mailboxNotFoundException.getMessage()).toString());
            }
            if (throwable instanceof BlobNotFoundException) {
                BlobNotFoundException blobNotFoundException = (BlobNotFoundException)throwable;
                return SetError$.MODULE$.invalidArguments(new StringBuilder(22).append("Attachment not found: ").append(new Refined((Object)blobNotFoundException.blobId().value())).toString(), (Option<Properties>)new Some((Object)Properties$.MODULE$.apply((Seq<Refined<String, boolean.Not<collection.Empty>>>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"attachments")).value()))}))));
            }
            if (throwable instanceof IllegalArgumentException) {
                IllegalArgumentException illegalArgumentException = (IllegalArgumentException)throwable;
                return SetError$.MODULE$.invalidArguments(illegalArgumentException.getMessage(), SetError$.MODULE$.invalidArguments$default$2());
            }
            if (throwable instanceof OverQuotaException) {
                OverQuotaException overQuotaException = (OverQuotaException)throwable;
                return SetError$.MODULE$.overQuota(overQuotaException.getMessage());
            }
            return SetError$.MODULE$.serverFail(this.e().getMessage());
        }

        public CreationFailure copy(EmailCreationId clientId, Throwable e) {
            return new CreationFailure(clientId, e);
        }

        public EmailCreationId copy$default$1() {
            return this.clientId();
        }

        public Throwable copy$default$2() {
            return this.e();
        }

        public String productPrefix() {
            return "CreationFailure";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.clientId();
                }
                case 1: {
                    return this.e();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof CreationFailure;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "clientId";
                }
                case 1: {
                    return "e";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof CreationFailure)) return false;
            boolean bl = true;
            if (!bl) return false;
            CreationFailure creationFailure = (CreationFailure)x$1;
            EmailCreationId emailCreationId = this.clientId();
            EmailCreationId emailCreationId2 = creationFailure.clientId();
            if (emailCreationId == null) {
                if (emailCreationId2 != null) {
                    return false;
                }
            } else if (!((Object)emailCreationId).equals(emailCreationId2)) return false;
            Throwable throwable = this.e();
            Throwable throwable2 = creationFailure.e();
            if (throwable == null) {
                if (throwable2 != null) {
                    return false;
                }
            } else if (!throwable.equals(throwable2)) return false;
            if (!creationFailure.canEqual(this)) return false;
            return true;
        }

        public CreationFailure(EmailCreationId clientId, Throwable e) {
            this.clientId = clientId;
            this.e = e;
            Product.$init$((Product)this);
        }
    }

    public static interface CreationResult {
    }

    public static class CreationResults
    implements Product,
    Serializable {
        private final Seq<CreationResult> results;

        public Iterator<Object> productIterator() {
            return Product.productIterator$((Product)this);
        }

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public Seq<CreationResult> results() {
            return this.results;
        }

        public Option<Map<EmailCreationId, EmailCreationResponse>> created() {
            return Option$.MODULE$.apply((Object)((IterableOnceOps)this.results().flatMap((Function1 & Serializable)x0$1 -> {
                CreationResult creationResult = x0$1;
                if (creationResult instanceof CreationSuccess) {
                    CreationSuccess creationSuccess = (CreationSuccess)creationResult;
                    return new Some((Object)new Tuple2((Object)creationSuccess.clientId(), (Object)creationSuccess.response()));
                }
                return None$.MODULE$;
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.nonEmpty()));
        }

        public Option<Map<EmailCreationId, SetError>> notCreated() {
            return Option$.MODULE$.apply((Object)((IterableOnceOps)this.results().flatMap((Function1 & Serializable)x0$1 -> {
                CreationResult creationResult = x0$1;
                if (creationResult instanceof CreationFailure) {
                    CreationFailure creationFailure = (CreationFailure)creationResult;
                    return new Some((Object)new Tuple2((Object)creationFailure.clientId(), (Object)creationFailure.asMessageSetError()));
                }
                return None$.MODULE$;
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.nonEmpty()));
        }

        public CreationResults copy(Seq<CreationResult> results) {
            return new CreationResults(results);
        }

        public Seq<CreationResult> copy$default$1() {
            return this.results();
        }

        public String productPrefix() {
            return "CreationResults";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.results();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof CreationResults;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "results";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof CreationResults)) return false;
            boolean bl = true;
            if (!bl) return false;
            CreationResults creationResults = (CreationResults)x$1;
            Seq<CreationResult> seq = this.results();
            Seq<CreationResult> seq2 = creationResults.results();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            if (!creationResults.canEqual(this)) return false;
            return true;
        }

        public CreationResults(Seq<CreationResult> results) {
            this.results = results;
            Product.$init$((Product)this);
        }
    }

    public static class CreationSuccess
    implements CreationResult,
    Product,
    Serializable {
        private final EmailCreationId clientId;
        private final EmailCreationResponse response;

        public Iterator<Object> productIterator() {
            return Product.productIterator$((Product)this);
        }

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public EmailCreationId clientId() {
            return this.clientId;
        }

        public EmailCreationResponse response() {
            return this.response;
        }

        public CreationSuccess copy(EmailCreationId clientId, EmailCreationResponse response) {
            return new CreationSuccess(clientId, response);
        }

        public EmailCreationId copy$default$1() {
            return this.clientId();
        }

        public EmailCreationResponse copy$default$2() {
            return this.response();
        }

        public String productPrefix() {
            return "CreationSuccess";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.clientId();
                }
                case 1: {
                    return this.response();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof CreationSuccess;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "clientId";
                }
                case 1: {
                    return "response";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof CreationSuccess)) return false;
            boolean bl = true;
            if (!bl) return false;
            CreationSuccess creationSuccess = (CreationSuccess)x$1;
            EmailCreationId emailCreationId = this.clientId();
            EmailCreationId emailCreationId2 = creationSuccess.clientId();
            if (emailCreationId == null) {
                if (emailCreationId2 != null) {
                    return false;
                }
            } else if (!((Object)emailCreationId).equals(emailCreationId2)) return false;
            EmailCreationResponse emailCreationResponse = this.response();
            EmailCreationResponse emailCreationResponse2 = creationSuccess.response();
            if (emailCreationResponse == null) {
                if (emailCreationResponse2 != null) {
                    return false;
                }
            } else if (!((Object)emailCreationResponse).equals(emailCreationResponse2)) return false;
            if (!creationSuccess.canEqual(this)) return false;
            return true;
        }

        public CreationSuccess(EmailCreationId clientId, EmailCreationResponse response) {
            this.clientId = clientId;
            this.response = response;
            Product.$init$((Product)this);
        }
    }
}

