/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.policies;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.policies.ReconnectionPolicy;

public class ConstantReconnectionPolicy
implements ReconnectionPolicy {
    private final long delayMs;

    public ConstantReconnectionPolicy(long constantDelayMs) {
        if (constantDelayMs < 0L) {
            throw new IllegalArgumentException(String.format("Invalid negative delay (got %d)", constantDelayMs));
        }
        this.delayMs = constantDelayMs;
    }

    public long getConstantDelayMs() {
        return this.delayMs;
    }

    @Override
    public ReconnectionPolicy.ReconnectionSchedule newSchedule() {
        return new ConstantSchedule();
    }

    @Override
    public void init(Cluster cluster) {
    }

    @Override
    public void close() {
    }

    private class ConstantSchedule
    implements ReconnectionPolicy.ReconnectionSchedule {
        private ConstantSchedule() {
        }

        @Override
        public long nextDelayMs() {
            return ConstantReconnectionPolicy.this.delayMs;
        }
    }
}

