/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.utils;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.Scanner;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.internal.ThrowableUtils;

public class IOPipe {
    private Object input;
    private Object output;
    private boolean byLines;
    private boolean closeIn = true;
    private boolean closeOut;
    private int buffSize = 1024;
    private LineProcessor lineProcessor;

    private IOPipe(Object input, Object output) {
        ThrowableUtils.assertFieldNotNull(input, "input");
        ThrowableUtils.assertFieldNotNull(output, "output");
        if (input instanceof InputStream || input instanceof Reader || input instanceof File || input instanceof byte[] || input instanceof CharSequence || input == null) {
            this.input = input;
        } else {
            ThrowableUtils.illegalArg("Invalid input class type.  Must be one of the following:  InputStream, Reader, CharSequence, byte[], File", new Object[0]);
        }
        if (output instanceof OutputStream || output instanceof Writer) {
            this.output = output;
        } else {
            ThrowableUtils.illegalArg("Invalid output class type.  Must be one of the following:  OutputStream, Writer", new Object[0]);
        }
    }

    public static IOPipe create(Object input, Object output) {
        return new IOPipe(input, output);
    }

    public IOPipe closeOut() {
        this.closeOut = true;
        return this;
    }

    public IOPipe close(boolean in, boolean out) {
        this.closeIn = in;
        this.closeOut = out;
        return this;
    }

    public IOPipe buffSize(int buffSize) {
        ThrowableUtils.assertFieldPositive(buffSize, "buffSize");
        this.buffSize = buffSize;
        return this;
    }

    public IOPipe byLines(boolean byLines) {
        this.byLines = byLines;
        return this;
    }

    public IOPipe byLines() {
        this.byLines = true;
        return this;
    }

    public IOPipe lineProcessor(LineProcessor lineProcessor) {
        this.lineProcessor = lineProcessor;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run() throws IOException {
        int c = 0;
        try {
            if (this.input == null) {
                int n = 0;
                return n;
            }
            if ((this.input instanceof InputStream || this.input instanceof byte[]) && this.output instanceof OutputStream && this.lineProcessor == null) {
                OutputStream out = (OutputStream)this.output;
                if (this.input instanceof InputStream) {
                    int i;
                    InputStream in = (InputStream)this.input;
                    byte[] b = new byte[this.buffSize];
                    while ((i = in.read(b)) > 0) {
                        c += i;
                        out.write(b, 0, i);
                    }
                } else {
                    byte[] b = (byte[])this.input;
                    out.write(b);
                    c = b.length;
                }
                out.flush();
            } else {
                Writer out = this.output instanceof Writer ? (Writer)this.output : new OutputStreamWriter((OutputStream)this.output, IOUtils.UTF8);
                this.closeIn |= this.input instanceof File;
                if (this.byLines || this.lineProcessor != null) {
                    Reader in = null;
                    if (this.input instanceof Reader) {
                        in = (Reader)this.input;
                    } else if (this.input instanceof InputStream) {
                        in = new InputStreamReader((InputStream)this.input, IOUtils.UTF8);
                    } else if (this.input instanceof File) {
                        in = new FileReader((File)this.input);
                    } else if (this.input instanceof byte[]) {
                        in = new StringReader(new String((byte[])this.input, "UTF8"));
                    } else if (this.input instanceof CharSequence) {
                        in = new StringReader(this.input.toString());
                    }
                    try (Scanner s = new Scanner(in);){
                        while (s.hasNextLine()) {
                            String l = s.nextLine();
                            if (this.lineProcessor != null) {
                                l = this.lineProcessor.process(l);
                            }
                            if (l == null) continue;
                            out.write(l);
                            out.write("\n");
                            out.flush();
                            c += l.length() + 1;
                        }
                    }
                } else {
                    if (this.input instanceof InputStream) {
                        this.input = new InputStreamReader((InputStream)this.input, IOUtils.UTF8);
                    } else if (this.input instanceof File) {
                        this.input = new FileReader((File)this.input);
                    } else if (this.input instanceof byte[]) {
                        this.input = new String((byte[])this.input, IOUtils.UTF8);
                    }
                    if (this.input instanceof Reader) {
                        int i;
                        Reader in = (Reader)this.input;
                        char[] b = new char[this.buffSize];
                        while ((i = in.read(b)) > 0) {
                            c += i;
                            out.write(b, 0, i);
                        }
                    } else {
                        String s = this.input.toString();
                        out.write(s);
                        c = s.length();
                    }
                }
                out.flush();
            }
        }
        finally {
            this.closeQuietly(this.input, this.output);
        }
        return c;
    }

    private void closeQuietly(Object input, Object output) {
        if (this.closeIn) {
            IOUtils.closeQuietly(input);
        }
        if (this.closeOut) {
            IOUtils.closeQuietly(output);
        }
    }

    public static interface LineProcessor {
        public String process(String var1);
    }
}

