/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.util.Comparator;
import org.apache.juneau.PropertyConverter;

public enum PropertyType {
    STRING("String", "s", PropertyConverter.STRING_CONVERTER),
    BOOLEAN("Boolean", "b", PropertyConverter.BOOLEAN_CONVERTER),
    INTEGER("Integer", "i", PropertyConverter.INTEGER_CONVERTER),
    CLASS("Class", "c", PropertyConverter.CLASS_CONVERTER),
    OBJECT("Object", "o", PropertyConverter.OBJECT_CONVERTER),
    SET_STRING("Set<String>", "ss", PropertyConverter.STRING_CONVERTER),
    SET_INTEGER("Set<Integer>", "si", PropertyConverter.INTEGER_CONVERTER),
    SET_CLASS("Set<Class>", "sc", PropertyConverter.CLASS_CONVERTER),
    LIST_STRING("List<String>", "ls", PropertyConverter.STRING_CONVERTER),
    LIST_INTEGER("List<Integer>", "li", PropertyConverter.INTEGER_CONVERTER),
    LIST_CLASS("List<Class>", "lc", PropertyConverter.CLASS_CONVERTER),
    LIST_OBJECT("List<Object>", "lo", PropertyConverter.OBJECT_CONVERTER),
    SORTED_MAP_STRING("Map<String,String>", "sms", PropertyConverter.STRING_CONVERTER),
    SORTED_MAP_INTEGER("Map<String,Integer>", "smi", PropertyConverter.INTEGER_CONVERTER),
    SORTED_MAP_CLASS("Map<String,Class>", "smc", PropertyConverter.CLASS_CONVERTER),
    SORTED_MAP_OBJECT("Map<String,Object>", "smo", PropertyConverter.OBJECT_CONVERTER),
    ORDERED_MAP_STRING("Map<String,String>", "oms", PropertyConverter.STRING_CONVERTER),
    ORDERED_MAP_INTEGER("Map<String,Integer>", "omi", PropertyConverter.INTEGER_CONVERTER),
    ORDERED_MAP_CLASS("Map<String,Class>", "omc", PropertyConverter.CLASS_CONVERTER),
    ORDERED_MAP_OBJECT("Map<String,Object>", "omo", PropertyConverter.OBJECT_CONVERTER);

    private final String type;
    private final String suffix;
    final PropertyConverter<?> converter;
    private static final Comparator CLASS_COMPARATOR;

    private PropertyType(String type, String suffix, PropertyConverter<?> converter) {
        this.type = type;
        this.suffix = suffix;
        this.converter = converter;
    }

    public String toString() {
        return this.type;
    }

    String getSuffix() {
        return this.suffix;
    }

    Comparator<? super Object> comparator() {
        switch (this) {
            case SET_CLASS: {
                return CLASS_COMPARATOR;
            }
        }
        return null;
    }

    static {
        CLASS_COMPARATOR = new Comparator<Class<?>>(){

            @Override
            public int compare(Class<?> object1, Class<?> object2) {
                return object1.getName().compareTo(object2.getName());
            }
        };
    }
}

