/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.assertions;

import java.util.Collection;
import org.apache.juneau.assertions.Assertion;
import org.apache.juneau.assertions.FluentObjectAssertion;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.internal.ObjectUtils;
import org.apache.juneau.marshall.SimpleJson;

@FluentSetters(returns="FluentCollectionAssertion<R>")
public class FluentCollectionAssertion<R>
extends FluentObjectAssertion<R> {
    private Collection value;

    public FluentCollectionAssertion(Collection contents, R returns) {
        this(null, contents, returns);
    }

    public FluentCollectionAssertion(Assertion creator, Collection contents, R returns) {
        super(creator, contents, returns);
        this.value = contents;
    }

    public R isEmpty() throws AssertionError {
        this.exists();
        if (!this.value.isEmpty()) {
            throw this.error("Collection was not empty.", new Object[0]);
        }
        return this.returns();
    }

    public R contains(Object value) throws AssertionError {
        this.exists();
        for (Object o : this.value) {
            if (!ObjectUtils.eq(o, value)) continue;
            return this.returns();
        }
        throw this.error("Collection did not contain expected value.\nContents: {0}\nExpected:{1}", SimpleJson.DEFAULT.toString(this.value), value);
    }

    public R doesNotContain(Object value) throws AssertionError {
        this.exists();
        for (Object o : this.value) {
            if (!ObjectUtils.eq(o, value)) continue;
            throw this.error("Collection contained unexpected value.\nContents: {0}\nUnexpected:{1}", SimpleJson.DEFAULT.toString(this.value), value);
        }
        return this.returns();
    }

    public R isNotEmpty() throws AssertionError {
        this.exists();
        if (this.value.isEmpty()) {
            throw this.error("Collection was empty.", new Object[0]);
        }
        return this.returns();
    }

    public R isSize(int size) throws AssertionError {
        this.exists();
        if (this.value.size() != size) {
            throw this.error("Collection did not have the expected size.  Expected={0}, Actual={1}.", size, this.value.size());
        }
        return this.returns();
    }

    @Override
    public FluentCollectionAssertion<R> msg(String msg, Object ... args) {
        super.msg(msg, args);
        return this;
    }

    @Override
    public FluentCollectionAssertion<R> stderr() {
        super.stderr();
        return this;
    }

    @Override
    public FluentCollectionAssertion<R> stdout() {
        super.stdout();
        return this;
    }
}

