/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.httppart;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.http.Header;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.assertions.Assertions;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.http.HttpParts;
import org.apache.juneau.http.header.BasicStringHeader;
import org.apache.juneau.httppart.HttpPartParserSession;
import org.apache.juneau.httppart.HttpPartType;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.internal.ThrowableUtils;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.httppart.RequestHeader;
import org.apache.juneau.rest.httppart.RequestQueryParam;
import org.apache.juneau.rest.httppart.RequestQueryParams;
import org.apache.juneau.svl.VarResolverSession;

public class RequestHeaders {
    private final RestRequest req;
    private final boolean caseSensitive;
    private final VarResolverSession vs;
    private HttpPartParserSession parser;
    private List<RequestHeader> list = new LinkedList<RequestHeader>();
    private Map<String, List<RequestHeader>> map = new TreeMap<String, List<RequestHeader>>();

    public RequestHeaders(RestRequest req, RequestQueryParams query, boolean caseSensitive) {
        this.req = req;
        this.caseSensitive = caseSensitive;
        this.vs = req.getVarResolverSession();
        Enumeration e = req.getHttpServletRequest().getHeaderNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String key = this.key(name);
            ArrayList<RequestHeader> l = CollectionUtils.list(new RequestHeader[0]);
            Enumeration ve = req.getHttpServletRequest().getHeaders(name);
            while (ve.hasMoreElements()) {
                RequestHeader h = new RequestHeader(req, name, (String)ve.nextElement());
                this.list.add(h);
                l.add(h);
            }
            this.map.put(key, l);
        }
        Set<String> allowedHeaderParams = req.getContext().getAllowedHeaderParams();
        for (RequestQueryParam p : query.getAll()) {
            String name = p.getName();
            String key = this.key(name);
            if (!allowedHeaderParams.contains(key) && !allowedHeaderParams.contains("*")) continue;
            this.set(name, p.getValue());
        }
    }

    private RequestHeaders(RequestHeaders copyFrom) {
        this.req = copyFrom.req;
        this.caseSensitive = copyFrom.caseSensitive;
        this.parser = copyFrom.parser;
        this.list.addAll(copyFrom.list);
        this.map.putAll(copyFrom.map);
        this.vs = copyFrom.vs;
    }

    private RequestHeaders(RequestHeaders copyFrom, Map<String, List<RequestHeader>> headerMap) {
        this.req = copyFrom.req;
        this.map.putAll(headerMap);
        this.list = headerMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        this.parser = copyFrom.parser;
        this.caseSensitive = copyFrom.caseSensitive;
        this.vs = copyFrom.vs;
    }

    public RequestHeaders parser(HttpPartParserSession value) {
        this.parser = value;
        for (RequestHeader h : this.list) {
            h.parser(this.parser);
        }
        return this;
    }

    public RequestHeaders addDefault(List<Header> pairs) {
        Assertions.assertArgNotNull("pairs", pairs);
        for (Header p : pairs) {
            boolean hasAllBlanks;
            String name = p.getName();
            String key = this.key(name);
            List<RequestHeader> l = this.map.get(key);
            boolean bl = hasAllBlanks = l != null && l.stream().allMatch(x -> StringUtils.isEmpty(x.getValue()));
            if (l != null && !hasAllBlanks) continue;
            if (hasAllBlanks) {
                this.list.removeAll(l);
            }
            RequestHeader x2 = new RequestHeader(this.req, name, this.vs.resolve(p.getValue()));
            this.list.add(x2);
            this.map.put(key, CollectionUtils.list(x2));
        }
        return this;
    }

    public RequestHeaders addDefault(Header ... pairs) {
        return this.addDefault(CollectionUtils.alist(pairs));
    }

    public RequestHeaders addDefault(String name, String value) {
        return this.addDefault(BasicStringHeader.of(name, value));
    }

    public List<RequestHeader> getAll(String name) {
        Assertions.assertArgNotNull("name", name);
        List<RequestHeader> l = this.map.get(this.key(name));
        return l == null ? CollectionUtils.emptyList() : CollectionUtils.unmodifiable(l);
    }

    public List<RequestHeader> getAll() {
        return CollectionUtils.unmodifiable(this.list);
    }

    public boolean contains(String ... names) {
        Assertions.assertArgNotNull("names", names);
        for (String n : names) {
            if (this.map.containsKey(this.key(n))) continue;
            return false;
        }
        return true;
    }

    public boolean containsAny(String ... names) {
        Assertions.assertArgNotNull("names", names);
        for (String n : names) {
            if (!this.map.containsKey(this.key(n))) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public RequestHeaders add(String name, Object value) {
        Assertions.assertArgNotNull("name", name);
        String key = this.key(name);
        RequestHeader h = new RequestHeader(this.req, name, StringUtils.stringify(value)).parser(this.parser);
        if (this.map.containsKey(key)) {
            this.map.get(key).add(h);
        } else {
            this.map.put(key, CollectionUtils.list(h));
        }
        this.list.add(h);
        return this;
    }

    public RequestHeaders add(Header ... headers) {
        Assertions.assertArgNotNull("headers", headers);
        for (Header h : headers) {
            if (h == null) continue;
            this.add(h.getName(), h.getValue());
        }
        return this;
    }

    public RequestHeaders set(String name, Object value) {
        Assertions.assertArgNotNull("name", name);
        String key = this.key(name);
        this.remove(key);
        RequestHeader h = new RequestHeader(this.req, name, StringUtils.stringify(value)).parser(this.parser);
        this.map.put(key, CollectionUtils.list(h));
        this.list.add(h);
        return this;
    }

    public RequestHeaders set(Header ... headers) {
        Assertions.assertArgNotNull("headers", headers);
        for (Header h : headers) {
            this.remove(h);
        }
        for (Header h : headers) {
            this.add(h);
        }
        return this;
    }

    public RequestHeaders remove(String ... name) {
        Assertions.assertArgNotNull("name", name);
        for (String n : name) {
            String key = this.key(n);
            if (this.map.containsKey(key)) {
                this.list.removeAll((Collection)this.map.get(key));
            }
            this.map.remove(key);
        }
        return this;
    }

    public RequestHeaders remove(Header ... headers) {
        for (Header h : headers) {
            this.remove(h.getName());
        }
        return this;
    }

    public RequestHeaders subset(String ... headers) {
        Map<String, List<RequestHeader>> m = CollectionUtils.alist(headers).stream().map(x -> this.key((String)x)).filter(this.map::containsKey).collect(Collectors.toMap(Function.identity(), this.map::get));
        return new RequestHeaders(this, m);
    }

    public RequestHeader getFirst(String name) {
        Assertions.assertArgNotNull("name", name);
        List<RequestHeader> l = this.map.get(this.key(name));
        return l == null || l.isEmpty() ? new RequestHeader(this.req, name, null).parser(this.parser) : l.get(0);
    }

    public RequestHeader getLast(String name) {
        Assertions.assertArgNotNull("name", name);
        List<RequestHeader> l = this.map.get(this.key(name));
        return l == null || l.isEmpty() ? new RequestHeader(this.req, name, null).parser(this.parser) : l.get(l.size() - 1);
    }

    public RequestHeader get(String name) {
        List<RequestHeader> l = this.getAll(name);
        if (l.isEmpty()) {
            return new RequestHeader(this.req, name, null).parser(this.parser);
        }
        if (l.size() == 1) {
            return l.get(0);
        }
        StringBuilder sb = new StringBuilder(128);
        int j = l.size();
        for (int i = 0; i < j; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(l.get(i).getValue());
        }
        return new RequestHeader(this.req, name, sb.toString()).parser(this.parser);
    }

    public <T> Optional<T> get(Class<T> type) {
        ClassMeta<T> cm = this.req.getBeanSession().getClassMeta(type);
        String name = HttpParts.getName(HttpPartType.HEADER, cm).orElseThrow(() -> ThrowableUtils.runtimeException("@Header(name) not found on class {0}", ClassUtils.className(type)));
        return this.get(name).as(type);
    }

    public RequestHeaders copy() {
        return new RequestHeaders(this);
    }

    public String toString(boolean sorted) {
        JsonMap m = JsonMap.create();
        if (sorted) {
            for (List<RequestHeader> h1 : this.map.values()) {
                for (RequestHeader h2 : h1) {
                    m.append(h2.getName(), h2.getValue());
                }
            }
        } else {
            for (RequestHeader h : this.list) {
                m.append(h.getName(), h.getValue());
            }
        }
        return m.toString();
    }

    private String key(String name) {
        return this.caseSensitive ? name : name.toLowerCase();
    }

    public String toString() {
        return this.toString(false);
    }
}

