/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.apache.juneau.AnnotationApplier;
import org.apache.juneau.BeanContext;
import org.apache.juneau.annotation.TargetedAnnotationTBuilder;
import org.apache.juneau.annotation.TargetedAnnotationTImpl;
import org.apache.juneau.http.annotation.Request;
import org.apache.juneau.httppart.HttpPartParser;
import org.apache.juneau.httppart.HttpPartSerializer;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.reflect.AnnotationInfo;
import org.apache.juneau.svl.VarResolverSession;

public class RequestAnnotation {
    public static final Request DEFAULT = RequestAnnotation.create().build();

    public static Builder create() {
        return new Builder();
    }

    public static Builder create(Class<?> ... on) {
        return RequestAnnotation.create().on((Class[])on);
    }

    public static Builder create(String ... on) {
        return RequestAnnotation.create().on(on);
    }

    @Documented
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Inherited
    public static @interface Array {
        public Request[] value();
    }

    public static class Applier
    extends AnnotationApplier<Request, BeanContext.Builder> {
        public Applier(VarResolverSession vr) {
            super(Request.class, BeanContext.Builder.class, vr);
        }

        @Override
        public void apply(AnnotationInfo<Request> ai, BeanContext.Builder b) {
            Request a = ai.inner();
            if (ArrayUtils.isEmptyArray(a.on(), a.onClass())) {
                return;
            }
            b.annotations(a);
        }
    }

    private static class Impl
    extends TargetedAnnotationTImpl
    implements Request {
        private final Class<? extends HttpPartParser> parser;
        private final Class<? extends HttpPartSerializer> serializer;

        Impl(Builder b) {
            super(b);
            this.parser = b.parser;
            this.serializer = b.serializer;
            this.postConstruct();
        }

        @Override
        public Class<? extends HttpPartParser> parser() {
            return this.parser;
        }

        @Override
        public Class<? extends HttpPartSerializer> serializer() {
            return this.serializer;
        }
    }

    public static class Builder
    extends TargetedAnnotationTBuilder {
        Class<? extends HttpPartParser> parser = HttpPartParser.Void.class;
        Class<? extends HttpPartSerializer> serializer = HttpPartSerializer.Void.class;

        protected Builder() {
            super(Request.class);
        }

        public Request build() {
            return new Impl(this);
        }

        public Builder parser(Class<? extends HttpPartParser> value) {
            this.parser = value;
            return this;
        }

        public Builder serializer(Class<? extends HttpPartSerializer> value) {
            this.serializer = value;
            return this;
        }

        @Override
        public Builder on(String ... values) {
            super.on(values);
            return this;
        }

        @Override
        public Builder on(Class<?> ... value) {
            super.on(value);
            return this;
        }

        @Override
        public Builder onClass(Class<?> ... value) {
            super.onClass(value);
            return this;
        }
    }
}

