/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.serializer;

import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.function.Consumer;
import org.apache.juneau.UriContext;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.http.header.MediaType;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.internal.FluentSetter;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.SerializerPipe;
import org.apache.juneau.serializer.SerializerSession;
import org.apache.juneau.serializer.WriterSerializer;
import org.apache.juneau.svl.VarResolverSession;

public class WriterSerializerSession
extends SerializerSession {
    private final WriterSerializer ctx;
    private final boolean useWhitespace;
    private final Charset streamCharset;
    private final Charset fileCharset;

    public static Builder create(WriterSerializer ctx) {
        return new Builder(ctx);
    }

    protected WriterSerializerSession(Builder builder) {
        super(builder);
        this.ctx = builder.ctx;
        this.streamCharset = builder.streamCharset;
        this.fileCharset = builder.fileCharset;
        this.useWhitespace = builder.useWhitespace;
    }

    @Override
    public final boolean isWriterSerializer() {
        return true;
    }

    @Override
    protected SerializerPipe createPipe(Object output) {
        return new SerializerPipe(output, this.streamCharset, this.fileCharset);
    }

    @Override
    public final String serialize(Object o) throws SerializeException {
        StringWriter w = new StringWriter();
        try {
            this.serialize(o, w);
        }
        catch (IOException e) {
            throw new SerializeException(e);
        }
        return w.toString();
    }

    @Override
    public final String serializeToString(Object o) throws SerializeException {
        return this.serialize(o);
    }

    protected final int getMaxIndent() {
        return this.ctx.getMaxIndent();
    }

    protected char getQuoteChar() {
        return this.ctx.getQuoteChar();
    }

    protected final boolean isUseWhitespace() {
        return this.useWhitespace;
    }

    public Charset getFileCharset() {
        return this.fileCharset;
    }

    public Charset getStreamCharset() {
        return this.streamCharset;
    }

    @Override
    protected JsonMap properties() {
        return JsonMap.filteredMap("fileCharset", this.fileCharset, "streamCharset", this.streamCharset, "useWhitespace", this.useWhitespace);
    }

    @FluentSetters
    public static class Builder
    extends SerializerSession.Builder {
        WriterSerializer ctx;
        boolean useWhitespace;
        Charset fileCharset;
        Charset streamCharset;

        protected Builder(WriterSerializer ctx) {
            super(ctx);
            this.ctx = ctx;
            this.useWhitespace = ctx.useWhitespace;
            this.fileCharset = ctx.fileCharset;
            this.streamCharset = ctx.streamCharset;
        }

        @Override
        public WriterSerializerSession build() {
            return new WriterSerializerSession(this);
        }

        @FluentSetter
        public Builder fileCharset(Charset value) {
            if (value != null) {
                this.fileCharset = value;
            }
            return this;
        }

        @FluentSetter
        public Builder streamCharset(Charset value) {
            if (value != null) {
                this.streamCharset = value;
            }
            return this;
        }

        @FluentSetter
        public Builder useWhitespace(Boolean value) {
            if (value != null) {
                this.useWhitespace = value;
            }
            return this;
        }

        @Override
        public <T> Builder apply(Class<T> type, Consumer<T> apply) {
            super.apply((Class)type, (Consumer)apply);
            return this;
        }

        @Override
        public Builder debug(Boolean value) {
            super.debug(value);
            return this;
        }

        @Override
        public Builder properties(Map<String, Object> value) {
            super.properties((Map)value);
            return this;
        }

        @Override
        public Builder property(String key, Object value) {
            super.property(key, value);
            return this;
        }

        @Override
        public Builder unmodifiable() {
            super.unmodifiable();
            return this;
        }

        @Override
        public Builder locale(Locale value) {
            super.locale(value);
            return this;
        }

        @Override
        public Builder localeDefault(Locale value) {
            super.localeDefault(value);
            return this;
        }

        @Override
        public Builder mediaType(MediaType value) {
            super.mediaType(value);
            return this;
        }

        @Override
        public Builder mediaTypeDefault(MediaType value) {
            super.mediaTypeDefault(value);
            return this;
        }

        @Override
        public Builder timeZone(TimeZone value) {
            super.timeZone(value);
            return this;
        }

        @Override
        public Builder timeZoneDefault(TimeZone value) {
            super.timeZoneDefault(value);
            return this;
        }

        @Override
        public Builder javaMethod(Method value) {
            super.javaMethod(value);
            return this;
        }

        @Override
        public Builder resolver(VarResolverSession value) {
            super.resolver(value);
            return this;
        }

        @Override
        public Builder schema(HttpPartSchema value) {
            super.schema(value);
            return this;
        }

        @Override
        public Builder schemaDefault(HttpPartSchema value) {
            super.schemaDefault(value);
            return this;
        }

        @Override
        public Builder uriContext(UriContext value) {
            super.uriContext(value);
            return this;
        }
    }
}

