/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.httppart;

import java.util.Map;
import org.apache.juneau.BeanBuilder;
import org.apache.juneau.cp.BeanStore;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.rest.httppart.NamedAttribute;

public class NamedAttributeList {
    final NamedAttribute[] entries;

    public static Builder create() {
        return new Builder();
    }

    public static NamedAttributeList of(NamedAttribute ... values) {
        return (NamedAttributeList)NamedAttributeList.create().add(values).build();
    }

    public NamedAttributeList(Builder b) {
        this.entries = b.entries.values().toArray(new NamedAttribute[b.entries.size()]);
    }

    public Builder copy() {
        return this.copy().add(this.entries);
    }

    @FluentSetters
    public static class Builder
    extends BeanBuilder<NamedAttributeList> {
        Map<String, NamedAttribute> entries;

        protected Builder() {
            super(NamedAttributeList.class, BeanStore.INSTANCE);
            this.entries = CollectionUtils.map();
        }

        protected Builder(Builder copyFrom) {
            super((BeanBuilder)copyFrom);
            this.entries = CollectionUtils.copyOf(copyFrom.entries);
        }

        protected NamedAttributeList buildDefault() {
            return new NamedAttributeList(this);
        }

        public Builder copy() {
            return new Builder(this);
        }

        public Builder add(NamedAttribute ... values) {
            for (NamedAttribute v : values) {
                this.entries.put(v.getName(), v);
            }
            return this;
        }

        public Builder impl(Object value) {
            super.impl(value);
            return this;
        }

        public Builder type(Class<?> value) {
            super.type(value);
            return this;
        }
    }
}

