/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.delta.CheckpointMetaData;
import org.apache.spark.sql.delta.Checkpoints;
import org.apache.spark.sql.delta.DeltaConfigs$;
import org.apache.spark.sql.delta.DeltaHistoryManager;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.Snapshot;
import org.apache.spark.sql.delta.SnapshotManagement;
import org.apache.spark.sql.delta.actions.Metadata;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.util.FileNames$;
import org.apache.spark.unsafe.types.CalendarInterval;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.collection.Iterator;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001-4\u0001\u0002C\u0005\u0011\u0002\u0007\u0005A\u0003\u001b\u0005\u0006C\u0001!\tA\t\u0005\u0006M\u0001!\ta\n\u0005\u0006g\u0001!\t\u0001\u000e\u0005\u0006s\u0001!\tE\u000f\u0005\u0007\u0003\u0002!\t!\u0003\"\t\u000b\u0011\u0003A\u0011B#\t\rq\u0003A\u0011A\u0005^\u0005=iU\r^1eCR\f7\t\\3b]V\u0004(B\u0001\u0006\f\u0003\u0015!W\r\u001c;b\u0015\taQ\"A\u0002tc2T!AD\b\u0002\u000bM\u0004\u0018M]6\u000b\u0005A\t\u0012AB1qC\u000eDWMC\u0001\u0013\u0003\ry'oZ\u0002\u0001'\r\u0001Qc\u0007\t\u0003-ei\u0011a\u0006\u0006\u00021\u0005)1oY1mC&\u0011!d\u0006\u0002\u0007\u0003:L(+\u001a4\u0011\u0005qyR\"A\u000f\u000b\u0005yI\u0011\u0001C7fi\u0016\u0014\u0018N\\4\n\u0005\u0001j\"\u0001\u0004#fYR\fGj\\4hS:<\u0017A\u0002\u0013j]&$H\u0005F\u0001$!\t1B%\u0003\u0002&/\t!QK\\5u\u0003])g.\u00192mK\u0016C\b/\u001b:fI2{wm\u00117fC:,\b\u000f\u0006\u0002)WA\u0011a#K\u0005\u0003U]\u0011qAQ8pY\u0016\fg\u000eC\u0003-\u0005\u0001\u0007Q&\u0001\u0005nKR\fG-\u0019;b!\tq\u0013'D\u00010\u0015\t\u0001\u0014\"A\u0004bGRLwN\\:\n\u0005Iz#\u0001C'fi\u0006$\u0017\r^1\u0002)\u0011,G\u000e^1SKR,g\u000e^5p]6KG\u000e\\5t)\t)\u0004\b\u0005\u0002\u0017m%\u0011qg\u0006\u0002\u0005\u0019>tw\rC\u0003-\u0007\u0001\u0007Q&\u0001\u0007e_2{wm\u00117fC:,\b\u000f\u0006\u0002$w!)A\b\u0002a\u0001{\u0005\t2O\\1qg\"|G\u000fV8DY\u0016\fg.\u001e9\u0011\u0005yzT\"A\u0005\n\u0005\u0001K!\u0001C*oCB\u001c\bn\u001c;\u0002%\rdW-\u00198Va\u0016C\b/\u001b:fI2{wm\u001d\u000b\u0003G\rCQ\u0001P\u0003A\u0002u\nA\u0003\\5ti\u0016C\b/\u001b:fI\u0012+G\u000e^1M_\u001e\u001cHC\u0001$[!\r9uJ\u0015\b\u0003\u00116s!!\u0013'\u000e\u0003)S!aS\n\u0002\rq\u0012xn\u001c;?\u0013\u0005A\u0012B\u0001(\u0018\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001U)\u0003\u0011%#XM]1u_JT!AT\f\u0011\u0005MCV\"\u0001+\u000b\u0005U3\u0016A\u00014t\u0015\t9v\"\u0001\u0004iC\u0012|w\u000e]\u0005\u00033R\u0013!BR5mKN#\u0018\r^;t\u0011\u0015Yf\u00011\u00016\u000391\u0017\u000e\\3DkR|eM\u001a+j[\u0016\f1\u0002\u001e:v]\u000e\fG/\u001a#bsR\u0011aL\u001a\t\u0003?\u0012l\u0011\u0001\u0019\u0006\u0003C\n\fA!\u001e;jY*\t1-\u0001\u0003kCZ\f\u0017BA3a\u0005!\u0019\u0015\r\\3oI\u0006\u0014\b\"B4\b\u0001\u0004)\u0014A\u0003;j[\u0016l\u0015\u000e\u001c7jgB\u0011a([\u0005\u0003U&\u0011\u0001\u0002R3mi\u0006dun\u001a")
public interface MetadataCleanup
extends DeltaLogging {
    public static /* synthetic */ boolean enableExpiredLogCleanup$(MetadataCleanup $this, Metadata metadata) {
        return $this.enableExpiredLogCleanup(metadata);
    }

    default public boolean enableExpiredLogCleanup(Metadata metadata) {
        return BoxesRunTime.unboxToBoolean((Object)DeltaConfigs$.MODULE$.ENABLE_EXPIRED_LOG_CLEANUP().fromMetaData(metadata));
    }

    public static /* synthetic */ long deltaRetentionMillis$(MetadataCleanup $this, Metadata metadata) {
        return $this.deltaRetentionMillis(metadata);
    }

    default public long deltaRetentionMillis(Metadata metadata) {
        CalendarInterval interval = DeltaConfigs$.MODULE$.LOG_RETENTION().fromMetaData(metadata);
        return DeltaConfigs$.MODULE$.getMilliSeconds(interval);
    }

    public static /* synthetic */ void doLogCleanup$(MetadataCleanup $this, Snapshot snapshotToCleanup) {
        $this.doLogCleanup(snapshotToCleanup);
    }

    default public void doLogCleanup(Snapshot snapshotToCleanup) {
        block0: {
            if (!this.enableExpiredLogCleanup(((SnapshotManagement)((Object)this)).snapshot().metadata())) break block0;
            this.cleanUpExpiredLogs(snapshotToCleanup);
        }
    }

    public static /* synthetic */ void cleanUpExpiredLogs$(MetadataCleanup $this, Snapshot snapshotToCleanup) {
        $this.cleanUpExpiredLogs(snapshotToCleanup);
    }

    default public void cleanUpExpiredLogs(Snapshot snapshotToCleanup) {
        this.recordDeltaOperation((DeltaLog)this, "delta.log.cleanup", this.recordDeltaOperation$default$3(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            long retentionMillis = this.deltaRetentionMillis(((SnapshotManagement)((Object)this)).snapshot().metadata());
            Date fileCutOffTime = this.truncateDay(((DeltaLog)this).clock().getTimeMillis() - retentionMillis).getTime();
            String formattedDate = fileCutOffTime.toGMTString();
            this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Starting the deletion of log files older than ").append(formattedDate).toString());
            FileSystem fs = ((DeltaLog)this).logPath().getFileSystem(((DeltaLog)this).newDeltaHadoopConf());
            IntRef numDeleted = IntRef.create((int)0);
            this.listExpiredDeltaLogs(fileCutOffTime.getTime()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getPath()).foreach((Function1 & Serializable & scala.Serializable)path -> {
                MetadataCleanup.$anonfun$cleanUpExpiredLogs$4(fs, numDeleted, path);
                return BoxedUnit.UNIT;
            });
            this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Deleted ").append(numDeleted$1.elem).append(" log files older than ").append(formattedDate).toString());
        });
    }

    private Iterator<FileStatus> listExpiredDeltaLogs(long fileCutOffTime) {
        Option<CheckpointMetaData> latestCheckpoint = ((Checkpoints)((Object)this)).readLastCheckpointFile();
        if (latestCheckpoint.isEmpty()) {
            return package$.MODULE$.Iterator().empty();
        }
        long threshold = ((CheckpointMetaData)latestCheckpoint.get()).version() - 1L;
        Iterator files = ((DeltaLog)this).store().listFrom(FileNames$.MODULE$.listingPrefix(((DeltaLog)this).logPath(), 0L), ((DeltaLog)this).newDeltaHadoopConf()).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)MetadataCleanup.$anonfun$listExpiredDeltaLogs$1(f)));
        return new DeltaHistoryManager.BufferingLogDeletionIterator((Iterator<FileStatus>)files, fileCutOffTime, threshold, (Function1<Path, Object>)(Function1 & Serializable & scala.Serializable)filePath -> BoxesRunTime.boxToLong((long)MetadataCleanup.getVersion$1(filePath)));
    }

    public static /* synthetic */ Calendar truncateDay$(MetadataCleanup $this, long timeMillis) {
        return $this.truncateDay(timeMillis);
    }

    default public Calendar truncateDay(long timeMillis) {
        Calendar date = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        date.setTimeInMillis(timeMillis);
        return DateUtils.truncate((Calendar)date, (int)5);
    }

    public static /* synthetic */ void $anonfun$cleanUpExpiredLogs$4(FileSystem fs$1, IntRef numDeleted$1, Path path) {
        block0: {
            if (!fs$1.delete(path, false)) break block0;
            ++numDeleted$1.elem;
        }
    }

    public static /* synthetic */ boolean $anonfun$listExpiredDeltaLogs$1(FileStatus f) {
        return FileNames$.MODULE$.isCheckpointFile(f) || FileNames$.MODULE$.isDeltaFile(f);
    }

    private static long getVersion$1(Path filePath) {
        return FileNames$.MODULE$.isCheckpointFile(filePath) ? FileNames$.MODULE$.checkpointVersion(filePath) : FileNames$.MODULE$.deltaVersion(filePath);
    }

    public static void $init$(MetadataCleanup $this) {
    }
}

