/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.storage;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.storage.HadoopFileSystemLogStore;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005\rd\u0001\u0002\t\u0012\u0001yA\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IA\u000b\u0005\t]\u0001\u0011\t\u0011)A\u0005_!)q\u0007\u0001C\u0001q!)A\b\u0001C\t{!)A\b\u0001C\tO\"91\u000e\u0001b\u0001\n\u0003a\u0007B\u0002;\u0001A\u0003%Q\u000eC\u0003v\u0001\u0011\u0005c\u000fC\u0005\u0002\u0018\u0001\t\n\u0011\"\u0001\u0002\u001a!1Q\u000f\u0001C!\u0003_Aq!!\u000f\u0001\t\u0013\tY\u0004C\u0004\u0002F\u0001!I!a\u0012\t\u000f\u00055\u0003\u0001\"\u0003\u0002P!9\u0011q\u000b\u0001\u0005B\u0005e\u0003bBA,\u0001\u0011\u0005\u0013Q\f\u0002\r\u0011\u001235\u000bT8h'R|'/\u001a\u0006\u0003%M\tqa\u001d;pe\u0006<WM\u0003\u0002\u0015+\u0005)A-\u001a7uC*\u0011acF\u0001\u0004gFd'B\u0001\r\u001a\u0003\u0015\u0019\b/\u0019:l\u0015\tQ2$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00029\u0005\u0019qN]4\u0004\u0001M\u0019\u0001aH\u0012\u0011\u0005\u0001\nS\"A\t\n\u0005\t\n\"\u0001\u0007%bI>|\u0007OR5mKNK8\u000f^3n\u0019><7\u000b^8sKB\u0011AeJ\u0007\u0002K)\u0011aeF\u0001\tS:$XM\u001d8bY&\u0011\u0001&\n\u0002\b\u0019><w-\u001b8h\u0003%\u0019\b/\u0019:l\u0007>tg\r\u0005\u0002,Y5\tq#\u0003\u0002./\tI1\u000b]1sW\u000e{gNZ\u0001\u0012I\u00164\u0017-\u001e7u\u0011\u0006$wn\u001c9D_:4\u0007C\u0001\u00196\u001b\u0005\t$B\u0001\u001a4\u0003\u0011\u0019wN\u001c4\u000b\u0005QJ\u0012A\u00025bI>|\u0007/\u0003\u00027c\ti1i\u001c8gS\u001e,(/\u0019;j_:\fa\u0001P5oSRtDcA\u001d;wA\u0011\u0001\u0005\u0001\u0005\u0006S\r\u0001\rA\u000b\u0005\u0006]\r\u0001\raL\u0001\u000fO\u0016$h)\u001b7f\u0007>tG/\u001a=u)\tqD\t\u0005\u0002@\u00056\t\u0001I\u0003\u0002Bg\u0005\u0011am]\u0005\u0003\u0007\u0002\u00131BR5mK\u000e{g\u000e^3yi\")Q\t\u0002a\u0001\r\u0006!\u0001/\u0019;i!\tyt)\u0003\u0002I\u0001\n!\u0001+\u0019;iQ\u0011!!\n\u0015*\u0011\u0005-sU\"\u0001'\u000b\u00035\u000bQa]2bY\u0006L!a\u0014'\u0003\u0015\u0011,\u0007O]3dCR,G-I\u0001R\u0003\r\u001b\u0017\r\u001c7!i\",\u0007%\\3uQ>$\u0007\u0005\u001e5bi\u0002\n7o[:!M>\u0014\b%\u0019\u0011IC\u0012|w\u000e\u001d\u0011D_:4\u0017nZ;sCRLwN\u001c\u0011pE*,7\r\u001e\u0011j]N$X-\u001932\u000b\r\u001afLY0\u0011\u0005Q[fBA+Z!\t1F*D\u0001X\u0015\tAV$\u0001\u0004=e>|GOP\u0005\u000352\u000ba\u0001\u0015:fI\u00164\u0017B\u0001/^\u0005\u0019\u0019FO]5oO*\u0011!\fT\u0005\u0003?\u0002\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u0012$BA1M\u0003)!W\r\u001d:fG\u0006$X\rZ\u0019\u0006G\r$W-\u0019\b\u0003\u0017\u0012L!!\u0019'2\t\tZEJ\u001a\u0002\u0006g\u000e\fG.\u0019\u000b\u0004}!L\u0007\"B#\u0006\u0001\u00041\u0005\"\u00026\u0006\u0001\u0004y\u0013A\u00035bI>|\u0007oQ8oM\u0006!cn\\!cgR\u0014\u0018m\u0019;GS2,7+_:uK6,\u0005pY3qi&|g.T3tg\u0006<W-F\u0001n!\tq7/D\u0001p\u0015\t\u0001\u0018/\u0001\u0003mC:<'\"\u0001:\u0002\t)\fg/Y\u0005\u00039>\fQE\\8BEN$(/Y2u\r&dWmU=ti\u0016lW\t_2faRLwN\\'fgN\fw-\u001a\u0011\u0002\u000b]\u0014\u0018\u000e^3\u0015\u000b]T80!\u0004\u0011\u0005-C\u0018BA=M\u0005\u0011)f.\u001b;\t\u000b\u0015C\u0001\u0019\u0001$\t\u000bqD\u0001\u0019A?\u0002\u000f\u0005\u001cG/[8ogB!a0a\u0002T\u001d\ry\u00181\u0001\b\u0004-\u0006\u0005\u0011\"A'\n\u0007\u0005\u0015A*A\u0004qC\u000e\\\u0017mZ3\n\t\u0005%\u00111\u0002\u0002\t\u0013R,'/\u0019;pe*\u0019\u0011Q\u0001'\t\u0013\u0005=\u0001\u0002%AA\u0002\u0005E\u0011!C8wKJ<(/\u001b;f!\rY\u00151C\u0005\u0004\u0003+a%a\u0002\"p_2,\u0017M\\\u0001\u0010oJLG/\u001a\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u00111\u0004\u0016\u0005\u0003#\tib\u000b\u0002\u0002 A!\u0011\u0011EA\u0016\u001b\t\t\u0019C\u0003\u0003\u0002&\u0005\u001d\u0012!C;oG\",7m[3e\u0015\r\tI\u0003T\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u0017\u0003G\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f)%9\u0018\u0011GA\u001a\u0003k\t9\u0004C\u0003F\u0015\u0001\u0007a\tC\u0003}\u0015\u0001\u0007Q\u0010C\u0004\u0002\u0010)\u0001\r!!\u0005\t\u000b)T\u0001\u0019A\u0018\u0002\u001b]\u0014\u0018\u000e^3J]R,'O\\1m)%9\u0018QHA \u0003\u0003\n\u0019\u0005C\u0003F\u0017\u0001\u0007a\tC\u0003}\u0017\u0001\u0007Q\u0010C\u0004\u0002\u0010-\u0001\r!!\u0005\t\u000b)\\\u0001\u0019A\u0018\u0002!5\u001c\u0018P\\2JMN+\b\u000f]8si\u0016$G#B<\u0002J\u0005-\u0003\"B#\r\u0001\u00041\u0005\"\u00026\r\u0001\u0004y\u0013\u0001\u0005;ssJ+Wn\u001c<f\u0007J\u001cg)\u001b7f)\u00159\u0018\u0011KA+\u0011\u0019\t\u0019&\u0004a\u0001}\u0005\u0011am\u0019\u0005\u0006\u000b6\u0001\rAR\u0001\u0016SN\u0004\u0016M\u001d;jC2<&/\u001b;f-&\u001c\u0018N\u00197f)\u0011\t\t\"a\u0017\t\u000b\u0015s\u0001\u0019\u0001$\u0015\r\u0005E\u0011qLA1\u0011\u0015)u\u00021\u0001G\u0011\u0015Qw\u00021\u00010\u0001")
public class HDFSLogStore
extends HadoopFileSystemLogStore
implements Logging {
    private final SparkConf sparkConf;
    private final String noAbstractFileSystemExceptionMessage;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public FileContext getFileContext(Path path) {
        return FileContext.getFileContext((URI)path.toUri(), (Configuration)this.getHadoopConfiguration());
    }

    public FileContext getFileContext(Path path, Configuration hadoopConf) {
        return FileContext.getFileContext((URI)path.toUri(), (Configuration)hadoopConf);
    }

    public String noAbstractFileSystemExceptionMessage() {
        return this.noAbstractFileSystemExceptionMessage;
    }

    @Override
    public void write(Path path, Iterator<String> actions, boolean overwrite) {
        this.write(path, actions, overwrite, this.getHadoopConfiguration());
    }

    @Override
    public void write(Path path, Iterator<String> actions, boolean overwrite, Configuration hadoopConf) {
        boolean isLocalFs = path.getFileSystem(hadoopConf) instanceof RawLocalFileSystem;
        if (isLocalFs) {
            HDFSLogStore hDFSLogStore = this;
            synchronized (hDFSLogStore) {
                this.writeInternal(path, actions, overwrite, hadoopConf);
            }
        } else {
            this.writeInternal(path, actions, overwrite, hadoopConf);
        }
    }

    @Override
    public boolean write$default$3() {
        return false;
    }

    private void writeInternal(Path path, Iterator<String> actions, boolean overwrite, Configuration hadoopConf) {
        FileContext fileContext;
        try {
            fileContext = this.getFileContext(path, hadoopConf);
        }
        catch (Throwable throwable) {
            IOException iOException;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof IOException && (iOException = (IOException)throwable2).getMessage().contains(this.noAbstractFileSystemExceptionMessage())) {
                Throwable newException = DeltaErrors$.MODULE$.incorrectLogStoreImplementationException(this.sparkConf, iOException);
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> newException.getMessage(), newException.getCause());
                throw newException;
            }
            throw throwable;
        }
        FileContext fc = fileContext;
        if (!overwrite && fc.util().exists(path)) {
            throw DeltaErrors$.MODULE$.fileAlreadyExists(path.toString());
        }
        Path tempPath = this.createTempPath(path);
        boolean streamClosed = false;
        boolean renameDone = false;
        FSDataOutputStream stream = fc.create(tempPath, EnumSet.of(CreateFlag.CREATE), new Options.CreateOpts[]{Options.CreateOpts.checksumParam((Options.ChecksumOpt)Options.ChecksumOpt.createDisabled())});
        try {
            actions.map((Function1 & Serializable & scala.Serializable)x$1 -> new StringBuilder(1).append((String)x$1).append("\n").toString()).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getBytes(StandardCharsets.UTF_8)).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                stream.write(x$1);
                return BoxedUnit.UNIT;
            });
            stream.close();
            streamClosed = true;
            try {
                Options.Rename renameOpt = overwrite ? Options.Rename.OVERWRITE : Options.Rename.NONE;
                fc.rename(tempPath, path, new Options.Rename[]{renameOpt});
                renameDone = true;
                this.tryRemoveCrcFile(fc, tempPath);
            }
            catch (FileAlreadyExistsException e) {
                throw DeltaErrors$.MODULE$.fileAlreadyExists(path.toString());
            }
        }
        finally {
            if (!streamClosed) {
                stream.close();
            }
            if (!renameDone) {
                fc.delete(tempPath, false);
            }
        }
        this.msyncIfSupported(path, hadoopConf);
    }

    private void msyncIfSupported(Path path, Configuration hadoopConf) {
        try {
            FileSystem fs = path.getFileSystem(hadoopConf);
            Method msync = fs.getClass().getMethod("msync", new Class[0]);
            msync.invoke((Object)fs, new Object[0]);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
    }

    private void tryRemoveCrcFile(FileContext fc, Path path) {
        try {
            Path checksumFile = new Path(path.getParent(), new StringBuilder(5).append(".").append(path.getName()).append(".crc").toString());
            if (fc.util().exists(checksumFile)) {
                fc.delete(checksumFile, true);
            }
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
    }

    @Override
    public boolean isPartialWriteVisible(Path path) {
        return true;
    }

    @Override
    public boolean isPartialWriteVisible(Path path, Configuration hadoopConf) {
        return true;
    }

    public HDFSLogStore(SparkConf sparkConf, Configuration defaultHadoopConf) {
        this.sparkConf = sparkConf;
        super(sparkConf, defaultHadoopConf);
        Logging.$init$((Logging)this);
        this.noAbstractFileSystemExceptionMessage = "No AbstractFileSystem";
    }
}

