/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller.open;

import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Locale;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.metadata.table.InternalTablePartitionDetail;
import org.apache.kylin.rest.controller.InternalTableController;
import org.apache.kylin.rest.controller.NBasicController;
import org.apache.kylin.rest.request.InternalTableBuildRequest;
import org.apache.kylin.rest.request.InternalTableRequest;
import org.apache.kylin.rest.response.DataResult;
import org.apache.kylin.rest.response.EnvelopeResponse;
import org.apache.kylin.rest.response.InternalTableDescResponse;
import org.apache.kylin.rest.response.InternalTableLoadingJobResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/internal_tables"}, produces={"application/vnd.apache.kylin-v4-public+json"})
public class OpenInternalTableController
extends NBasicController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OpenInternalTableController.class);
    @Autowired
    private InternalTableController internalTableController;

    @ApiOperation(value="create_internal_table", tags={"AI"})
    @PostMapping(value={"/{database:.+}/{table:.+}"})
    @ResponseBody
    public EnvelopeResponse<String> createInternalTable(@RequestParam(value="project") String project, @PathVariable(value="database") String database, @PathVariable(value="table") String table, @RequestBody InternalTableRequest request) throws Exception {
        String projectName = this.checkProjectName(project);
        if (StringUtils.isBlank((CharSequence)table) || StringUtils.isBlank((CharSequence)database)) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.EMPTY_PARAMETER, MsgPicker.getMsg().getTableOrDatabaseNameCannotEmpty());
        }
        return this.internalTableController.createInternalTable(projectName, database, table, request);
    }

    @ApiOperation(value="get_tables", tags={"AI"})
    @GetMapping(value={""})
    @ResponseBody
    public EnvelopeResponse<DataResult<List<InternalTableDescResponse>>> getTableList(@RequestParam(value="project") String project, @RequestParam(value="need_details", required=false, defaultValue="false") boolean needDetails, @RequestParam(value="is_fuzzy", required=false, defaultValue="false") boolean isFuzzy, @RequestParam(value="database", required=false) String database, @RequestParam(value="table", required=false) String table, @RequestParam(value="page_offset", required=false, defaultValue="0") Integer offset, @RequestParam(value="page_size", required=false, defaultValue="10") Integer limit) {
        String projectName = this.checkProjectName(project);
        if (null != offset) {
            this.checkNonNegativeIntegerArg("page_offset", offset);
        }
        if (null != limit) {
            this.checkNonNegativeIntegerArg("page_size", limit);
        }
        if (StringUtils.isBlank((CharSequence)table) && StringUtils.isBlank((CharSequence)database) && isFuzzy) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.EMPTY_PARAMETER, MsgPicker.getMsg().getTableOrDatabaseNameCannotEmpty());
        }
        return this.internalTableController.getTableList(projectName, needDetails, isFuzzy, database, table, offset, limit);
    }

    @ApiOperation(value="get_table_detail", tags={"AI"})
    @GetMapping(value={"/{database:.+}/{table:.+}"})
    @ResponseBody
    public EnvelopeResponse<DataResult<List<InternalTablePartitionDetail>>> getTableDetail(@RequestParam(value="project") String project, @PathVariable(value="database") String database, @PathVariable(value="table") String table, @RequestParam(value="page_offset", required=false, defaultValue="0") Integer offset, @RequestParam(value="page_size", required=false, defaultValue="10") Integer limit) {
        String projectName = this.checkProjectName(project);
        if (StringUtils.isBlank((CharSequence)table) || StringUtils.isBlank((CharSequence)database)) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.EMPTY_PARAMETER, MsgPicker.getMsg().getTableOrDatabaseNameCannotEmpty());
        }
        if (null != offset) {
            this.checkNonNegativeIntegerArg("page_offset", offset);
        }
        if (null != limit) {
            this.checkNonNegativeIntegerArg("page_offset", limit);
        }
        return this.internalTableController.getTableDetail(projectName, database, table, offset, limit);
    }

    @ApiOperation(value="update_table", tags={"AI"})
    @PutMapping(value={"/{database:.+}/{table:.+}"})
    @ResponseBody
    public EnvelopeResponse<String> updateTable(@RequestParam(value="project") String project, @PathVariable(value="database") String database, @PathVariable(value="table") String table, @RequestBody InternalTableRequest request) throws Exception {
        String projectName = this.checkProjectName(project);
        if (StringUtils.isBlank((CharSequence)table) || StringUtils.isBlank((CharSequence)database)) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.EMPTY_PARAMETER, MsgPicker.getMsg().getTableOrDatabaseNameCannotEmpty());
        }
        return this.internalTableController.updateTable(projectName, database, table, request);
    }

    @ApiOperation(value="load_into_internal", tags={"AI"})
    @PostMapping(value={"/{project:.+}/{database:.+}/{table:.+}"})
    @ResponseBody
    public EnvelopeResponse<InternalTableLoadingJobResponse> loadIntoInternalTable(@PathVariable(value="project") String project, @PathVariable(value="database") String database, @PathVariable(value="table") String table, @RequestBody InternalTableBuildRequest request) throws Exception {
        String projectName = this.checkProjectName(project);
        if (StringUtils.isBlank((CharSequence)table) || StringUtils.isBlank((CharSequence)database)) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.EMPTY_PARAMETER, MsgPicker.getMsg().getTableOrDatabaseNameCannotEmpty());
        }
        return this.internalTableController.loadIntoInternalTable(projectName, database, table, request);
    }

    @ApiOperation(value="truncate_internal_table", tags={"AI"})
    @DeleteMapping(value={"/truncate_internal_table"})
    @ResponseBody
    public EnvelopeResponse<String> truncateInternalTable(@RequestParam(value="project") String project, @RequestParam(value="database") String database, @RequestParam(value="table") String table) throws Exception {
        String projectName = this.checkProjectName(project);
        if (StringUtils.isBlank((CharSequence)table) || StringUtils.isBlank((CharSequence)database)) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_TABLE_NAME, MsgPicker.getMsg().getTableOrDatabaseNameCannotEmpty());
        }
        return this.internalTableController.truncateInternalTable(projectName, database, table);
    }

    @ApiOperation(value="drop_table_partitions", tags={"AI"})
    @DeleteMapping(value={"/partitions"})
    @ResponseBody
    public EnvelopeResponse<String> dropPartitions(@RequestParam(value="project") String project, @RequestParam(value="database") String database, @RequestParam(value="table") String table, @RequestParam(value="partitions") String[] partitionValues) throws Exception {
        String projectName = this.checkProjectName(project);
        if (StringUtils.isBlank((CharSequence)table) || StringUtils.isBlank((CharSequence)database)) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_TABLE_NAME, MsgPicker.getMsg().getTableOrDatabaseNameCannotEmpty());
        }
        if (null == partitionValues || partitionValues.length == 0) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.EMPTY_PARAMETER, String.format(Locale.ROOT, MsgPicker.getMsg().getParameterEmpty(), "partitions"));
        }
        return this.internalTableController.dropPartitions(projectName, database, table, partitionValues);
    }

    @ApiOperation(value="drop_internal_table", tags={"AI"})
    @DeleteMapping(value={"/{database:.+}/{table:.+}"})
    @ResponseBody
    public EnvelopeResponse<String> dropInternalTable(@RequestParam(value="project") String project, @PathVariable(value="database") String database, @PathVariable(value="table") String table) throws Exception {
        String projectName = this.checkProjectName(project);
        if (StringUtils.isBlank((CharSequence)table) || StringUtils.isBlank((CharSequence)database)) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_TABLE_NAME, MsgPicker.getMsg().getTableOrDatabaseNameCannotEmpty());
        }
        return this.internalTableController.dropInternalTable(projectName, database, table);
    }
}

