/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.dao;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import lombok.Generated;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.job.dao.JobStatisticsBasic;

public class JobStatistics
extends JobStatisticsBasic {
    @JsonProperty(value="date")
    private long date;
    @JsonProperty(value="model_stats")
    private Map<String, JobStatisticsBasic> jobStatisticsByModels = Maps.newHashMap();

    public String resourceName() {
        return JobStatistics.generateResourceName(this.getProject(), this.date);
    }

    public static String generateResourceName(String project, long date) {
        return project + "." + date;
    }

    public MetadataType resourceType() {
        return MetadataType.JOB_STATS;
    }

    public JobStatistics(long date, String model, long duration, long byteSize) {
        this.date = date;
        this.setCount(1);
        this.setTotalDuration(duration);
        this.setTotalByteSize(byteSize);
        this.jobStatisticsByModels.put(model, new JobStatisticsBasic(duration, byteSize));
    }

    public JobStatistics(int count, long totalDuration, long totalByteSize) {
        this.setCount(count);
        this.setTotalDuration(totalDuration);
        this.setTotalByteSize(totalByteSize);
    }

    public JobStatistics(long date, long totalDuration, long totalByteSize) {
        this.date = date;
        this.setCount(1);
        this.setTotalDuration(totalDuration);
        this.setTotalByteSize(totalByteSize);
    }

    public void update(String model, long duration, long byteSize, int deltaCount) {
        super.update(duration, byteSize, deltaCount);
        JobStatisticsBasic jobStatisticsByModel = this.jobStatisticsByModels.get(model);
        if (jobStatisticsByModel == null) {
            jobStatisticsByModel = new JobStatisticsBasic(duration, byteSize);
        } else {
            jobStatisticsByModel.update(duration, byteSize, deltaCount);
        }
        this.jobStatisticsByModels.put(model, jobStatisticsByModel);
    }

    @Generated
    public long getDate() {
        return this.date;
    }

    @Generated
    public Map<String, JobStatisticsBasic> getJobStatisticsByModels() {
        return this.jobStatisticsByModels;
    }

    @Generated
    public void setDate(long date) {
        this.date = date;
    }

    @Generated
    public void setJobStatisticsByModels(Map<String, JobStatisticsBasic> jobStatisticsByModels) {
        this.jobStatisticsByModels = jobStatisticsByModels;
    }

    @Generated
    public JobStatistics() {
    }
}

