/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.factory;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.kylin.common.util.RandomUtil;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.JobTypeEnum;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.job.JobBucket;
import org.apache.kylin.rest.util.AclPermissionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JobFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JobFactory.class);
    static final Map<String, JobFactory> implementations = Maps.newHashMap();

    public static void register(String jobName, JobFactory impl) {
        implementations.put(jobName, impl);
    }

    public static AbstractExecutable createJob(String factory, JobBuildParams jobBuildParams) {
        if (!implementations.containsKey(factory)) {
            log.error("JobFactory doesn't contain this factory:{}", (Object)factory);
            return null;
        }
        return implementations.get(factory).create(jobBuildParams);
    }

    public static AbstractExecutable createJobWithDefaultParams(String factory, JobTypeEnum jobType) {
        return JobFactory.createJob(factory, new JobBuildParams(Collections.emptySet(), Collections.emptySet(), AclPermissionUtil.getCurrentUsername(), jobType, RandomUtil.randomUUIDStr(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet()));
    }

    protected abstract AbstractExecutable create(JobBuildParams var1);

    public static class JobBuildParams {
        private final Set<NDataSegment> segments;
        private final Set<LayoutEntity> layouts;
        private final String submitter;
        private final JobTypeEnum jobType;
        private final String jobId;
        private final Set<LayoutEntity> toBeDeletedLayouts;
        private final Set<String> ignoredSnapshotTables;
        private final Set<Long> partitions;
        private final Set<JobBucket> buckets;
        private Map<String, String> extParams;

        @Generated
        public JobBuildParams(Set<NDataSegment> segments, Set<LayoutEntity> layouts, String submitter, JobTypeEnum jobType, String jobId, Set<LayoutEntity> toBeDeletedLayouts, Set<String> ignoredSnapshotTables, Set<Long> partitions, Set<JobBucket> buckets, Map<String, String> extParams) {
            this.segments = segments;
            this.layouts = layouts;
            this.submitter = submitter;
            this.jobType = jobType;
            this.jobId = jobId;
            this.toBeDeletedLayouts = toBeDeletedLayouts;
            this.ignoredSnapshotTables = ignoredSnapshotTables;
            this.partitions = partitions;
            this.buckets = buckets;
            this.extParams = extParams;
        }

        @Generated
        public JobBuildParams(Set<NDataSegment> segments, Set<LayoutEntity> layouts, String submitter, JobTypeEnum jobType, String jobId, Set<LayoutEntity> toBeDeletedLayouts, Set<String> ignoredSnapshotTables, Set<Long> partitions, Set<JobBucket> buckets) {
            this.segments = segments;
            this.layouts = layouts;
            this.submitter = submitter;
            this.jobType = jobType;
            this.jobId = jobId;
            this.toBeDeletedLayouts = toBeDeletedLayouts;
            this.ignoredSnapshotTables = ignoredSnapshotTables;
            this.partitions = partitions;
            this.buckets = buckets;
        }

        @Generated
        public Set<NDataSegment> getSegments() {
            return this.segments;
        }

        @Generated
        public Set<LayoutEntity> getLayouts() {
            return this.layouts;
        }

        @Generated
        public String getSubmitter() {
            return this.submitter;
        }

        @Generated
        public JobTypeEnum getJobType() {
            return this.jobType;
        }

        @Generated
        public String getJobId() {
            return this.jobId;
        }

        @Generated
        public Set<LayoutEntity> getToBeDeletedLayouts() {
            return this.toBeDeletedLayouts;
        }

        @Generated
        public Set<String> getIgnoredSnapshotTables() {
            return this.ignoredSnapshotTables;
        }

        @Generated
        public Set<Long> getPartitions() {
            return this.partitions;
        }

        @Generated
        public Set<JobBucket> getBuckets() {
            return this.buckets;
        }

        @Generated
        public Map<String, String> getExtParams() {
            return this.extParams;
        }
    }
}

