/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.UUID;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.KylinConfig;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.KylinSession;
import org.apache.spark.sql.SparderEnv$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSessionExtensions;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.springframework.expression.ParserContext;
import org.springframework.expression.common.TemplateParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class KylinSession$
implements Logging,
scala.Serializable {
    public static KylinSession$ MODULE$;
    private final String NORMAL_FAIR_SCHEDULER_FILE_NAME;
    private final String QUERY_LIMIT_FAIR_SCHEDULER_FILE_NAME;
    private final String SPARK_MASTER;
    private final String SPARK_PLUGINS_KEY;
    private final String SPARK_YARN_DIST_FILE;
    private final String SPARK_EXECUTOR_JAR_PATH;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new KylinSession$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String NORMAL_FAIR_SCHEDULER_FILE_NAME() {
        return this.NORMAL_FAIR_SCHEDULER_FILE_NAME;
    }

    public String QUERY_LIMIT_FAIR_SCHEDULER_FILE_NAME() {
        return this.QUERY_LIMIT_FAIR_SCHEDULER_FILE_NAME;
    }

    public String SPARK_MASTER() {
        return this.SPARK_MASTER;
    }

    public String SPARK_PLUGINS_KEY() {
        return this.SPARK_PLUGINS_KEY;
    }

    public String SPARK_YARN_DIST_FILE() {
        return this.SPARK_YARN_DIST_FILE;
    }

    public String SPARK_EXECUTOR_JAR_PATH() {
        return this.SPARK_EXECUTOR_JAR_PATH;
    }

    public KylinSession.KylinBuilder KylinBuilder(SparkSession.Builder builder) {
        return new KylinSession.KylinBuilder(builder);
    }

    public SparkSessionExtensions org$apache$spark$sql$KylinSession$$applyExtensions(Seq<String> extensionConfClassNames, SparkSessionExtensions extensions) {
        extensionConfClassNames.foreach((Function1 & Serializable & scala.Serializable)extensionConfClassName -> {
            KylinSession$.$anonfun$applyExtensions$1(extensions, extensionConfClassName);
            return BoxedUnit.UNIT;
        });
        return extensions;
    }

    public String generateExecutorPodNamePrefixForK8s(String appName) {
        int appNameLength = appName.length();
        return appNameLength > 0 && appNameLength <= 47 ? appName : new StringBuilder(8).append("sparder-").append(UUID.randomUUID().toString().replaceAll("-", "")).toString();
    }

    public void applyFairSchedulerConfig(KapConfig kapConfig, String confFileDirPath, SparkConf sparkConf) {
        block2: {
            String fairScheduler;
            block1: {
                boolean isQueryLimitValid;
                fairScheduler = null;
                boolean bl = isQueryLimitValid = kapConfig.isQueryLimitEnabled() && SparderEnv$.MODULE$.isSparkExecutorResourceLimited(sparkConf);
                if (!isQueryLimitValid) break block1;
                int executorNum = new StringOps(Predef$.MODULE$.augmentString(sparkConf.get("spark.executor.instances"))).toInt();
                boolean dynamicAllocationEnabled = new StringOps(Predef$.MODULE$.augmentString(sparkConf.get("spark.dynamicAllocation.enabled", "false"))).toBoolean();
                if (dynamicAllocationEnabled) {
                    executorNum = new StringOps(Predef$.MODULE$.augmentString(sparkConf.get("spark.dynamicAllocation.maxExecutors"))).toInt();
                }
                int cores = new StringOps(Predef$.MODULE$.augmentString(sparkConf.get("spark.executor.cores"))).toInt();
                fairScheduler = new StringBuilder(0).append(confFileDirPath).append(this.QUERY_LIMIT_FAIR_SCHEDULER_FILE_NAME()).toString();
                this.prepareQueryLimitSchedulerConfig(executorNum * cores, fairScheduler);
                fairScheduler = new StringBuilder(7).append("file://").append(fairScheduler).toString();
                sparkConf.set("spark.scheduler.allocation.file", fairScheduler);
                break block2;
            }
            if (!new File(new StringBuilder(0).append(confFileDirPath).append(this.NORMAL_FAIR_SCHEDULER_FILE_NAME()).toString()).exists()) break block2;
            fairScheduler = new StringBuilder(7).append("file://").append(confFileDirPath).append(this.NORMAL_FAIR_SCHEDULER_FILE_NAME()).toString();
            sparkConf.set("spark.scheduler.allocation.file", fairScheduler);
        }
    }

    public void prepareQueryLimitSchedulerConfig(int sparkSlots, String fairSchedulerConfPath) {
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("heavyTaskPoolWeight", BoxesRunTime.boxToInteger((int)sparkSlots));
        params.put("lightweightTaskPoolWeight", BoxesRunTime.boxToInteger((int)((int)Math.pow(sparkSlots, 2.0) + 1)));
        params.put("lightweightTaskPoolMinShare", BoxesRunTime.boxToInteger((int)sparkSlots));
        params.put("vipTaskPoolWeight", BoxesRunTime.boxToInteger((int)((int)Math.pow(sparkSlots, 2.0) + 2)));
        params.put("vipTaskPoolMinShare", BoxesRunTime.boxToInteger((int)((int)Math.pow(sparkSlots, 2.0) + 1)));
        File confTemplateFile = new File(new StringBuilder(9).append(fairSchedulerConfPath).append(".template").toString());
        BufferedReader fileReader = new BufferedReader(new InputStreamReader(Files.newInputStream(confTemplateFile.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));
        File confFile = new File(fairSchedulerConfPath);
        BufferedWriter fileWriter = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(confFile.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));
        String templateLine = null;
        String processedLine = null;
        SpelExpressionParser parser = new SpelExpressionParser();
        TemplateParserContext parserCtx = new TemplateParserContext();
        while ((templateLine = fileReader.readLine()) != null) {
            processedLine = new StringBuilder(2).append((String)parser.parseExpression(templateLine, (ParserContext)parserCtx).getValue(params, String.class)).append("\r\n").toString();
            fileWriter.write(processedLine);
        }
        fileReader.close();
        fileWriter.close();
    }

    public boolean checkExternalClass(String className) {
        boolean bl;
        try {
            boolean bl2;
            String string = className;
            if ("".equals(string)) {
                bl2 = false;
            } else {
                Class.forName(className, true, Utils$.MODULE$.getContextOrSparkClassLoader());
                bl2 = true;
            }
            bl = bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            boolean bl3 = throwable2 instanceof ClassNotFoundException ? true : throwable2 instanceof NoClassDefFoundError;
            if (!bl3) {
                throw throwable;
            }
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Can't load Kylin external ").append(className).append(", use Spark default instead").toString());
            boolean bl4 = false;
            bl = bl4;
        }
        return bl;
    }

    public void initLogicalViewConfig(SparkConf sparkConf) {
        block0: {
            if (!KylinConfig.getInstanceFromEnv().isDDLLogicalViewEnabled()) break block0;
            sparkConf.set("spark.sql.globalTempDatabase", KylinConfig.getInstanceFromEnv().getDDLLogicalViewDB());
        }
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ void $anonfun$applyExtensions$1(SparkSessionExtensions extensions$1, String extensionConfClassName) {
        try {
            Class<?> extensionConfClass = Class.forName(extensionConfClassName, true, Utils$.MODULE$.getContextOrSparkClassLoader());
            Function1 extensionConf = (Function1)extensionConfClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            extensionConf.apply((Object)extensions$1);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            boolean bl = throwable2 instanceof ClassCastException ? true : (throwable2 instanceof ClassNotFoundException ? true : throwable2 instanceof NoClassDefFoundError);
            if (bl) {
                MODULE$.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Cannot use ").append(extensionConfClassName).append(" to configure session extensions.").toString(), throwable2);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
    }

    private KylinSession$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.NORMAL_FAIR_SCHEDULER_FILE_NAME = "/fairscheduler.xml";
        this.QUERY_LIMIT_FAIR_SCHEDULER_FILE_NAME = "/query-limit-fair-scheduler.xml";
        this.SPARK_MASTER = "spark.master";
        this.SPARK_PLUGINS_KEY = "spark.plugins";
        this.SPARK_YARN_DIST_FILE = "spark.yarn.dist.files";
        this.SPARK_EXECUTOR_JAR_PATH = "spark.gluten.sql.executor.jar.path";
    }
}

