/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.response;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.table.InternalTableDesc;

public class InternalTableDescResponse {
    @JsonProperty(value="uuid")
    private String uuid;
    @JsonProperty(value="table_name")
    private String tableName;
    @JsonProperty(value="database_name")
    private String databaseName;
    @JsonProperty(value="time_partition_col")
    private String timePartitionCol;
    @JsonProperty(value="date_partition_format")
    private String datePartitionFormat;
    @JsonProperty(value="hit_count")
    private long hitCount;
    @JsonProperty(value="row_count")
    private long rowCount;
    @JsonProperty(value="storage_size")
    private long storageSize;
    @JsonProperty(value="update_time")
    private long updateTime;
    @JsonProperty(value="tbl_properties")
    private Map<String, String> tblProperties;
    @JsonProperty(value="columns_info")
    private List<ColumnDesc> columns;

    public static InternalTableDescResponse convertToResponse(InternalTableDesc internalTableDesc, boolean needDetails) {
        InternalTableDescResponse response = new InternalTableDescResponse();
        response.setTableName(internalTableDesc.getName());
        response.setUuid(internalTableDesc.getUuid());
        response.setDatabaseName(internalTableDesc.getDatabase());
        response.setRowCount(internalTableDesc.getRowCount());
        response.setStorageSize(internalTableDesc.getStorageSize());
        response.setHitCount(internalTableDesc.getHitCount());
        Object[] partitionColumns = internalTableDesc.getPartitionColumns();
        Object partitionColumn = ArrayUtils.isNotEmpty((Object[])partitionColumns) ? partitionColumns[0] : null;
        response.setTimePartitionCol((String)partitionColumn);
        response.setUpdateTime(internalTableDesc.getLastModified());
        response.setDatePartitionFormat(internalTableDesc.getDatePartitionFormat());
        response.setTblProperties(internalTableDesc.getTblProperties());
        if (needDetails) {
            response.setColumns(Arrays.asList(internalTableDesc.getColumns()));
        }
        return response;
    }

    @Generated
    public InternalTableDescResponse() {
    }

    @Generated
    public String getUuid() {
        return this.uuid;
    }

    @Generated
    public String getTableName() {
        return this.tableName;
    }

    @Generated
    public String getDatabaseName() {
        return this.databaseName;
    }

    @Generated
    public String getTimePartitionCol() {
        return this.timePartitionCol;
    }

    @Generated
    public String getDatePartitionFormat() {
        return this.datePartitionFormat;
    }

    @Generated
    public long getHitCount() {
        return this.hitCount;
    }

    @Generated
    public long getRowCount() {
        return this.rowCount;
    }

    @Generated
    public long getStorageSize() {
        return this.storageSize;
    }

    @Generated
    public long getUpdateTime() {
        return this.updateTime;
    }

    @Generated
    public Map<String, String> getTblProperties() {
        return this.tblProperties;
    }

    @Generated
    public List<ColumnDesc> getColumns() {
        return this.columns;
    }

    @Generated
    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    @Generated
    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @Generated
    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    @Generated
    public void setTimePartitionCol(String timePartitionCol) {
        this.timePartitionCol = timePartitionCol;
    }

    @Generated
    public void setDatePartitionFormat(String datePartitionFormat) {
        this.datePartitionFormat = datePartitionFormat;
    }

    @Generated
    public void setHitCount(long hitCount) {
        this.hitCount = hitCount;
    }

    @Generated
    public void setRowCount(long rowCount) {
        this.rowCount = rowCount;
    }

    @Generated
    public void setStorageSize(long storageSize) {
        this.storageSize = storageSize;
    }

    @Generated
    public void setUpdateTime(long updateTime) {
        this.updateTime = updateTime;
    }

    @Generated
    public void setTblProperties(Map<String, String> tblProperties) {
        this.tblProperties = tblProperties;
    }

    @Generated
    public void setColumns(List<ColumnDesc> columns) {
        this.columns = columns;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InternalTableDescResponse)) {
            return false;
        }
        InternalTableDescResponse other = (InternalTableDescResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$uuid = this.getUuid();
        String other$uuid = other.getUuid();
        if (this$uuid == null ? other$uuid != null : !this$uuid.equals(other$uuid)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$databaseName = this.getDatabaseName();
        String other$databaseName = other.getDatabaseName();
        if (this$databaseName == null ? other$databaseName != null : !this$databaseName.equals(other$databaseName)) {
            return false;
        }
        String this$timePartitionCol = this.getTimePartitionCol();
        String other$timePartitionCol = other.getTimePartitionCol();
        if (this$timePartitionCol == null ? other$timePartitionCol != null : !this$timePartitionCol.equals(other$timePartitionCol)) {
            return false;
        }
        String this$datePartitionFormat = this.getDatePartitionFormat();
        String other$datePartitionFormat = other.getDatePartitionFormat();
        if (this$datePartitionFormat == null ? other$datePartitionFormat != null : !this$datePartitionFormat.equals(other$datePartitionFormat)) {
            return false;
        }
        if (this.getHitCount() != other.getHitCount()) {
            return false;
        }
        if (this.getRowCount() != other.getRowCount()) {
            return false;
        }
        if (this.getStorageSize() != other.getStorageSize()) {
            return false;
        }
        if (this.getUpdateTime() != other.getUpdateTime()) {
            return false;
        }
        Map<String, String> this$tblProperties = this.getTblProperties();
        Map<String, String> other$tblProperties = other.getTblProperties();
        if (this$tblProperties == null ? other$tblProperties != null : !((Object)this$tblProperties).equals(other$tblProperties)) {
            return false;
        }
        List<ColumnDesc> this$columns = this.getColumns();
        List<ColumnDesc> other$columns = other.getColumns();
        return !(this$columns == null ? other$columns != null : !((Object)this$columns).equals(other$columns));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof InternalTableDescResponse;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $uuid = this.getUuid();
        result = result * 59 + ($uuid == null ? 43 : $uuid.hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $databaseName = this.getDatabaseName();
        result = result * 59 + ($databaseName == null ? 43 : $databaseName.hashCode());
        String $timePartitionCol = this.getTimePartitionCol();
        result = result * 59 + ($timePartitionCol == null ? 43 : $timePartitionCol.hashCode());
        String $datePartitionFormat = this.getDatePartitionFormat();
        result = result * 59 + ($datePartitionFormat == null ? 43 : $datePartitionFormat.hashCode());
        long $hitCount = this.getHitCount();
        result = result * 59 + (int)($hitCount >>> 32 ^ $hitCount);
        long $rowCount = this.getRowCount();
        result = result * 59 + (int)($rowCount >>> 32 ^ $rowCount);
        long $storageSize = this.getStorageSize();
        result = result * 59 + (int)($storageSize >>> 32 ^ $storageSize);
        long $updateTime = this.getUpdateTime();
        result = result * 59 + (int)($updateTime >>> 32 ^ $updateTime);
        Map<String, String> $tblProperties = this.getTblProperties();
        result = result * 59 + ($tblProperties == null ? 43 : ((Object)$tblProperties).hashCode());
        List<ColumnDesc> $columns = this.getColumns();
        result = result * 59 + ($columns == null ? 43 : ((Object)$columns).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "InternalTableDescResponse(uuid=" + this.getUuid() + ", tableName=" + this.getTableName() + ", databaseName=" + this.getDatabaseName() + ", timePartitionCol=" + this.getTimePartitionCol() + ", datePartitionFormat=" + this.getDatePartitionFormat() + ", hitCount=" + this.getHitCount() + ", rowCount=" + this.getRowCount() + ", storageSize=" + this.getStorageSize() + ", updateTime=" + this.getUpdateTime() + ", tblProperties=" + this.getTblProperties() + ", columns=" + this.getColumns() + ")";
    }
}

