/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.reactivestreams.Publisher;
import org.springframework.data.geo.Circle;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.GeoResult;
import org.springframework.data.geo.Metric;
import org.springframework.data.geo.Point;
import org.springframework.data.redis.connection.RedisGeoCommands;
import org.springframework.data.redis.domain.geo.BoundingBox;
import org.springframework.data.redis.domain.geo.GeoReference;
import org.springframework.data.redis.domain.geo.GeoShape;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface ReactiveGeoOperations<K, M> {
    public Mono<Long> add(K var1, Point var2, M var3);

    public Mono<Long> add(K var1, RedisGeoCommands.GeoLocation<M> var2);

    public Mono<Long> add(K var1, Map<M, Point> var2);

    public Mono<Long> add(K var1, Iterable<RedisGeoCommands.GeoLocation<M>> var2);

    public Flux<Long> add(K var1, Publisher<? extends Collection<RedisGeoCommands.GeoLocation<M>>> var2);

    public Mono<Distance> distance(K var1, M var2, M var3);

    public Mono<Distance> distance(K var1, M var2, M var3, Metric var4);

    public Mono<String> hash(K var1, M var2);

    public Mono<List<String>> hash(K var1, M ... var2);

    public Mono<Point> position(K var1, M var2);

    public Mono<List<Point>> position(K var1, M ... var2);

    public Flux<GeoResult<RedisGeoCommands.GeoLocation<M>>> radius(K var1, Circle var2);

    public Flux<GeoResult<RedisGeoCommands.GeoLocation<M>>> radius(K var1, Circle var2, RedisGeoCommands.GeoRadiusCommandArgs var3);

    public Flux<GeoResult<RedisGeoCommands.GeoLocation<M>>> radius(K var1, M var2, double var3);

    public Flux<GeoResult<RedisGeoCommands.GeoLocation<M>>> radius(K var1, M var2, Distance var3);

    public Flux<GeoResult<RedisGeoCommands.GeoLocation<M>>> radius(K var1, M var2, Distance var3, RedisGeoCommands.GeoRadiusCommandArgs var4);

    public Mono<Long> remove(K var1, M ... var2);

    public Mono<Boolean> delete(K var1);

    default public Flux<GeoResult<RedisGeoCommands.GeoLocation<M>>> search(K key, Circle within) {
        return this.search(key, GeoReference.fromCircle(within), GeoShape.byRadius(within.getRadius()), RedisGeoCommands.GeoSearchCommandArgs.newGeoSearchArgs());
    }

    default public Flux<GeoResult<RedisGeoCommands.GeoLocation<M>>> search(K key, GeoReference<M> reference, Distance radius) {
        return this.search(key, reference, radius, RedisGeoCommands.GeoSearchCommandArgs.newGeoSearchArgs());
    }

    default public Flux<GeoResult<RedisGeoCommands.GeoLocation<M>>> search(K key, GeoReference<M> reference, Distance radius, RedisGeoCommands.GeoSearchCommandArgs args) {
        return this.search(key, reference, GeoShape.byRadius(radius), args);
    }

    default public Flux<GeoResult<RedisGeoCommands.GeoLocation<M>>> search(K key, GeoReference<M> reference, BoundingBox boundingBox) {
        return this.search(key, reference, boundingBox, RedisGeoCommands.GeoSearchCommandArgs.newGeoSearchArgs());
    }

    default public Flux<GeoResult<RedisGeoCommands.GeoLocation<M>>> search(K key, GeoReference<M> reference, BoundingBox boundingBox, RedisGeoCommands.GeoSearchCommandArgs args) {
        return this.search(key, reference, GeoShape.byBox(boundingBox), args);
    }

    public Flux<GeoResult<RedisGeoCommands.GeoLocation<M>>> search(K var1, GeoReference<M> var2, GeoShape var3, RedisGeoCommands.GeoSearchCommandArgs var4);

    default public Mono<Long> searchAndStore(K key, K destKey, Circle within) {
        return this.searchAndStore(key, destKey, GeoReference.fromCircle(within), GeoShape.byRadius(within.getRadius()), RedisGeoCommands.GeoSearchStoreCommandArgs.newGeoSearchStoreArgs());
    }

    default public Mono<Long> searchAndStore(K key, K destKey, GeoReference<M> reference, Distance radius) {
        return this.searchAndStore(key, destKey, reference, radius, RedisGeoCommands.GeoSearchStoreCommandArgs.newGeoSearchStoreArgs());
    }

    default public Mono<Long> searchAndStore(K key, K destKey, GeoReference<M> reference, Distance radius, RedisGeoCommands.GeoSearchStoreCommandArgs args) {
        return this.searchAndStore(key, destKey, reference, GeoShape.byRadius(radius), args);
    }

    default public Mono<Long> searchAndStore(K key, K destKey, GeoReference<M> reference, BoundingBox boundingBox) {
        return this.searchAndStore(key, destKey, reference, boundingBox, RedisGeoCommands.GeoSearchStoreCommandArgs.newGeoSearchStoreArgs());
    }

    default public Mono<Long> searchAndStore(K key, K destKey, GeoReference<M> reference, BoundingBox boundingBox, RedisGeoCommands.GeoSearchStoreCommandArgs args) {
        return this.searchAndStore(key, destKey, reference, GeoShape.byBox(boundingBox), args);
    }

    public Mono<Long> searchAndStore(K var1, K var2, GeoReference<M> var3, GeoShape var4, RedisGeoCommands.GeoSearchStoreCommandArgs var5);
}

