/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.cache.memcached;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Arrays;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.kylin.common.Singletons;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.rest.cache.KylinCache;
import org.apache.kylin.rest.cache.memcached.CacheStats;
import org.apache.kylin.rest.cache.memcached.MemcachedCache;
import org.apache.kylin.rest.cache.memcached.MemcachedCacheConfig;
import org.apache.kylin.rest.cache.memcached.MemcachedChunkingCache;
import org.apache.kylin.rest.service.CommonQueryCacheSupporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;
import org.springframework.cache.support.SimpleValueWrapper;

public class CompositeMemcachedCache
implements KylinCache {
    private static final Logger logger = LoggerFactory.getLogger(CompositeMemcachedCache.class);
    private static final String PREFIX = "Kylin";
    private static final ConcurrentMap<String, Cache> cacheMap = new ConcurrentHashMap<String, Cache>(16);
    private static final MemcachedCacheConfig memcachedCacheConfig = (MemcachedCacheConfig)Singletons.getInstance(MemcachedCacheConfig.class);
    private static final Cache exceptionCache = new MemCachedCacheAdaptor(new MemcachedChunkingCache(MemcachedCache.create(memcachedCacheConfig, CommonQueryCacheSupporter.Type.EXCEPTION_QUERY_CACHE.rootCacheName, 86400)));
    private static final Cache schemaCache = new MemCachedCacheAdaptor(new MemcachedChunkingCache(MemcachedCache.create(memcachedCacheConfig, CommonQueryCacheSupporter.Type.SCHEMA_CACHE.rootCacheName, 86400)));
    private static final Cache successCache = new MemCachedCacheAdaptor(new MemcachedChunkingCache(MemcachedCache.create(memcachedCacheConfig, CommonQueryCacheSupporter.Type.SUCCESS_QUERY_CACHE.rootCacheName)));

    public static KylinCache getInstance() {
        try {
            return (KylinCache)Singletons.getInstance(CompositeMemcachedCache.class);
        }
        catch (RuntimeException e) {
            logger.error("Memcached init failed", (Throwable)e);
            return null;
        }
    }

    private void checkCacheType(String type) {
        if (type == null) {
            throw new NullPointerException("type can't be null");
        }
        if (!cacheMap.containsKey(type)) {
            throw new IllegalArgumentException("unsupported rootCacheName: " + type);
        }
    }

    private String getTypeProjectPrefix(String type, String project) {
        return String.format(Locale.ROOT, "%s-%s-%s-", PREFIX, type, project);
    }

    protected String serializeKey(Object key) {
        try {
            return JsonUtil.writeValueAsString((Object)key);
        }
        catch (JsonProcessingException e) {
            logger.warn("Can not convert key to String.", (Throwable)e);
            return null;
        }
    }

    public void put(String type, String project, Object key, Object value) {
        this.checkCacheType(type);
        String keyS = this.serializeKey(key);
        if (keyS == null) {
            logger.warn("write to cash failed for key can not convert to String");
            return;
        }
        keyS = this.getTypeProjectPrefix(type, project) + keyS;
        ((Cache)cacheMap.get(type)).put((Object)keyS, value);
    }

    public void update(String type, String project, Object key, Object value) {
        this.checkCacheType(type);
        String keyS = this.serializeKey(key);
        if (keyS == null) {
            logger.warn("write to cache failed for key can not convert to String");
            return;
        }
        keyS = this.getTypeProjectPrefix(type, project) + keyS;
        ((Cache)cacheMap.get(type)).put((Object)keyS, value);
    }

    public Object get(String type, String project, Object key) {
        this.checkCacheType(type);
        String keyS = this.serializeKey(key);
        if (keyS == null) {
            logger.warn("read from cache failed for key can not convert to String");
            return null;
        }
        keyS = this.getTypeProjectPrefix(type, project) + keyS;
        SimpleValueWrapper valueWrapper = (SimpleValueWrapper)((Cache)cacheMap.get(type)).get((Object)keyS);
        return valueWrapper == null ? null : valueWrapper.get();
    }

    public boolean remove(String type, String project, Object key) {
        this.checkCacheType(type);
        String keyS = this.serializeKey(key);
        if (keyS == null) {
            logger.warn("evict cache failed for key can not convert to String");
            return false;
        }
        keyS = this.getTypeProjectPrefix(type, project) + keyS;
        if (((Cache)cacheMap.get(type)).get((Object)keyS) == null) {
            return false;
        }
        ((Cache)cacheMap.get(type)).evict((Object)keyS);
        return true;
    }

    public void clearAll() {
        for (Cache cache : cacheMap.values()) {
            cache.clear();
        }
    }

    public void clearByType(String type, String project) {
        this.checkCacheType(type);
        String pattern = this.getTypeProjectPrefix(type, project);
        Cache cache = (Cache)cacheMap.get(type);
        if (cache instanceof MemCachedCacheAdaptor) {
            ((MemCachedCacheAdaptor)cache).clearByType(pattern);
        } else {
            logger.warn("cache do not support clear by project");
            cacheMap.clear();
        }
    }

    public String getName(String type) {
        this.checkCacheType(type);
        return ((Cache)cacheMap.get(type)).getName();
    }

    public CacheStats getCacheStats(String type) {
        this.checkCacheType(type);
        Cache cache = (Cache)cacheMap.get(type);
        if (cache instanceof MemCachedCacheAdaptor) {
            return ((MemCachedCacheAdaptor)cache).getCacheStats();
        }
        logger.warn("only support get cache stats with memcached adaptor, otherwise will return null");
        return null;
    }

    static {
        cacheMap.put(CommonQueryCacheSupporter.Type.EXCEPTION_QUERY_CACHE.rootCacheName, exceptionCache);
        cacheMap.put(CommonQueryCacheSupporter.Type.SCHEMA_CACHE.rootCacheName, schemaCache);
        cacheMap.put(CommonQueryCacheSupporter.Type.SUCCESS_QUERY_CACHE.rootCacheName, successCache);
    }

    public static class MemCachedCacheAdaptor
    implements Cache {
        private MemcachedCache memcachedCache;

        public MemCachedCacheAdaptor(MemcachedCache memcachedCache) {
            this.memcachedCache = memcachedCache;
        }

        public String getName() {
            return this.memcachedCache.getName();
        }

        public Object getNativeCache() {
            return this.memcachedCache.getNativeCache();
        }

        public CacheStats getCacheStats() {
            return this.memcachedCache.getStats();
        }

        public Cache.ValueWrapper get(Object key) {
            byte[] value = this.memcachedCache.get(key);
            if (value == null || value.length == 0) {
                return null;
            }
            return new SimpleValueWrapper(SerializationUtils.deserialize((byte[])value));
        }

        public void put(Object key, Object value) {
            this.memcachedCache.put(key, value);
        }

        public void evict(Object key) {
            this.memcachedCache.evict(key);
        }

        public void clear() {
            this.memcachedCache.clear();
        }

        public void clearByType(String pattern) {
            this.memcachedCache.clearByType(pattern);
        }

        public <T> T get(Object key, Class<T> type) {
            byte[] value = this.memcachedCache.get(key);
            if (value == null || value.length == 0) {
                return null;
            }
            Object obj = SerializationUtils.deserialize((byte[])value);
            if (obj != null && type != null && !type.isInstance(value)) {
                throw new IllegalStateException("Cached value is not of required type [" + type.getName() + "]: " + Arrays.toString(value));
            }
            return (T)obj;
        }

        public <T> T get(Object key, Callable<T> valueLoader) {
            throw new UnsupportedOperationException();
        }

        public Cache.ValueWrapper putIfAbsent(Object key, Object value) {
            byte[] existing = this.memcachedCache.get(key);
            if (existing == null || existing.length == 0) {
                this.memcachedCache.put(key, value);
                return null;
            }
            return new SimpleValueWrapper(SerializationUtils.deserialize((byte[])existing));
        }
    }
}

