/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.security;

import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.scheduler.EventBusFactory;
import org.apache.kylin.metadata.upgrade.GlobalAclVersionManager;
import org.apache.kylin.rest.security.AdminUserSyncEventNotifier;
import org.apache.kylin.rest.security.UserAclManager;
import org.apache.kylin.rest.service.UserAclService;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class AdminUserAspect {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AdminUserAspect.class);
    private List<String> adminUserList;
    @Autowired
    @Qualifier(value="userAclService")
    private UserAclService userAclService;
    private boolean superAdminInitialized = false;

    private boolean isUpgraded() {
        GlobalAclVersionManager versionManager = GlobalAclVersionManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv());
        return versionManager.exists();
    }

    private boolean isAdminUserUpgraded() {
        UserAclManager userAclManager = UserAclManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv());
        return userAclManager.listAclUsernames().size() > 0;
    }

    @AfterReturning(value="execution(* org.apache.kylin.rest.service.OpenUserService.listAdminUsers(..))", returning="adminUserList")
    public void doAfterListAdminUsers(List<String> adminUserList) {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        if (CollectionUtils.isEmpty(adminUserList)) {
            return;
        }
        if (kylinConfig.isJobNode() && this.isUpgraded() && !this.isAdminUserUpgraded()) {
            this.userAclService.syncAdminUserAcl(adminUserList, false);
        }
        if (kylinConfig.isJobNode() && !this.superAdminInitialized) {
            this.userAclService.syncSuperAdminUserAcl();
            this.superAdminInitialized = true;
            return;
        }
        if (Objects.isNull(this.adminUserList) || !CollectionUtils.isEqualCollection(adminUserList, this.adminUserList)) {
            EventBusFactory.getInstance().postSync((Object)new AdminUserSyncEventNotifier(adminUserList, true));
            this.adminUserList = adminUserList;
        }
    }
}

