/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.security;

import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.guava30.shaded.common.hash.HashFunction;
import org.apache.kylin.guava30.shaded.common.hash.Hashing;
import org.apache.kylin.rest.service.LdapUserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.util.Assert;

public class LdapAuthenticationProvider
implements AuthenticationProvider {
    private static final Logger logger = LoggerFactory.getLogger(LdapAuthenticationProvider.class);
    @Autowired
    @Qualifier(value="userService")
    LdapUserService ldapUserService;
    private final AuthenticationProvider authenticationProvider;
    private final HashFunction hf;

    public LdapAuthenticationProvider(AuthenticationProvider authenticationProvider) {
        Assert.notNull((Object)authenticationProvider, (String)"The embedded authenticationProvider should not be null.");
        this.authenticationProvider = authenticationProvider;
        this.hf = Hashing.murmur3_128();
    }

    public Authentication authenticate(Authentication authentication) {
        Authentication auth = null;
        try {
            auth = this.authenticationProvider.authenticate(authentication);
        }
        catch (BadCredentialsException e) {
            throw new BadCredentialsException(ErrorCodeServer.USER_LOGIN_FAILED.getMsg(new Object[0]), (Throwable)e);
        }
        catch (AuthenticationException ae) {
            logger.error("Failed to auth user: {}", (Object)authentication.getName(), (Object)ae);
            throw ae;
        }
        catch (IncorrectResultSizeDataAccessException e) {
            logger.error("Ldap username {} is not unique", (Object)authentication.getName());
            throw new BadCredentialsException(ErrorCodeServer.USER_LOGIN_FAILED.getMsg(new Object[0]), (Throwable)e);
        }
        if (auth.getDetails() == null) {
            throw new UsernameNotFoundException("User not found in LDAP, check whether he/she has been added to the groups.");
        }
        String userName = auth.getDetails() instanceof UserDetails ? ((UserDetails)auth.getDetails()).getUsername() : authentication.getName();
        this.ldapUserService.onUserAuthenticated(userName);
        logger.debug("Authenticated userName: {}", (Object)userName);
        return auth;
    }

    public boolean supports(Class<?> authentication) {
        return this.authenticationProvider.supports(authentication);
    }
}

