/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.persistence.metadata.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.kylin.common.persistence.AuditLog;
import org.apache.kylin.common.util.CompressionUtils;
import org.apache.kylin.guava30.shaded.common.io.ByteSource;
import org.springframework.jdbc.core.RowMapper;

public class AuditLogRowMapper
implements RowMapper<AuditLog> {
    public AuditLog mapRow(ResultSet rs, int rowNum) throws SQLException {
        long id = rs.getLong(1);
        String resPath = rs.getString(2);
        byte[] content = CompressionUtils.decompress(rs.getBytes(3));
        Long ts = rs.getLong(4);
        if (rs.wasNull()) {
            ts = null;
        }
        Long mvcc = rs.getLong(5);
        if (rs.wasNull()) {
            mvcc = null;
        }
        String unitId = rs.getString(6);
        String modelUuid = rs.getString(7);
        String operator = rs.getString(8);
        String instance = rs.getString(9);
        String project = rs.getString(10);
        boolean diffFlag = rs.getBoolean(11);
        return new AuditLog(id, resPath, content == null ? null : ByteSource.wrap((byte[])content), ts, mvcc, unitId, modelUuid, operator, instance, project, diffFlag);
    }
}

