/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Locale;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.KylinRuntimeException;
import org.apache.kylin.common.util.DefaultHostInfoFetcher;
import org.apache.kylin.common.util.HostInfoFetcher;
import org.apache.kylin.common.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.commons.util.InetUtils;
import org.springframework.cloud.commons.util.InetUtilsProperties;

public class AddressUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AddressUtil.class);
    public static String MAINTAIN_MODE_MOCK_PORT = "0000";
    private static String localIpAddressCache;
    private static HostInfoFetcher hostInfoFetcher;

    public static String getLocalInstance() {
        String serverIp = AddressUtil.getLocalHostExactAddress();
        return serverIp + ":" + KylinConfig.getInstanceFromEnv().getServerPort();
    }

    public static String getZkLocalInstance() {
        String hostname = hostInfoFetcher.getHostname();
        return hostname + ":" + KylinConfig.getInstanceFromEnv().getServerPort();
    }

    public static String convertHost(String serverHost) {
        String hostArr;
        String[] hostAndPort = serverHost.split(":");
        String host = hostAndPort[0];
        String port = hostAndPort[1];
        try {
            hostArr = InetAddress.getByName(host).getHostAddress() + ":" + port;
        }
        catch (UnknownHostException e) {
            hostArr = "127.0.0.1:" + port;
        }
        return hostArr;
    }

    public static String getMockPortAddress() {
        return AddressUtil.getLocalInstance().split(":")[0] + ":" + MAINTAIN_MODE_MOCK_PORT;
    }

    public static String getHostName() {
        String hostName = "localhost";
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            log.warn("use the InetAddress get host name failed!", (Throwable)e);
        }
        return hostName;
    }

    public static String getLocalServerInfo() {
        String hostName = AddressUtil.getHostName();
        String host = hostName + "_" + KylinConfig.getInstanceFromEnv().getServerPort();
        return host.replaceAll("[^(_a-zA-Z0-9)]", "");
    }

    public static String getServerInfo(String hostName, String port) {
        String host = hostName + "_" + port;
        return host.replaceAll("[^(_a-zA-Z0-9)]", "");
    }

    public static String getLocalHostExactAddress() {
        if (StringUtils.isEmpty((CharSequence)localIpAddressCache)) {
            String localIpAddress = KylinConfig.getInstanceFromEnv().getServerIpAddress();
            if (StringUtils.isNotBlank((CharSequence)localIpAddress)) {
                localIpAddressCache = localIpAddress;
            } else {
                try (InetUtils inetUtils = new InetUtils(new InetUtilsProperties());){
                    localIpAddressCache = inetUtils.findFirstNonLoopbackHostInfo().getIpAddress();
                }
            }
        }
        return localIpAddressCache;
    }

    public static boolean isSameHost(String driverHost) {
        try {
            String serverIp = AddressUtil.getLocalInstance().split(":")[0];
            String driverHostAddr = InetAddress.getByName(driverHost).getHostAddress();
            String keHost = AddressUtil.getZkLocalInstance().split(":")[0];
            return StringUtils.equals((CharSequence)driverHostAddr, (CharSequence)serverIp) || driverHost.equals(keHost);
        }
        catch (UnknownHostException e) {
            log.warn("use the InetAddress get host name failed! ", (Throwable)e);
            return false;
        }
    }

    public static String concatInstanceName() {
        return AddressUtil.getLocalHostExactAddress() + ":" + KylinConfig.getInstanceFromEnv().getServerPort();
    }

    public static void clearLocalIpAddressCache() {
        localIpAddressCache = null;
    }

    public static void validateHost(String host) {
        if (StringUtils.isNotBlank((CharSequence)host) && !StringHelper.validateHost(host)) {
            throw new IllegalArgumentException("Url contains disallowed chars, host: " + host);
        }
    }

    public static String extractIpAndPort(String urlString) {
        try {
            URL url = new URL(urlString);
            String host = url.getHost();
            int port = url.getPort();
            if (StringUtils.isEmpty((CharSequence)host)) {
                throw new KylinRuntimeException(String.format(Locale.ROOT, "Invalid or illegal URL: %s", urlString));
            }
            return host + ":" + port;
        }
        catch (MalformedURLException e) {
            throw new KylinRuntimeException(String.format(Locale.ROOT, "Invalid or illegal URL: %s", urlString), e);
        }
    }

    @Generated
    public static void setHostInfoFetcher(HostInfoFetcher hostInfoFetcher) {
        AddressUtil.hostInfoFetcher = hostInfoFetcher;
    }

    static {
        hostInfoFetcher = new DefaultHostInfoFetcher();
    }
}

